/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.network.server.packet;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import team.cqr.cqrepoured.entity.IServerAnimationReceiver;

public class SPacketUpdateAnimationOfEntity
implements IMessage {
    private int entityId;
    private String animationID;

    public SPacketUpdateAnimationOfEntity() {
    }

    SPacketUpdateAnimationOfEntity(Builder builder) {
        this.entityId = builder.getEntityID();
        this.animationID = builder.getValue();
    }

    public String getAnimationID() {
        return this.animationID;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.animationID = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.animationID);
    }

    public static Builder builder(IServerAnimationReceiver entity) {
        return new Builder(entity);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static class Builder {
        private int entityID;
        private String value;

        private Builder(IServerAnimationReceiver entity) {
            this.entityID = entity.getEntity().func_145782_y();
        }

        public Builder animate(String value) {
            this.value = value;
            return this;
        }

        String getValue() {
            return this.value;
        }

        int getEntityID() {
            return this.entityID;
        }

        @Nullable
        public SPacketUpdateAnimationOfEntity build() {
            try {
                return new SPacketUpdateAnimationOfEntity(this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }
}

