/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.tileentity;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.network.datasync.DataEntryBoolean;
import team.cqr.cqrepoured.network.datasync.DataEntryInt;
import team.cqr.cqrepoured.network.datasync.TileEntityDataManager;
import team.cqr.cqrepoured.tileentity.ITileEntitySyncable;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitantManager;

public class TileEntitySpawner
extends TileEntity
implements ITileEntitySyncable {
    private static final Random RANDOM = new Random();
    public final ItemStackHandler inventory = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            if (TileEntitySpawner.this.field_145850_b != null && !((TileEntitySpawner)TileEntitySpawner.this).field_145850_b.field_72995_K) {
                TileEntitySpawner.this.func_70296_d();
            }
        }
    };
    private final TileEntityDataManager dataManager = new TileEntityDataManager(this);
    private final DataEntryBoolean vanillaSpawner = new DataEntryBoolean("vanillaSpawner", false, true);
    private final DataEntryInt minSpawnDelay = new DataEntryInt("MinSpawnDelay", 200, true);
    private final DataEntryInt maxSpawnDelay = new DataEntryInt("MaxSpawnDelay", 800, true);
    private final DataEntryInt spawnCount = new DataEntryInt("SpawnCount", 4, true);
    private final DataEntryInt maxNearbyEntities = new DataEntryInt("MaxNearbyEntities", 6, true);
    private final DataEntryInt activatingRangeFromPlayer = new DataEntryInt("RequiredPlayerRange", 16, true);
    private final DataEntryInt spawnRange = new DataEntryInt("SpawnRange", 4, true);

    public TileEntitySpawner() {
        this.dataManager.register(this.vanillaSpawner);
        this.dataManager.register(this.minSpawnDelay);
        this.dataManager.register(this.maxSpawnDelay);
        this.dataManager.register(this.spawnCount);
        this.dataManager.register(this.maxNearbyEntities);
        this.dataManager.register(this.activatingRangeFromPlayer);
        this.dataManager.register(this.spawnRange);
    }

    @Override
    public TileEntityDataManager getDataManager() {
        return this.dataManager;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : super.getCapability(capability, facing));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        this.dataManager.write(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.dataManager.read(compound);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.dataManager.write(new NBTTagCompound()));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.dataManager.read(pkt.func_148857_g());
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return new TextComponentString(I18n.func_135052_a((String)"tile.spawner.name", (Object[])new Object[0]));
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isNonCreativePlayerInRange(CQRConfig.general.spawnerActivationDistance)) {
            this.turnBackIntoEntity();
        } else {
            this.getDataManager().checkIfDirtyAndSync();
        }
    }

    public void forceTurnBackIntoEntity() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            this.turnBackIntoEntity();
        }
    }

    protected void turnBackIntoEntity() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
            ArrayList<NBTTagCompound> entitiesToSpawn = new ArrayList<NBTTagCompound>();
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.func_190926_b() || !stack.func_77942_o()) continue;
                NBTTagCompound nbt = stack.func_77978_p().func_74775_l("EntityIn");
                while (!stack.func_190926_b()) {
                    entitiesToSpawn.add(nbt);
                    stack.func_190918_g(1);
                }
            }
            entitiesToSpawn.forEach(this::spawnEntityFromNBT);
        }
    }

    protected Entity spawnEntityFromNBT(NBTTagCompound entityTag) {
        Entity entity;
        if (entityTag.func_82582_d()) {
            return null;
        }
        if (entityTag.func_74779_i("id").equals("cqrepoured:dummy")) {
            DungeonInhabitant mobType = DungeonInhabitantManager.instance().getInhabitantByDistance(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p());
            entityTag.func_74778_a("id", mobType.getEntityID().toString());
        }
        if ((entity = EntityList.func_75615_a((NBTTagCompound)entityTag, (World)this.field_145850_b)) != null) {
            double offset = entity.field_70130_N < 0.96f ? 0.5 - (double)entity.field_70130_N * 0.5 : 0.02;
            double x = (double)this.field_174879_c.func_177958_n() + 0.5 + (RANDOM.nextDouble() - RANDOM.nextDouble()) * offset;
            double y = this.field_174879_c.func_177956_o();
            double z = (double)this.field_174879_c.func_177952_p() + 0.5 + (RANDOM.nextDouble() - RANDOM.nextDouble()) * offset;
            entity.func_70107_b(x, y, z);
            this.field_145850_b.func_72838_d(entity);
            NBTTagList passengers = entityTag.func_150295_c("Passengers", 10);
            for (NBTBase passengerNBT : passengers) {
                Entity passenger = this.spawnEntityFromNBT((NBTTagCompound)passengerNBT);
                passenger.func_184220_m(entity);
            }
        }
        return entity;
    }

    protected boolean isNonCreativePlayerInRange(double range) {
        if (range > 0.0) {
            double d = range * range;
            for (EntityPlayer player : this.field_145850_b.field_73010_i) {
                if (player.func_184812_l_() || player.func_175149_v() || !(player.func_174831_c(this.field_174879_c) < d)) continue;
                return true;
            }
        }
        return false;
    }

    public void setVanillaSpawner(int minSpawnDelay, int maxSpawnDelay, int spawnCount, int maxNearbyEntities, int activatingRangeFromPlayer, int spawnRange) {
        this.vanillaSpawner.set(true);
        this.minSpawnDelay.set(minSpawnDelay);
        this.maxSpawnDelay.set(maxSpawnDelay);
        this.spawnCount.set(spawnCount);
        this.maxNearbyEntities.set(maxNearbyEntities);
        this.activatingRangeFromPlayer.set(activatingRangeFromPlayer);
        this.spawnRange.set(spawnRange);
    }

    public void setCQRSpawner() {
        this.vanillaSpawner.set(false);
    }

    public boolean isVanillaSpawner() {
        return this.vanillaSpawner.getBoolean();
    }

    public int getMinSpawnDelay() {
        return this.minSpawnDelay.getInt();
    }

    public int getMaxSpawnDelay() {
        return this.maxSpawnDelay.getInt();
    }

    public int getSpawnCount() {
        return this.spawnCount.getInt();
    }

    public int getMaxNearbyEntities() {
        return this.maxNearbyEntities.getInt();
    }

    public int getActivatingRangeFromPlayer() {
        return this.activatingRangeFromPlayer.getInt();
    }

    public int getSpawnRange() {
        return this.spawnRange.getInt();
    }
}

