/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import team.cqr.cqrepoured.network.datasync.DataEntryByte;
import team.cqr.cqrepoured.network.datasync.DataEntryItemStackHandler;
import team.cqr.cqrepoured.network.datasync.TileEntityDataManager;
import team.cqr.cqrepoured.tileentity.ITileEntitySyncable;

public class TileEntityTable
extends TileEntity
implements ITileEntitySyncable {
    private final TileEntityDataManager dataManager = new TileEntityDataManager(this);
    private final DataEntryItemStackHandler inventory = new DataEntryItemStackHandler("inventory", new DataEntryItemStackHandler.CustomItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 1;
        }
    }, false);
    private final DataEntryByte rotation = new DataEntryByte("rotation", 0, false);

    public TileEntityTable() {
        this.dataManager.register(this.inventory);
        this.dataManager.register(this.rotation);
    }

    @Override
    public TileEntityDataManager getDataManager() {
        return this.dataManager;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory.get() : super.getCapability(capability, facing));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.dataManager.write(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.dataManager.read(compound);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.dataManager.write(new NBTTagCompound()));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.dataManager.read(pkt.func_148857_g());
    }

    public ITextComponent func_145748_c_() {
        ItemStack stack = ((ItemStackHandler)this.inventory.get()).getStackInSlot(0);
        return stack.func_82837_s() ? new TextComponentString(stack.func_82833_r()) : null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 2, 1));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void setRotation(int rotation) {
        if ((rotation %= 16) < 0) {
            rotation += 16;
        }
        this.rotation.set((byte)rotation);
    }

    public ItemStackHandler getInventory() {
        return (ItemStackHandler)this.inventory.get();
    }

    public int getRotation() {
        return this.rotation.getByte();
    }

    public float getRotationInDegree() {
        return (float)this.rotation.getByte() * 22.5f;
    }
}

