/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import java.util.Random;
import net.minecraft.util.math.MathHelper;

public class Perlin2D {
    private final Random rand = new Random();
    private long seed;
    private float tanSeed;
    private float frequency;

    public Perlin2D(long seed, float octave) {
        this.seed = seed;
        this.frequency = octave;
        this.tanSeed = (float)Math.tan(this.seed);
    }

    public void setup(long seed, float octave) {
        this.seed = seed;
        this.frequency = octave;
        this.tanSeed = (float)Math.tan(this.seed);
    }

    public float getNoiseAt(float x, float y) {
        float fx1 = x / this.frequency;
        float xmin = MathHelper.func_76141_d((float)fx1);
        float xmax = xmin + 1.0f;
        float fx2 = fx1 - xmin;
        float fy1 = y / this.frequency;
        float ymin = MathHelper.func_76141_d((float)fy1);
        float ymax = ymin + 1.0f;
        float fy2 = fy1 - ymin;
        float f1 = this.getRandomAtPosition(xmin, ymin);
        float f2 = this.getRandomAtPosition(xmin, ymax);
        float f3 = this.getRandomAtPosition(xmax, ymin);
        float f4 = this.getRandomAtPosition(xmax, ymax);
        float f11 = Perlin2D.cosineInterpolate(f1, f2, fy2);
        float f12 = Perlin2D.cosineInterpolate(f3, f4, fy2);
        return Perlin2D.cosineInterpolate(f11, f12, fx2);
    }

    private static float cosineInterpolate(float a, float b, float x) {
        float d = (1.0f - MathHelper.func_76134_b((float)(x * (float)Math.PI))) * 0.5f;
        return a * (1.0f - d) + b * d;
    }

    private static float linearInterpolate(float a, float b, float x) {
        return a * (1.0f - x) + b * x;
    }

    private float getRandomAtPosition(float x, float y) {
        long newSeed = (long)((MathHelper.func_76126_a((float)x) + MathHelper.func_76134_b((float)y) + this.tanSeed) * 10000.0f);
        this.rand.setSeed(newSeed);
        return this.rand.nextFloat();
    }
}

