/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class SpiralStaircaseBuilder {
    private static final int STAIR_WIDTH = 2;
    private BlockPos start;
    private EnumFacing firstSide;
    private IBlockState platformBlockState;
    private IBlockState stairBlockState;

    public SpiralStaircaseBuilder(BlockPos pillarStart, EnumFacing firstStairSide, IBlockState platformBlockState, IBlockState stairBlockState) {
        this.start = pillarStart;
        this.firstSide = firstStairSide;
        this.platformBlockState = platformBlockState;
        this.stairBlockState = stairBlockState;
    }

    public boolean isPartOfStairs(BlockPos position) {
        return Math.abs(position.func_177958_n() - this.start.func_177958_n()) <= 2 && Math.abs(position.func_177952_p() - this.start.func_177952_p()) <= 2 && position.func_177956_o() >= this.start.func_177956_o();
    }

    public IBlockState getBlock(BlockPos position) {
        int startX = this.start.func_177958_n();
        int startZ = this.start.func_177952_p();
        int posX = position.func_177958_n();
        int posZ = position.func_177952_p();
        if (position.func_177958_n() == this.start.func_177958_n() && position.func_177952_p() == this.start.func_177952_p()) {
            return this.platformBlockState;
        }
        EnumFacing stairSide = this.rotateFacingNTimesCW(this.firstSide, Math.abs(position.func_177956_o() - this.start.func_177956_o()));
        EnumFacing stairFacing = this.rotateFacingNTimesCW(stairSide, 1);
        switch (stairSide) {
            case NORTH: {
                if (posX == startX && this.inBoundsNoZero(posZ, startZ, -2)) {
                    return this.stairBlockState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing);
                }
                if (!this.inBoundsNoZero(posX, startX, 2) || !this.inBoundsWithZero(posZ, startZ, -2)) break;
                return this.platformBlockState;
            }
            case SOUTH: {
                if (posX == startX && this.inBoundsNoZero(posZ, startZ, 2)) {
                    return this.stairBlockState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing);
                }
                if (!this.inBoundsNoZero(posX, startX, -2) || !this.inBoundsWithZero(posZ, startZ, 2)) break;
                return this.platformBlockState;
            }
            case WEST: {
                if (this.inBoundsNoZero(posX, startX, -2) && posZ == startZ) {
                    return this.stairBlockState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing);
                }
                if (!this.inBoundsWithZero(posX, startX, -2) || !this.inBoundsNoZero(posZ, startZ, -2)) break;
                return this.platformBlockState;
            }
            case EAST: {
                if (this.inBoundsNoZero(posX, startX, 2) && posZ == startZ) {
                    return this.stairBlockState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing);
                }
                if (!this.inBoundsWithZero(posX, startX, 2) || !this.inBoundsNoZero(posZ, startZ, 2)) break;
                return this.platformBlockState;
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private EnumFacing rotateFacingNTimesCW(EnumFacing facing, int n) {
        n %= 4;
        while (n != 0) {
            facing = facing.func_176746_e();
            --n;
        }
        return facing;
    }

    private boolean inBoundsNoZero(int pos, int start, int distance) {
        int diff = pos - start;
        if (distance > 0) {
            return diff > 0 && diff <= distance;
        }
        return diff < 0 && diff >= distance;
    }

    private boolean inBoundsWithZero(int pos, int start, int distance) {
        int diff = pos - start;
        if (distance > 0) {
            return diff >= 0 && diff <= distance;
        }
        return diff <= 0 && diff >= distance;
    }
}

