/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ReportedException;

public class FileIOUtil {
    private static final FilenameFilter NBT_FILE_FILTER = (dir, name) -> name.endsWith(".nbt");

    public static FilenameFilter getNBTFileFilter() {
        return NBT_FILE_FILTER;
    }

    public static void writeNBTToFile(NBTTagCompound compound, File file) {
        try {
            file.getParentFile().mkdirs();
            try (FileOutputStream outStream = new FileOutputStream(file);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)outStream);
            }
        }
        catch (IOException e) {
            CrashReport crash = new CrashReport("Failed writing NBT to file!", (Throwable)e);
            FileIOUtil.addFileInfo(crash, file);
            throw new ReportedException(crash);
        }
    }

    public static NBTTagCompound readNBTFromFile(File file) {
        try {
            NBTTagCompound compound;
            try (FileInputStream in = new FileInputStream(file);){
                compound = CompressedStreamTools.func_74796_a((InputStream)in);
            }
            return compound;
        }
        catch (IOException e) {
            CrashReport crash = new CrashReport("Failed reading NBT from file!", (Throwable)e);
            FileIOUtil.addFileInfo(crash, file);
            throw new ReportedException(crash);
        }
    }

    public static void writePropToFile(Properties prop, File file) {
        try {
            file.getParentFile().mkdirs();
            try (FileOutputStream out = new FileOutputStream(file);){
                prop.store(out, null);
            }
        }
        catch (IOException e) {
            CrashReport crash = new CrashReport("Failed writing Properties to file!", (Throwable)e);
            FileIOUtil.addFileInfo(crash, file);
            throw new ReportedException(crash);
        }
    }

    public static Properties readPropFromFile(File file) {
        try {
            Properties prop = new Properties();
            try (FileInputStream in = new FileInputStream(file);){
                prop.load(in);
            }
            return prop;
        }
        catch (IOException e) {
            CrashReport crash = new CrashReport("Failed reading Properties from file!", (Throwable)e);
            FileIOUtil.addFileInfo(crash, file);
            throw new ReportedException(crash);
        }
    }

    private static void addFileInfo(CrashReport crash, File file) {
        CrashReportCategory category = crash.func_85058_a("File Info");
        category.func_71507_a("File", (Object)file);
    }
}

