/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util.datafixer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import meldexun.reflectionutil.ReflectionMethod;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.storage.WorldInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableBannerInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableBlockInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableBossInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableEmptyInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableForceFieldNexusInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableLootChestInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableMapInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparablePosInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableSpawnerInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableTNTCQRInfo;
import team.cqr.cqrepoured.world.structure.generation.structurefile.BlockStatePalette;
import team.cqr.cqrepoured.world.structure.generation.structurefile.CQStructure;

public class StructureUpper {
    public static NBTTagCompound createMigratableNBT(CQStructure structure) {
        World world = new World(null, new WorldInfo(new WorldSettings(0L, GameType.CREATIVE, false, false, WorldType.field_180271_f), "temp"), (WorldProvider)new WorldProviderHell(), null, false){

            protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
                return false;
            }

            protected IChunkProvider func_72970_h() {
                return null;
            }
        };
        HashMap<ChunkPos, ChunkTileEntityContainer> chunks = new HashMap<ChunkPos, ChunkTileEntityContainer>();
        ChunkTileEntityContainer entityChunk = new ChunkTileEntityContainer(new Chunk(world, 0, 0));
        ByteBuf blockBuf = Unpooled.buffer();
        ByteBuf entityBuf = Unpooled.buffer();
        BlockStatePalette palette = new BlockStatePalette();
        NBTTagList compoundList = new NBTTagList();
        entityBuf.writeInt(structure.getEntityInfoList().size());
        structure.getEntityInfoList().forEach(entity -> entityBuf.writeInt(StructureUpper.addEntity(entityChunk, entity.getEntityData())));
        BlockPos size = structure.getSize();
        List<PreparablePosInfo> blocks = structure.getBlockInfoList();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < size.func_177958_n(); ++x) {
            for (int y = 0; y < size.func_177956_o(); ++y) {
                for (int z = 0; z < size.func_177952_p(); ++z) {
                    pos.func_181079_c(x, y, z);
                    PreparablePosInfo block = blocks.get((x * size.func_177956_o() + y) * size.func_177952_p() + z);
                    Class<?> blockClass = block.getClass();
                    if (blockClass == PreparableEmptyInfo.class) {
                        PreparablePosInfo.Registry.write(block, blockBuf, palette, compoundList);
                        continue;
                    }
                    if (blockClass == PreparableBlockInfo.class) {
                        boolean vanillaBlock = ((PreparableBlockInfo)block).getState().func_177230_c().getRegistryName().func_110624_b().equals("minecraft");
                        blockBuf.writeByte(1);
                        blockBuf.writeBoolean(vanillaBlock);
                        if (vanillaBlock) {
                            StructureUpper.setBlock(world, chunks, (BlockPos)pos, ((PreparableBlockInfo)block).getState(), ((PreparableBlockInfo)block).getTileEntityData());
                            continue;
                        }
                        PreparablePosInfo.Registry.write(block, blockBuf, palette, compoundList);
                        continue;
                    }
                    if (blockClass == PreparableBannerInfo.class) {
                        blockBuf.writeByte(2);
                        StructureUpper.setBlock(world, chunks, (BlockPos)pos, ((PreparableBannerInfo)block).getState(), ((PreparableBannerInfo)block).getTileEntityData());
                        continue;
                    }
                    if (blockClass == PreparableBossInfo.class) {
                        blockBuf.writeByte(3);
                        NBTTagCompound bossTag = ((PreparableBossInfo)block).getBossTag();
                        blockBuf.writeBoolean(bossTag != null);
                        if (bossTag == null) continue;
                        blockBuf.writeInt(StructureUpper.addEntity(entityChunk, bossTag));
                        continue;
                    }
                    if (blockClass == PreparableForceFieldNexusInfo.class) {
                        PreparablePosInfo.Registry.write(block, blockBuf, palette, compoundList);
                        continue;
                    }
                    if (blockClass == PreparableLootChestInfo.class) {
                        PreparablePosInfo.Registry.write(block, blockBuf, palette, compoundList);
                        continue;
                    }
                    if (blockClass == PreparableSpawnerInfo.class) {
                        blockBuf.writeByte(6);
                        NBTTagCompound spawnerTag = ((PreparableSpawnerInfo)block).getTileEntityData();
                        blockBuf.writeInt(compoundList.func_74745_c());
                        compoundList.func_74742_a((NBTBase)spawnerTag);
                        NBTTagList items = spawnerTag.func_74775_l("inventory").func_150295_c("Items", 10);
                        blockBuf.writeByte(items.func_74745_c());
                        items.forEach(item -> blockBuf.writeInt(StructureUpper.addEntity(entityChunk, ((NBTTagCompound)item).func_74775_l("tag").func_74775_l("EntityIn"))));
                        continue;
                    }
                    if (blockClass == PreparableMapInfo.class) {
                        PreparablePosInfo.Registry.write(block, blockBuf, palette, compoundList);
                        continue;
                    }
                    if (blockClass != PreparableTNTCQRInfo.class) continue;
                    PreparablePosInfo.Registry.write(block, blockBuf, palette, compoundList);
                }
            }
        }
        NBTTagCompound migratableStructureNbt = new NBTTagCompound();
        NBTTagCompound chunkNbt = new NBTTagCompound();
        chunks.forEach((p, c) -> chunkNbt.func_74782_a(p.field_77276_a + " " + p.field_77275_b, (NBTBase)c.save(new NBTTagCompound())));
        chunkNbt.func_74782_a("entityChunk", (NBTBase)entityChunk.save(new NBTTagCompound()));
        migratableStructureNbt.func_74782_a("Chunk Data", (NBTBase)chunkNbt);
        NBTTagCompound cqrStructureNbt = new NBTTagCompound();
        cqrStructureNbt.func_74778_a("cqr_file_version", "1.2.0");
        cqrStructureNbt.func_74778_a("author", structure.getAuthor());
        cqrStructureNbt.func_74782_a("size", (NBTBase)NBTUtil.func_186859_a((BlockPos)structure.getSize()));
        cqrStructureNbt.func_74773_a("blockInfoList", Arrays.copyOf(blockBuf.array(), blockBuf.writerIndex()));
        cqrStructureNbt.func_74773_a("entityInfoList", Arrays.copyOf(entityBuf.array(), entityBuf.writerIndex()));
        cqrStructureNbt.func_74782_a("palette", (NBTBase)palette.writeToNBT());
        cqrStructureNbt.func_74782_a("compoundTagList", (NBTBase)compoundList);
        cqrStructureNbt.func_74783_a("unprotectedBlockList", structure.getUnprotectedBlockList().stream().flatMapToInt(p -> IntStream.of(p.func_177958_n(), p.func_177956_o(), p.func_177952_p())).toArray());
        migratableStructureNbt.func_74782_a("CQR Structure Data", (NBTBase)cqrStructureNbt);
        return migratableStructureNbt;
    }

    private static ChunkTileEntityContainer getChunk(World world, Map<ChunkPos, ChunkTileEntityContainer> chunks, BlockPos pos) {
        return chunks.computeIfAbsent(new ChunkPos(pos), k -> new ChunkTileEntityContainer(new Chunk(world, k.field_77276_a, k.field_77275_b)));
    }

    private static void setBlock(World world, Map<ChunkPos, ChunkTileEntityContainer> chunks, BlockPos pos, IBlockState state, @Nullable NBTTagCompound tileEntity) {
        ChunkTileEntityContainer chunk = StructureUpper.getChunk(world, chunks, pos);
        ExtendedBlockStorage[] sections = chunk.chunk.func_76587_i();
        ExtendedBlockStorage section = sections[pos.func_177956_o() >> 4];
        if (section == null) {
            sections[pos.func_177956_o() >> 4] = section = new ExtendedBlockStorage(pos.func_177956_o() >> 4 << 4, false);
        }
        section.func_177484_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, state);
        if (tileEntity != null) {
            tileEntity.func_74768_a("x", pos.func_177958_n());
            tileEntity.func_74768_a("y", pos.func_177956_o());
            tileEntity.func_74768_a("z", pos.func_177952_p());
            chunk.tileEntities.func_74742_a((NBTBase)tileEntity);
        }
    }

    private static int addEntity(World world, Map<ChunkPos, ChunkTileEntityContainer> chunks, NBTTagCompound entity) {
        double x = entity.func_74764_b("TileX") ? (double)entity.func_74762_e("TileX") : entity.func_150295_c("Pos", 6).func_150309_d(0);
        double y = entity.func_74764_b("TileY") ? (double)entity.func_74762_e("TileY") : entity.func_150295_c("Pos", 6).func_150309_d(1);
        double z = entity.func_74764_b("TileZ") ? (double)entity.func_74762_e("TileZ") : entity.func_150295_c("Pos", 6).func_150309_d(2);
        ChunkTileEntityContainer chunk = StructureUpper.getChunk(world, chunks, new BlockPos(x, y, z));
        return StructureUpper.addEntity(chunk, entity);
    }

    private static int addEntity(ChunkTileEntityContainer chunk, NBTTagCompound entity) {
        chunk.entities.func_74742_a((NBTBase)entity);
        return chunk.entities.func_74745_c() - 1;
    }

    private static class ChunkTileEntityContainer {
        private static final AnvilChunkLoader CHUNK_SERIALIZER = new AnvilChunkLoader(null, null);
        private static final ReflectionMethod<Void> M_WRITE_CHUNK_TO_NBT = new ReflectionMethod(AnvilChunkLoader.class, "writeChunkToNBT", "TODO", Chunk.class, World.class, NBTTagCompound.class);
        private final Chunk chunk;
        private final NBTTagList tileEntities = new NBTTagList();
        private final NBTTagList entities = new NBTTagList();

        public ChunkTileEntityContainer(Chunk chunk) {
            this.chunk = chunk;
        }

        public NBTTagCompound save(NBTTagCompound nbt) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            M_WRITE_CHUNK_TO_NBT.invoke(CHUNK_SERIALIZER, this.chunk, this.chunk.func_177412_p(), nbt1);
            nbt1.func_74782_a("TileEntities", (NBTBase)this.tileEntities);
            nbt1.func_74782_a("Entities", (NBTBase)this.entities);
            nbt.func_74782_a("Level", (NBTBase)nbt1);
            nbt.func_74768_a("DataVersion", 1343);
            return nbt;
        }
    }
}

