/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util.math;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import team.cqr.cqrepoured.util.math.Line;
import team.cqr.cqrepoured.util.math.Square;

public class BoundingBox {
    private final Vec3d[] vertices;
    private final Line[] edges;
    private final Square[] planes;
    private double minX;
    private double minY;
    private double minZ;
    private double maxX;
    private double maxY;
    private double maxZ;
    private final AxisAlignedBB aabb;

    public BoundingBox(Vec3d[] vertices, int[][] edges, int[][] planes) {
        int i;
        this.vertices = vertices;
        this.minX = vertices[0].field_72450_a;
        this.minY = vertices[0].field_72448_b;
        this.minZ = vertices[0].field_72449_c;
        this.maxX = vertices[0].field_72450_a;
        this.maxY = vertices[0].field_72448_b;
        this.maxZ = vertices[0].field_72449_c;
        for (i = 1; i < vertices.length; ++i) {
            Vec3d vec = vertices[i];
            this.minX = Math.min(this.minX, vec.field_72450_a);
            this.minY = Math.min(this.minY, vec.field_72448_b);
            this.minZ = Math.min(this.minZ, vec.field_72449_c);
            this.maxX = Math.max(this.maxX, vec.field_72450_a);
            this.maxY = Math.max(this.maxY, vec.field_72448_b);
            this.maxZ = Math.max(this.maxZ, vec.field_72449_c);
        }
        this.aabb = new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        this.edges = new Line[edges.length];
        for (i = 0; i < edges.length; ++i) {
            this.edges[i] = new Line(vertices[edges[i][0]], vertices[edges[i][1]]);
        }
        this.planes = new Square[planes.length];
        for (i = 0; i < planes.length; ++i) {
            this.planes[i] = new Square(vertices[planes[i][0]], vertices[planes[i][1]], vertices[planes[i][2]], vertices[planes[i][3]]);
        }
    }

    public BoundingBox(Vec3d[] vertices) {
        this(vertices, new int[][]{{0, 1}, {1, 3}, {3, 2}, {2, 0}, {0, 4}, {1, 5}, {3, 7}, {2, 6}, {4, 5}, {5, 7}, {7, 6}, {6, 4}}, new int[][]{{2, 3, 0, 1}, {0, 1, 4, 5}, {1, 3, 5, 7}, {3, 2, 7, 6}, {2, 0, 6, 4}, {4, 5, 6, 7}});
    }

    public BoundingBox(Vec3d start, Vec3d end, double yaw, double pitch, Vec3d origin) {
        this(new Vec3d[]{BoundingBox.rotatePitchYaw(start, (float)(-pitch), (float)(-yaw)).func_178787_e(origin), BoundingBox.rotatePitchYaw(new Vec3d(end.field_72450_a, start.field_72448_b, start.field_72449_c), (float)(-pitch), (float)(-yaw)).func_178787_e(origin), BoundingBox.rotatePitchYaw(new Vec3d(start.field_72450_a, start.field_72448_b, end.field_72449_c), (float)(-pitch), (float)(-yaw)).func_178787_e(origin), BoundingBox.rotatePitchYaw(new Vec3d(end.field_72450_a, start.field_72448_b, end.field_72449_c), (float)(-pitch), (float)(-yaw)).func_178787_e(origin), BoundingBox.rotatePitchYaw(new Vec3d(start.field_72450_a, end.field_72448_b, start.field_72449_c), (float)(-pitch), (float)(-yaw)).func_178787_e(origin), BoundingBox.rotatePitchYaw(new Vec3d(end.field_72450_a, end.field_72448_b, start.field_72449_c), (float)(-pitch), (float)(-yaw)).func_178787_e(origin), BoundingBox.rotatePitchYaw(new Vec3d(start.field_72450_a, end.field_72448_b, end.field_72449_c), (float)(-pitch), (float)(-yaw)).func_178787_e(origin), BoundingBox.rotatePitchYaw(end, (float)(-pitch), (float)(-yaw)).func_178787_e(origin)});
    }

    public BoundingBox(AxisAlignedBB aabb, double yaw, double pitch, Vec3d origin) {
        this(new Vec3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), new Vec3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f), yaw, pitch, origin);
    }

    public boolean isVecInside(Vec3d vec) {
        for (Square plane : this.planes) {
            if (plane.isVecBehindPlane(vec)) continue;
            return false;
        }
        return true;
    }

    public Vec3d[] getVertices() {
        Vec3d[] copy = new Vec3d[this.vertices.length];
        System.arraycopy(this.vertices, 0, copy, 0, this.vertices.length);
        return copy;
    }

    public Line[] getEdges() {
        Line[] copy = new Line[this.edges.length];
        System.arraycopy(this.edges, 0, copy, 0, this.edges.length);
        return copy;
    }

    public Square[] getPlanes() {
        Square[] copy = new Square[this.planes.length];
        System.arraycopy(this.planes, 0, copy, 0, this.planes.length);
        return copy;
    }

    public AxisAlignedBB getAabb() {
        return this.aabb;
    }

    private static Vec3d rotatePitchYaw(Vec3d vec, float pitch, float yaw) {
        return BoundingBox.rotateYaw(BoundingBox.rotatePitch(vec, pitch), yaw);
    }

    private static Vec3d rotatePitch(Vec3d vec, float pitch) {
        return (double)Math.abs(pitch) > 1.0E-4 ? vec.func_178789_a(pitch) : vec;
    }

    private static Vec3d rotateYaw(Vec3d vec, float yaw) {
        return (double)Math.abs(yaw) > 1.0E-4 ? vec.func_178785_b(yaw) : vec;
    }

    public static <T extends Entity> List<T> getEntitiesInsideBB(World world, @Nullable T toIgnore, Class<T> entityClass, BoundingBox bb1) {
        return world.func_175647_a(entityClass, bb1.getAabb(), input -> {
            if (input == toIgnore) {
                return false;
            }
            BoundingBox bb2 = new BoundingBox(input.func_174813_aQ(), 0.0, 0.0, Vec3d.field_186680_a);
            for (Vec3d vertice : bb2.vertices) {
                if (!bb1.isVecInside(vertice)) continue;
                return true;
            }
            for (Vec3d vertice : bb1.vertices) {
                if (!bb2.isVecInside(vertice)) continue;
                return true;
            }
            return BoundingBox.checkIfEdgeHitsPlane(bb1, bb2);
        });
    }

    private static boolean checkIfEdgeHitsPlane(BoundingBox bb1, BoundingBox bb2) {
        for (Line edge : bb1.edges) {
            Vec3d lineDirection = edge.vec2.func_178788_d(edge.vec1);
            Vec3d lineDirectionNormalized = lineDirection.func_72432_b();
            for (Square plane : bb2.planes) {
                int i2;
                Vec3d intersectionPoint;
                int i1;
                Vec3d planeNormal = plane.vec2.func_178788_d(plane.vec1).func_72431_c(plane.vec3.func_178788_d(plane.vec1));
                if (planeNormal.func_72430_b(lineDirectionNormalized) == 0.0) continue;
                Vec3d vec = lineDirectionNormalized.func_186678_a((planeNormal.func_72430_b(plane.vec1) - planeNormal.func_72430_b(edge.vec1)) / planeNormal.func_72430_b(lineDirectionNormalized));
                if (vec.field_72450_a < 0.0 != lineDirection.field_72450_a < 0.0 || vec.field_72448_b < 0.0 != lineDirection.field_72448_b < 0.0 || vec.field_72449_c < 0.0 != lineDirection.field_72449_c < 0.0 || vec.func_189985_c() > lineDirection.func_189985_c() || (i1 = (int)(1000.0 * BoundingBox.getAreaOfTriangle(intersectionPoint = edge.vec1.func_178787_e(vec), plane.vec1, plane.vec2)) + (int)(1000.0 * BoundingBox.getAreaOfTriangle(intersectionPoint, plane.vec2, plane.vec4)) + (int)(1000.0 * BoundingBox.getAreaOfTriangle(intersectionPoint, plane.vec4, plane.vec3)) + (int)(1000.0 * BoundingBox.getAreaOfTriangle(intersectionPoint, plane.vec3, plane.vec1))) > (i2 = (int)(1000.0 * BoundingBox.getAreaOfTriangle(plane.vec1, plane.vec2, plane.vec3)) + (int)(1000.0 * BoundingBox.getAreaOfTriangle(plane.vec2, plane.vec3, plane.vec4))) + 100) continue;
                return true;
            }
        }
        return false;
    }

    private static double getAreaOfTriangle(Vec3d vec1, Vec3d vec2, Vec3d vec3) {
        Vec3d v1 = vec2.func_178788_d(vec1);
        Vec3d v2 = vec3.func_178788_d(vec1);
        return 0.5 * v1.func_72431_c(v2).func_72433_c();
    }
}

