/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.cqr.cqrepoured.util.data.FileIOUtil;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonBase;

public class DungeonDataManager {
    private static final Map<World, DungeonDataManager> INSTANCES = new HashMap<World, DungeonDataManager>();
    private final SetMultimap<String, DungeonInfo> dungeonData = HashMultimap.create();
    private final File file;
    private boolean modifiedSinceLastSave = false;

    public DungeonDataManager(World world) {
        int dim = world.field_73011_w.getDimension();
        this.file = dim == 0 ? new File(world.func_72860_G().func_75765_b(), "data/CQR/structures.nbt") : new File(world.func_72860_G().func_75765_b(), "DIM" + dim + "/data/CQR/structures.nbt");
    }

    public static void onWorldLoad(World world) {
        INSTANCES.computeIfAbsent(world, k -> {
            DungeonDataManager v = new DungeonDataManager((World)k);
            v.readData();
            return v;
        });
    }

    public static void onWorldSave(World world) {
        INSTANCES.get(world).saveData();
    }

    public static void onWorldUnload(World world) {
        INSTANCES.get(world).saveData();
        INSTANCES.remove(world);
    }

    public static void addDungeonEntry(World world, DungeonBase dungeon, BlockPos position, DungeonSpawnType spawnType) {
        INSTANCES.get(world).addDungeonEntry(dungeon, position, spawnType);
    }

    public static Set<String> getSpawnedDungeonNames(World world) {
        return INSTANCES.get(world).getSpawnedDungeonNames();
    }

    public static Set<DungeonInfo> getLocationsOfDungeon(World world, DungeonBase dungeon) {
        return INSTANCES.get(world).getLocationsOfDungeon(dungeon);
    }

    public static boolean isDungeonSpawnLimitMet(World world, DungeonBase dungeon) {
        return INSTANCES.get(world).isDungeonSpawnLimitMet(dungeon);
    }

    public void saveData() {
        if (this.modifiedSinceLastSave) {
            NBTTagCompound root = new NBTTagCompound();
            for (Map.Entry data : this.dungeonData.asMap().entrySet()) {
                Collection dungeonInfos = (Collection)data.getValue();
                if (dungeonInfos.isEmpty()) continue;
                NBTTagList nbtTagList = new NBTTagList();
                for (DungeonInfo dungeonInfo : dungeonInfos) {
                    nbtTagList.func_74742_a((NBTBase)dungeonInfo.writeToNBT());
                }
                root.func_74782_a((String)data.getKey(), (NBTBase)nbtTagList);
            }
            FileIOUtil.writeNBTToFile(root, this.file);
            this.modifiedSinceLastSave = false;
        }
    }

    public void readData() {
        this.dungeonData.clear();
        if (!this.file.exists()) {
            return;
        }
        NBTTagCompound root = FileIOUtil.readNBTFromFile(this.file);
        for (String key : root.func_150296_c()) {
            for (NBTBase nbt : root.func_150295_c(key, 10)) {
                this.dungeonData.put((Object)key, (Object)new DungeonInfo((NBTTagCompound)nbt));
            }
        }
    }

    private void addDungeonEntry(DungeonBase dungeon, BlockPos location, DungeonSpawnType spawnType) {
        if (this.dungeonData.put((Object)dungeon.getDungeonName(), (Object)new DungeonInfo(location, spawnType))) {
            this.modifiedSinceLastSave = true;
        }
    }

    private Set<String> getSpawnedDungeonNames() {
        return this.dungeonData.keySet();
    }

    private Set<DungeonInfo> getLocationsOfDungeon(DungeonBase dungeon) {
        return this.dungeonData.get((Object)dungeon.getDungeonName());
    }

    private boolean isDungeonSpawnLimitMet(DungeonBase dungeon) {
        if (dungeon.getSpawnLimit() < 0) {
            return false;
        }
        if (this.dungeonData.isEmpty()) {
            return false;
        }
        Set spawnedLocs = this.dungeonData.get((Object)dungeon.getDungeonName());
        if (spawnedLocs == null) {
            return false;
        }
        return spawnedLocs.stream().filter(dungeonInfo -> ((DungeonInfo)dungeonInfo).spawnType == DungeonSpawnType.DUNGEON_GENERATION).count() >= (long)dungeon.getSpawnLimit();
    }

    public static enum DungeonSpawnType {
        DUNGEON_GENERATION,
        LOCKED_COORDINATE,
        DUNGEON_PLACER_ITEM;

    }

    public static class DungeonInfo {
        private BlockPos pos;
        private DungeonSpawnType spawnType;

        public DungeonInfo(BlockPos pos, DungeonSpawnType spawnType) {
            this.pos = pos.func_185334_h();
            this.spawnType = spawnType;
        }

        public DungeonInfo(NBTTagCompound compound) {
            this.readFromNBT(compound);
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.pos));
            compound.func_74768_a("spawnType", this.spawnType.ordinal());
            return compound;
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.pos = compound.func_150297_b("pos", 10) ? NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("pos")) : NBTUtil.func_186861_c((NBTTagCompound)compound);
            this.spawnType = DungeonSpawnType.values()[compound.func_74762_e("spawnType")];
        }
    }
}

