/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import org.apache.commons.io.FileUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.util.PropertyFileHelper;
import team.cqr.cqrepoured.world.structure.generation.EDungeonGenerator;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonBase;
import team.cqr.cqrepoured.world.structure.generation.grid.GridRegistry;

public class DungeonRegistry {
    private static final DungeonRegistry INSTANCE = new DungeonRegistry();
    private final Map<String, DungeonBase> dungeons = new HashMap<String, DungeonBase>();

    public static DungeonRegistry getInstance() {
        return INSTANCE;
    }

    public Collection<DungeonBase> getDungeons() {
        return this.dungeons.values();
    }

    @Nullable
    public DungeonBase getDungeon(String name) {
        return this.dungeons.get(name);
    }

    public List<DungeonBase> getLocationSpecificDungeonsForChunk(World world, int chunkX, int chunkZ) {
        ArrayList<DungeonBase> dungeonsForChunk = new ArrayList<DungeonBase>();
        for (DungeonBase dungeon : this.dungeons.values()) {
            if (!dungeon.canSpawnInChunkWithLockedPosition(world, chunkX, chunkZ)) continue;
            dungeonsForChunk.add(dungeon);
        }
        return dungeonsForChunk;
    }

    public void loadDungeonFiles() {
        this.dungeons.clear();
        Collection files = FileUtils.listFiles((File)CQRMain.CQ_DUNGEON_FOLDER, (String[])new String[]{"properties", "prop", "cfg"}, (boolean)true);
        CQRMain.logger.info("Loading {} dungeon configuration files...", (Object)files.size());
        for (File file : files) {
            DungeonBase dungeon = this.createDungeonFromFile(file);
            if (dungeon == null || this.dungeons.containsKey(dungeon.getDungeonName())) continue;
            this.dungeons.put(dungeon.getDungeonName(), dungeon);
            if (dungeon.isModDependencyMissing()) {
                CQRMain.logger.warn("{}: Dungeon is missing one or more mod dependencies!", (Object)file.getName());
            }
            if (!dungeon.isEnabled()) continue;
            if (dungeon.getWeight() <= 0) {
                CQRMain.logger.warn("{}: Dungeon is enabled and weight is set to or below 0!", (Object)file.getName());
            }
            if (dungeon.getChance() > 0) continue;
            CQRMain.logger.warn("{}: Dungeon is enabled and chance is set to or below 0!", (Object)file.getName());
        }
        GridRegistry.getInstance().loadGridFiles();
    }

    private DungeonBase createDungeonFromFile(File file) {
        Properties prop = PropertyFileHelper.readPropFile(file);
        if (prop == null) {
            return null;
        }
        String name = file.getName().substring(0, file.getName().lastIndexOf(46));
        String generatorType = prop.getProperty("generator", "");
        EDungeonGenerator dungeonGenerator = EDungeonGenerator.getDungeonGenerator(generatorType);
        return dungeonGenerator != null ? dungeonGenerator.createDungeon(name, prop) : null;
    }
}

