/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.world.structure.generation.DungeonDataManager;
import team.cqr.cqrepoured.world.structure.generation.DungeonRegistry;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonBase;
import team.cqr.cqrepoured.world.structure.generation.generation.SpawnpointGenerationHandler;
import team.cqr.cqrepoured.world.structure.generation.grid.DungeonGrid;
import team.cqr.cqrepoured.world.structure.generation.grid.GridRegistry;

public class WorldDungeonGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (((SpawnpointGenerationHandler)world).isDungeonGenerationDelayed(chunkX, chunkZ)) {
            return;
        }
        DungeonBase dungeon = WorldDungeonGenerator.getDungeonAt(world, chunkX, chunkZ);
        if (dungeon == null) {
            return;
        }
        int x = (chunkX << 4) + 8;
        int z = (chunkZ << 4) + 8;
        dungeon.generate(world, x, z, WorldDungeonGenerator.getRandomForCoords(world, x, z), DungeonDataManager.DungeonSpawnType.DUNGEON_GENERATION);
    }

    @Nullable
    public static DungeonBase getDungeonAt(World world, int chunkX, int chunkZ) {
        return WorldDungeonGenerator.getDungeonAt(world, chunkX, chunkZ, (Predicate<DungeonGrid>)Predicates.alwaysTrue());
    }

    @Nullable
    public static DungeonBase getDungeonAt(World world, int chunkX, int chunkZ, Predicate<DungeonGrid> gridPredicate) {
        if (!WorldDungeonGenerator.canSpawnDungeonsInWorld(world)) {
            return null;
        }
        DungeonBase locationSpecificDungeon = WorldDungeonGenerator.getLocationSpecificDungeon(world, chunkX, chunkZ);
        if (locationSpecificDungeon != null) {
            return locationSpecificDungeon;
        }
        return GridRegistry.getInstance().getGrids().stream().filter(gridPredicate).map(grid -> grid.getDungeonAt(world, chunkX, chunkZ)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static boolean canSpawnDungeonsInWorld(World world) {
        if (!world.func_72912_H().func_76089_r()) {
            return false;
        }
        if (world.func_175624_G() != WorldType.field_77138_c) {
            return true;
        }
        return CQRConfig.general.dungeonsInFlat;
    }

    @Nullable
    public static DungeonBase getLocationSpecificDungeon(World world, int chunkX, int chunkZ) {
        List<DungeonBase> locationSpecificDungeons = DungeonRegistry.getInstance().getLocationSpecificDungeonsForChunk(world, chunkX, chunkZ);
        if (locationSpecificDungeons.isEmpty()) {
            return null;
        }
        if (locationSpecificDungeons.size() > 1) {
            CQRMain.logger.warn("Found {} location specific dungeons for chunkX={}, chunkZ={}!", (Object)locationSpecificDungeons.size(), (Object)chunkX, (Object)chunkZ);
        }
        return locationSpecificDungeons.get(0);
    }

    public static Random getRandomForCoords(World world, int x, int z) {
        return new Random(WorldDungeonGenerator.getSeed(world, x, z));
    }

    public static long getSeed(World world, int chunkX, int chunkZ) {
        long mix = WorldDungeonGenerator.xorShift64(chunkX) + Long.rotateLeft(WorldDungeonGenerator.xorShift64(chunkZ), 32) + -1094792450L;
        long result = WorldDungeonGenerator.xorShift64(mix);
        return world.func_72905_C() + result;
    }

    private static long xorShift64(long x) {
        x ^= x << 21;
        x ^= x >>> 35;
        x ^= x << 4;
        return x;
    }
}

