/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.dungeons;

import java.io.File;
import java.util.Properties;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.cqr.cqrepoured.util.PropertyFileHelper;
import team.cqr.cqrepoured.world.structure.generation.DungeonDataManager;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonBase;
import team.cqr.cqrepoured.world.structure.generation.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.world.structure.generation.generators.GeneratorGuardedStructure;

public class DungeonGuardedCastle
extends DungeonBase {
    private File structureFolder;
    private File centerStructureFolder;
    private int minBuildings = 7;
    private int maxBuilding = 14;
    private int minDistance = 15;
    private int maxDistance = 30;

    public DungeonGuardedCastle(String name, Properties prop) {
        super(name, prop);
        this.structureFolder = PropertyFileHelper.getStructureFolderProperty(prop, "structurefolder", "village_buildings");
        this.centerStructureFolder = PropertyFileHelper.getStructureFolderProperty(prop, "centerstructurefolder", "village_centers");
        this.minBuildings = PropertyFileHelper.getIntProperty(prop, "minbuildings", 6);
        this.maxBuilding = PropertyFileHelper.getIntProperty(prop, "maxbuildings", 10);
        this.minDistance = PropertyFileHelper.getIntProperty(prop, "mindistance", 20);
        this.maxDistance = PropertyFileHelper.getIntProperty(prop, "maxdistance", 40);
    }

    public AbstractDungeonGenerator<DungeonGuardedCastle> createDungeonGenerator(World world, int x, int y, int z, Random rand, DungeonDataManager.DungeonSpawnType spawnType) {
        return new GeneratorGuardedStructure(world, new BlockPos(x, y, z), this, rand);
    }

    public int getMinDistance() {
        return this.minDistance;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public int getMinBuildings() {
        return this.minBuildings;
    }

    public int getMaxBuilding() {
        return this.maxBuilding;
    }

    public File getStructureFolder() {
        return this.structureFolder;
    }

    public File getCenterStructureFolder() {
        return this.centerStructureFolder;
    }

    public boolean rotateDungeon() {
        return false;
    }
}

