/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.dungeons;

import java.io.File;
import java.util.Properties;
import java.util.Random;
import net.minecraft.block.BlockVine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.PropertyFileHelper;
import team.cqr.cqrepoured.world.structure.generation.DungeonDataManager;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonBase;
import team.cqr.cqrepoured.world.structure.generation.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.world.structure.generation.generators.GeneratorVegetatedCave;

public class DungeonVegetatedCave
extends DungeonBase {
    private IBlockState vineBlock;
    private IBlockState vineLatchBlock;
    private IBlockState airBlock;
    private IBlockState pumpkinBlock;
    private IBlockState[] flowerBlocks;
    private IBlockState[] mushrooms;
    private IBlockState[] grassBlocks;
    private IBlockState[] floorBlocks;
    private int centralCaveSize = 20;
    private int tunnelCountMin = 3;
    private int tunnelCountMax = 5;
    private int tunnelStartSize = 8;
    private int caveSegmentCount = 8;
    private int vineChance = 20;
    private ResourceLocation[] chestIDs;
    private double vineLengthModifier = 2.0;
    private boolean placeVines;
    private boolean crossVine;
    private boolean placeVegetation;
    private boolean placeBuilding;
    private boolean skipCeilingFiltering = false;
    private File buildingFolder;

    public DungeonVegetatedCave(String name, Properties prop) {
        super(name, prop);
        this.vineBlock = PropertyFileHelper.getBlockStateProperty(prop, "vineBlock", Blocks.field_150395_bd.func_176223_P());
        this.crossVine = this.vineBlock.func_177230_c() instanceof BlockVine;
        this.airBlock = PropertyFileHelper.getBlockStateProperty(prop, "airBlock", Blocks.field_150350_a.func_176223_P());
        this.pumpkinBlock = PropertyFileHelper.getBlockStateProperty(prop, "lanternBlock", Blocks.field_150428_aP.func_176223_P());
        this.flowerBlocks = PropertyFileHelper.getBlockStateArrayProperty(prop, "flowerBlocks", new IBlockState[]{Blocks.field_150328_O.func_176223_P(), Blocks.field_150327_N.func_176223_P()}, false);
        this.mushrooms = PropertyFileHelper.getBlockStateArrayProperty(prop, "mushroomBlocks", new IBlockState[]{Blocks.field_150338_P.func_176223_P(), Blocks.field_150337_Q.func_176223_P()}, false);
        this.floorBlocks = PropertyFileHelper.getBlockStateArrayProperty(prop, "floorBlocks", new IBlockState[]{Blocks.field_150349_c.func_176223_P()}, false);
        this.grassBlocks = PropertyFileHelper.getBlockStateArrayProperty(prop, "grassBlocks", new IBlockState[]{Blocks.field_150350_a.func_176223_P()}, false);
        this.vineLengthModifier = Math.max(1.0, PropertyFileHelper.getDoubleProperty(prop, "vineLengthModifier", 2.0));
        this.vineChance = PropertyFileHelper.getIntProperty(prop, "vineChance", 20);
        this.placeVines = PropertyFileHelper.getBooleanProperty(prop, "placeVines", true);
        this.placeVegetation = PropertyFileHelper.getBooleanProperty(prop, "placeVegetation", true);
        this.placeBuilding = PropertyFileHelper.getBooleanProperty(prop, "placeBuilding", true);
        this.buildingFolder = PropertyFileHelper.getStructureFolderProperty(prop, "buildingFolder", "caves/swamp");
        this.centralCaveSize = PropertyFileHelper.getIntProperty(prop, "centralCaveSize", 15);
        this.tunnelCountMin = PropertyFileHelper.getIntProperty(prop, "tunnelCountMin", 3);
        this.tunnelCountMax = PropertyFileHelper.getIntProperty(prop, "tunnelCountMax", 5);
        this.caveSegmentCount = PropertyFileHelper.getIntProperty(prop, "caveSegmentCount", 8);
        this.vineLatchBlock = PropertyFileHelper.getBlockStateProperty(prop, "vineLatchBlock", Blocks.field_150347_e.func_176223_P());
        this.tunnelStartSize = PropertyFileHelper.getIntProperty(prop, "tunnelStartSize", 10);
        this.chestIDs = PropertyFileHelper.getResourceLocationArrayProperty(prop, "chestIDs", new ResourceLocation[]{LootTableList.field_186424_f, LootTableList.field_186425_g, CQRLoottables.CHESTS_FOOD}, false);
        this.skipCeilingFiltering = PropertyFileHelper.getBooleanProperty(prop, "skipCeilingFiltering", false);
    }

    public AbstractDungeonGenerator<DungeonVegetatedCave> createDungeonGenerator(World world, int x, int y, int z, Random rand, DungeonDataManager.DungeonSpawnType spawnType) {
        return new GeneratorVegetatedCave(world, new BlockPos(x, y, z), this, rand);
    }

    public File getRandomCentralBuilding(Random rand) {
        return this.getStructureFileFromDirectory(this.buildingFolder, rand);
    }

    public IBlockState getVineBlock() {
        return this.vineBlock;
    }

    public IBlockState getFlowerBlock(Random rdm) {
        return this.flowerBlocks[rdm.nextInt(this.flowerBlocks.length)];
    }

    public IBlockState getMushroomBlock(Random rdm) {
        return this.mushrooms[rdm.nextInt(this.mushrooms.length)];
    }

    public IBlockState getFloorBlock(Random rdm) {
        return this.floorBlocks[rdm.nextInt(this.floorBlocks.length)];
    }

    public IBlockState getGrassBlock(Random rdm) {
        return this.grassBlocks[rdm.nextInt(this.grassBlocks.length)];
    }

    public boolean placeVegetation() {
        return this.placeVegetation;
    }

    public boolean placeBuilding() {
        return this.placeBuilding;
    }

    public boolean isVineShapeCross() {
        return this.crossVine;
    }

    public boolean placeVines() {
        return this.placeVines;
    }

    public boolean skipCeilingFiltering() {
        return this.skipCeilingFiltering;
    }

    public IBlockState getAirBlock() {
        return this.airBlock;
    }

    public IBlockState getPumpkinBlock() {
        return this.pumpkinBlock;
    }

    public IBlockState getVineLatchBlock() {
        return this.vineLatchBlock;
    }

    public int getCentralCaveSize() {
        return this.centralCaveSize;
    }

    public int getTunnelCount(Random random) {
        return DungeonGenUtils.randomBetween(this.tunnelCountMin, this.tunnelCountMax, random);
    }

    public int getCaveSegmentCount() {
        return this.caveSegmentCount;
    }

    public ResourceLocation[] getChestIDs() {
        return this.chestIDs;
    }

    public int getTunnelStartSize() {
        return this.tunnelStartSize;
    }

    public double getVineLengthModifier() {
        return this.vineLengthModifier;
    }

    public int getVineChance() {
        return this.vineChance;
    }
}

