/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generation.part;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import team.cqr.cqrepoured.util.BlockPlacingHelper;
import team.cqr.cqrepoured.world.structure.generation.generation.DungeonPlacement;
import team.cqr.cqrepoured.world.structure.generation.generation.GeneratableDungeon;
import team.cqr.cqrepoured.world.structure.generation.generation.part.IDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generation.part.IDungeonPartBuilder;

public class CoverDungeonPart
implements IDungeonPart {
    private static final BlockPos.MutableBlockPos MUTABLE = new BlockPos.MutableBlockPos();
    private final IBlockState coverBlock;
    private final int startX;
    private final int startZ;
    private final int endX;
    private final int endZ;

    protected CoverDungeonPart(int startX, int startZ, int endX, int endZ, IBlockState coverBlock) {
        this.coverBlock = coverBlock;
        this.startX = startX;
        this.startZ = startZ;
        this.endX = endX;
        this.endZ = endZ;
    }

    @Override
    public void generate(World world, GeneratableDungeon dungeon) {
        for (int cx = this.startX >> 4; cx <= this.endX >> 4; ++cx) {
            for (int cz = this.startZ >> 4; cz <= this.endZ >> 4; ++cz) {
                Chunk chunk = world.func_72964_e(cx, cz);
                for (int x = 0; x < 16; ++x) {
                    if ((cx << 4) + x < this.startX || (cx << 4) + x > this.endX) continue;
                    block3: for (int z = 0; z < 16; ++z) {
                        if ((cz << 4) + z < this.startZ || (cz << 4) + z > this.endZ) continue;
                        MUTABLE.func_181079_c((cx << 4) + x, chunk.func_76625_h() + 15, (cz << 4) + z);
                        while (MUTABLE.func_177956_o() >= 0) {
                            IBlockState state = chunk.func_177435_g((BlockPos)MUTABLE);
                            if (state.func_177230_c() == Blocks.field_150350_a) {
                                MUTABLE.func_185336_p(MUTABLE.func_177956_o() - 1);
                                continue;
                            }
                            if (state.func_177230_c() == this.coverBlock.func_177230_c()) continue block3;
                            MUTABLE.func_185336_p(MUTABLE.func_177956_o() + 1);
                            BlockPlacingHelper.setBlockState(world, (BlockPos)MUTABLE, this.coverBlock, null, 48, dungeon);
                            dungeon.mark(MUTABLE.func_177958_n() >> 4, MUTABLE.func_177956_o() >> 4, MUTABLE.func_177952_p() >> 4);
                            continue block3;
                        }
                    }
                }
            }
        }
    }

    public IBlockState getCoverBlock() {
        return this.coverBlock;
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartZ() {
        return this.startZ;
    }

    public int getEndX() {
        return this.endX;
    }

    public int getEndZ() {
        return this.endZ;
    }

    public static class Builder
    implements IDungeonPartBuilder {
        private final int startX;
        private final int startZ;
        private final int endX;
        private final int endZ;
        private final IBlockState coverBlock;

        public Builder(int startX, int startZ, int endX, int endZ, IBlockState coverBlock) {
            this.startX = Math.min(startX, endX);
            this.startZ = Math.min(startZ, endZ);
            this.endX = Math.max(startX, endX);
            this.endZ = Math.max(startZ, endZ);
            this.coverBlock = coverBlock;
        }

        @Override
        public CoverDungeonPart build(World world, DungeonPlacement placement) {
            return new CoverDungeonPart(this.startX, this.startZ, this.endX, this.endZ, this.coverBlock);
        }
    }
}

