/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generation.part;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import team.cqr.cqrepoured.util.BlockPlacingHelper;
import team.cqr.cqrepoured.world.structure.generation.generation.DungeonPlacement;
import team.cqr.cqrepoured.world.structure.generation.generation.GeneratableDungeon;
import team.cqr.cqrepoured.world.structure.generation.generation.part.IDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generation.part.IDungeonPartBuilder;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableEmptyInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparablePosInfo;
import team.cqr.cqrepoured.world.structure.generation.structurefile.CQStructure;
import team.cqr.cqrepoured.world.structure.generation.structurefile.Offset;

public class PlateauDungeonPart
implements IDungeonPart {
    private static final BlockPos.MutableBlockPos MUTABLE = new BlockPos.MutableBlockPos();
    private final int startX;
    private final int startZ;
    private final int endX;
    private final int endY;
    private final int endZ;
    private final int wallSize;
    private final IBlockState supportHillBlock;
    private final IBlockState supportHillTopBlock;
    private final int[][] ground;
    public static final int LOWEST_WORLD_Y = 0;

    protected PlateauDungeonPart(int startX, int startZ, int endX, int endY, int endZ, int wallSize, @Nullable IBlockState supportHillBlock, @Nullable IBlockState supportHillTopBlock, int[][] ground) {
        this.startX = startX;
        this.startZ = startZ;
        this.endX = endX;
        this.endY = endY;
        this.endZ = endZ;
        this.wallSize = wallSize;
        this.supportHillBlock = supportHillBlock;
        this.supportHillTopBlock = supportHillTopBlock;
        this.ground = ground;
    }

    @Override
    public void generate(World world, GeneratableDungeon dungeon) {
        for (int x = this.startX - this.wallSize; x <= this.endX + this.wallSize; ++x) {
            for (int z = this.startZ - this.wallSize; z <= this.endZ + this.wallSize; ++z) {
                MUTABLE.func_181079_c(x, 0, z);
                IBlockState state1 = this.supportHillBlock;
                IBlockState state2 = this.supportHillTopBlock;
                if (state1 == null || state2 == null) {
                    Biome biome = world.func_180494_b((BlockPos)MUTABLE);
                    if (state1 == null) {
                        state1 = biome.field_76753_B;
                    }
                    if (state2 == null) {
                        state2 = biome.field_76752_A;
                    }
                }
                int y = PlateauDungeonPart.getHeight(world, x, this.endY + 1, z);
                int end = this.interpolatedHeight(x, y, z);
                MUTABLE.func_185336_p(y);
                while (MUTABLE.func_177956_o() < end - 1) {
                    BlockPlacingHelper.setBlockState(world, (BlockPos)MUTABLE, state1, null, 48, dungeon);
                    dungeon.mark(MUTABLE.func_177958_n() >> 4, MUTABLE.func_177956_o() >> 4, MUTABLE.func_177952_p() >> 4);
                    MUTABLE.func_185336_p(MUTABLE.func_177956_o() + 1);
                }
                if (MUTABLE.func_177956_o() >= end) continue;
                BlockPlacingHelper.setBlockState(world, (BlockPos)MUTABLE, state2, null, 48, dungeon);
                dungeon.mark(MUTABLE.func_177958_n() >> 4, MUTABLE.func_177956_o() >> 4, MUTABLE.func_177952_p() >> 4);
            }
        }
    }

    private int interpolatedHeight(int x, int y, int z) {
        int max = y;
        int r = this.wallSize + 1;
        for (int x1 = -r; x1 <= r; ++x1) {
            if (x + x1 < this.startX || x + x1 > this.endX) continue;
            for (int z1 = -r; z1 <= r; ++z1) {
                double dist;
                int y1;
                int z2;
                if (z + z1 < this.startZ || z + z1 > this.endZ) continue;
                int x2 = Math.abs(x1);
                if (x2 > 0) {
                    --x2;
                }
                if ((z2 = Math.abs(z1)) > 0) {
                    --z2;
                }
                if ((y1 = (int)Math.round((double)y + (double)(this.ground[x + x1 - this.startX][z + z1 - this.startZ] - y) * Math.max(1.0 - (dist = Math.sqrt(x2 * x2 + z2 * z2)) / (double)this.wallSize, 0.0))) <= max) continue;
                max = y1;
            }
        }
        return max;
    }

    private static boolean isGround(World world, Chunk chunk, BlockPos pos) {
        IBlockState state = chunk.func_177435_g(pos);
        Material material = state.func_185904_a();
        return material.func_76230_c() && material != Material.field_151575_d && material != Material.field_151584_j && material != Material.field_151585_k;
    }

    private static int getHeight(World world, int x, int y, int z) {
        Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
        MUTABLE.func_181079_c(x, y, z);
        boolean upwards = PlateauDungeonPart.isGround(world, chunk, (BlockPos)MUTABLE);
        while (MUTABLE.func_177956_o() >= 0) {
            boolean isGround = PlateauDungeonPart.isGround(world, chunk, (BlockPos)MUTABLE);
            if (upwards) {
                if (!isGround) {
                    return MUTABLE.func_177956_o();
                }
                MUTABLE.func_185336_p(MUTABLE.func_177956_o() + 1);
                continue;
            }
            if (isGround) {
                return MUTABLE.func_177956_o() + 1;
            }
            MUTABLE.func_185336_p(MUTABLE.func_177956_o() - 1);
        }
        return MUTABLE.func_177956_o();
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartZ() {
        return this.startZ;
    }

    public int getEndX() {
        return this.endX;
    }

    public int getEndY() {
        return this.endY;
    }

    public int getEndZ() {
        return this.endZ;
    }

    public static class Builder
    implements IDungeonPartBuilder {
        private final int startX;
        private final int startZ;
        private final int endX;
        private final int endY;
        private final int endZ;
        private final int wallSize;
        private IBlockState supportHillBlock;
        private IBlockState supportHillTopBlock;
        private final int[][] ground;

        public Builder(int startX, int startZ, int endX, int endY, int endZ, int wallSize) {
            this.startX = Math.min(startX, endX);
            this.startZ = Math.min(startZ, endZ);
            this.endX = Math.max(startX, endX);
            this.endY = endY;
            this.endZ = Math.max(startZ, endZ);
            this.wallSize = wallSize;
            this.ground = new int[this.endX - this.startX + 1][this.endZ - this.startZ + 1];
            for (int i = 0; i < this.ground.length; ++i) {
                for (int j = 0; j < this.ground[i].length; ++j) {
                    this.ground[i][j] = endY + 1;
                }
            }
        }

        public Builder setSupportHillBlock(@Nullable IBlockState state) {
            this.supportHillBlock = state;
            return this;
        }

        public Builder setSupportHillTopBlock(@Nullable IBlockState state) {
            this.supportHillTopBlock = state;
            return this;
        }

        public void markGround(CQStructure structure, BlockPos pos, Mirror mirror, Rotation rotation) {
            List<PreparablePosInfo> blocks = structure.getBlockInfoList();
            BlockPos size = structure.getSize();
            BlockPos offset = Offset.NORTH_EAST.apply(BlockPos.field_177992_a, structure, mirror, rotation);
            int offsetX = offset.func_177958_n() == 0 ? 0 : offset.func_177958_n() - 1;
            int offsetZ = offset.func_177952_p() == 0 ? 0 : offset.func_177952_p() - 1;
            for (int x = 0; x < structure.getSize().func_177958_n(); ++x) {
                for (int z = 0; z < structure.getSize().func_177952_p(); ++z) {
                    int y;
                    BlockPos.MutableBlockPos transformed = DungeonPlacement.transform(x, 0, z, mirror, rotation);
                    int x1 = transformed.func_177958_n();
                    int z1 = transformed.func_177952_p();
                    if (x1 + pos.func_177958_n() < this.startX || x1 + pos.func_177958_n() > this.endX || z1 + pos.func_177952_p() < this.startZ || z1 + pos.func_177952_p() > this.endZ) continue;
                    for (y = Math.min(this.endY + 1 - pos.func_177956_o(), size.func_177956_o() - 1); y >= 0 && blocks.get((x * size.func_177956_o() + y) * size.func_177952_p() + z) instanceof PreparableEmptyInfo; --y) {
                    }
                    this.ground[offsetX + x1][offsetZ + z1] = y < 0 ? -1 : Math.min(pos.func_177956_o() + y + 2, this.endY + 1);
                }
            }
        }

        @Override
        public PlateauDungeonPart build(World world, DungeonPlacement placement) {
            return new PlateauDungeonPart(this.startX, this.startZ, this.endX, this.endY, this.endZ, this.wallSize, this.supportHillBlock, this.supportHillTopBlock, this.ground);
        }
    }
}

