/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generation.preparable;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import team.cqr.cqrepoured.world.structure.generation.generation.DungeonPlacement;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.GeneratableBlockInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.GeneratablePosInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparablePosInfo;
import team.cqr.cqrepoured.world.structure.generation.structurefile.BlockStatePalette;

public class PreparableBlockInfo
extends PreparablePosInfo {
    private final IBlockState state;
    @Nullable
    private final NBTTagCompound tileEntityData;

    public PreparableBlockInfo(BlockPos pos, IBlockState state, @Nullable NBTTagCompound tileEntityData) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), state, tileEntityData);
    }

    public PreparableBlockInfo(int x, int y, int z, IBlockState state, @Nullable NBTTagCompound tileEntityData) {
        super(x, y, z);
        this.state = state;
        this.tileEntityData = tileEntityData;
    }

    @Override
    protected GeneratablePosInfo prepare(World world, DungeonPlacement placement, BlockPos pos) {
        IBlockState transformedState = this.state.func_185902_a(placement.getMirror()).func_185907_a(placement.getRotation());
        TileEntity tileEntity = null;
        if (this.tileEntityData != null) {
            this.tileEntityData.func_74768_a("x", pos.func_177958_n());
            this.tileEntityData.func_74768_a("y", pos.func_177956_o());
            this.tileEntityData.func_74768_a("z", pos.func_177952_p());
            tileEntity = TileEntity.func_190200_a((World)world, (NBTTagCompound)this.tileEntityData);
            if (tileEntity != null) {
                if (tileEntity instanceof TileEntitySkull) {
                    if (transformedState.func_177229_b((IProperty)BlockSkull.field_176418_a) == EnumFacing.UP) {
                        TileEntitySkull skull = (TileEntitySkull)tileEntity;
                        skull.func_145903_a(placement.getMirror().func_185802_a(skull.field_145910_i, 16));
                        skull.func_145903_a(placement.getRotation().func_185833_a(skull.field_145910_i, 16));
                    }
                } else {
                    tileEntity.func_189668_a(placement.getMirror());
                    tileEntity.func_189667_a(placement.getRotation());
                }
            }
            this.tileEntityData.func_82580_o("x");
            this.tileEntityData.func_82580_o("y");
            this.tileEntityData.func_82580_o("z");
        }
        return this.prepare(world, placement, pos, transformedState, tileEntity);
    }

    @Override
    protected GeneratablePosInfo prepareDebug(World world, DungeonPlacement placement, BlockPos pos) {
        IBlockState transformedState = this.state.func_185902_a(placement.getMirror()).func_185907_a(placement.getRotation());
        TileEntity tileEntity = null;
        if (this.tileEntityData != null) {
            this.tileEntityData.func_74768_a("x", pos.func_177958_n());
            this.tileEntityData.func_74768_a("y", pos.func_177956_o());
            this.tileEntityData.func_74768_a("z", pos.func_177952_p());
            tileEntity = TileEntity.func_190200_a((World)world, (NBTTagCompound)this.tileEntityData);
            if (tileEntity != null) {
                if (tileEntity instanceof TileEntitySkull) {
                    if (transformedState.func_177229_b((IProperty)BlockSkull.field_176418_a) == EnumFacing.UP) {
                        TileEntitySkull skull = (TileEntitySkull)tileEntity;
                        skull.func_145903_a(placement.getMirror().func_185802_a(skull.field_145910_i, 16));
                        skull.func_145903_a(placement.getRotation().func_185833_a(skull.field_145910_i, 16));
                    }
                } else {
                    tileEntity.func_189668_a(placement.getMirror());
                    tileEntity.func_189667_a(placement.getRotation());
                }
            }
            this.tileEntityData.func_82580_o("x");
            this.tileEntityData.func_82580_o("y");
            this.tileEntityData.func_82580_o("z");
        }
        return this.prepareDebug(world, placement, pos, transformedState, tileEntity);
    }

    protected GeneratablePosInfo prepare(World world, DungeonPlacement placement, BlockPos pos, IBlockState state, @Nullable TileEntity tileEntity) {
        return new GeneratableBlockInfo(pos, state, tileEntity);
    }

    protected GeneratablePosInfo prepareDebug(World world, DungeonPlacement placement, BlockPos pos, IBlockState state, @Nullable TileEntity tileEntity) {
        return new GeneratableBlockInfo(pos, state, tileEntity);
    }

    public IBlockState getState() {
        return this.state;
    }

    @Nullable
    public NBTTagCompound getTileEntityData() {
        return this.tileEntityData;
    }

    public static class Serializer
    implements PreparablePosInfo.Registry.ISerializer<PreparableBlockInfo> {
        @Override
        public void write(PreparableBlockInfo preparable, ByteBuf buf, BlockStatePalette palette, NBTTagList nbtList) {
            int data = palette.idFor(preparable.state) << 1 | (preparable.tileEntityData != null ? 1 : 0);
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)data, (int)5);
            if (preparable.tileEntityData != null) {
                ByteBufUtils.writeVarInt((ByteBuf)buf, (int)nbtList.func_74745_c(), (int)5);
                nbtList.func_74742_a((NBTBase)preparable.tileEntityData);
            }
        }

        @Override
        public PreparableBlockInfo read(int x, int y, int z, ByteBuf buf, BlockStatePalette palette, NBTTagList nbtList) {
            int data = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
            IBlockState state = palette.stateFor(data >>> 1);
            NBTTagCompound tileEntityData = null;
            if ((data & 1) == 1) {
                tileEntityData = nbtList.func_150305_b(ByteBufUtils.readVarInt((ByteBuf)buf, (int)5));
            }
            return new PreparableBlockInfo(x, y, z, state, tileEntityData);
        }

        @Override
        @Deprecated
        public PreparableBlockInfo read(int x, int y, int z, NBTTagIntArray nbtIntArray, BlockStatePalette palette, NBTTagList nbtList) {
            int[] intArray = nbtIntArray.func_150302_c();
            IBlockState state = palette.stateFor(intArray[1]);
            NBTTagCompound tileEntityData = null;
            if (intArray.length > 2) {
                tileEntityData = nbtList.func_150305_b(intArray[2]);
            }
            return new PreparableBlockInfo(x, y, z, state, tileEntityData);
        }
    }

    public static class Factory
    implements PreparablePosInfo.Registry.IFactory<TileEntity> {
        @Override
        public PreparablePosInfo create(World world, int x, int y, int z, IBlockState state, Supplier<TileEntity> tileEntitySupplier) {
            return new PreparableBlockInfo(x, y, z, state, PreparablePosInfo.Registry.IFactory.writeTileEntityToNBT(tileEntitySupplier.get()));
        }
    }
}

