/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generation.preparable;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.block.BlockExporterChest;
import team.cqr.cqrepoured.block.BlockExporterChestCQR;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.tileentity.TileEntityExporterChest;
import team.cqr.cqrepoured.tileentity.TileEntityExporterChestCustom;
import team.cqr.cqrepoured.world.structure.generation.WorldDungeonGenerator;
import team.cqr.cqrepoured.world.structure.generation.generation.DungeonPlacement;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.GeneratableBlockInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.GeneratablePosInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparablePosInfo;
import team.cqr.cqrepoured.world.structure.generation.structurefile.BlockStatePalette;

public class PreparableLootChestInfo
extends PreparablePosInfo {
    private final ResourceLocation lootTable;
    private final EnumFacing facing;

    public PreparableLootChestInfo(BlockPos pos, ResourceLocation lootTable, EnumFacing facing) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), lootTable, facing);
    }

    public PreparableLootChestInfo(int x, int y, int z, ResourceLocation lootTable, EnumFacing facing) {
        super(x, y, z);
        this.lootTable = lootTable;
        this.facing = facing;
    }

    @Override
    protected GeneratablePosInfo prepare(World world, DungeonPlacement placement, BlockPos pos) {
        IBlockState state = Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)this.facing);
        TileEntity tileEntity = (state = state.func_185902_a(placement.getMirror()).func_185907_a(placement.getRotation())).func_177230_c().createTileEntity(world, state);
        if (tileEntity instanceof TileEntityChest) {
            long seed = WorldDungeonGenerator.getSeed(world, pos.func_177958_n(), pos.func_177952_p());
            ((TileEntityChest)tileEntity).func_189404_a(this.lootTable, seed);
        }
        return new GeneratableBlockInfo(pos, state, tileEntity);
    }

    @Override
    protected GeneratablePosInfo prepareDebug(World world, DungeonPlacement placement, BlockPos pos) {
        BlockExporterChest block = BlockExporterChest.getExporterChests().stream().filter(BlockExporterChestCQR.class::isInstance).filter(b -> ((BlockExporterChestCQR)((Object)b)).getLootTable().equals((Object)this.lootTable)).findFirst().orElse(CQRBlocks.EXPORTER_CHEST_CUSTOM);
        IBlockState state = block.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)this.facing);
        state = state.func_185902_a(placement.getMirror()).func_185907_a(placement.getRotation());
        if (block != CQRBlocks.EXPORTER_CHEST_CUSTOM) {
            return new GeneratableBlockInfo(pos, state, null);
        }
        TileEntityExporterChestCustom tileEntity = new TileEntityExporterChestCustom();
        tileEntity.setLootTable(this.lootTable);
        return new GeneratableBlockInfo(pos, state, tileEntity);
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public static class Serializer
    implements PreparablePosInfo.Registry.ISerializer<PreparableLootChestInfo> {
        @Override
        public void write(PreparableLootChestInfo preparable, ByteBuf buf, BlockStatePalette palette, NBTTagList nbtList) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)preparable.lootTable.toString());
            buf.writeByte(preparable.facing.func_176736_b());
        }

        @Override
        public PreparableLootChestInfo read(int x, int y, int z, ByteBuf buf, BlockStatePalette palette, NBTTagList nbtList) {
            ResourceLocation lootTable = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
            EnumFacing facing = EnumFacing.func_176731_b((int)buf.readByte());
            return new PreparableLootChestInfo(x, y, z, lootTable, facing);
        }

        @Override
        @Deprecated
        public PreparableLootChestInfo read(int x, int y, int z, NBTTagIntArray nbtIntArray, BlockStatePalette palette, NBTTagList nbtList) {
            int[] intArray = nbtIntArray.func_150302_c();
            ResourceLocation lootTable = Serializer.getLootTableFromId(intArray[1]);
            EnumFacing facing = EnumFacing.func_176731_b((int)intArray[2]);
            return new PreparableLootChestInfo(x, y, z, lootTable, facing);
        }

        @Deprecated
        private static ResourceLocation getLootTableFromId(int id) {
            switch (id) {
                case 0: {
                    return CQRLoottables.CHESTS_FOOD;
                }
                case 1: {
                    return CQRLoottables.CHESTS_EQUIPMENT;
                }
                case 2: {
                    return CQRLoottables.CHESTS_TREASURE;
                }
                case 3: {
                    return CQRLoottables.CHESTS_MATERIAL;
                }
                case 32: {
                    return CQRLoottables.CHESTS_CLUTTER;
                }
                case 4: {
                    return LootTableList.field_186424_f;
                }
                case 5: {
                    return LootTableList.field_186429_k;
                }
                case 6: {
                    return LootTableList.field_186421_c;
                }
                case 7: {
                    return LootTableList.field_186431_m;
                }
                case 8: {
                    return LootTableList.field_186430_l;
                }
                case 9: {
                    return LootTableList.field_189420_m;
                }
                case 10: {
                    return LootTableList.field_186425_g;
                }
                case 11: {
                    return LootTableList.field_186420_b;
                }
                case 12: {
                    return LootTableList.field_186428_j;
                }
                case 13: {
                    return LootTableList.field_186427_i;
                }
                case 14: {
                    return LootTableList.field_186426_h;
                }
                case 15: {
                    return LootTableList.field_186423_e;
                }
                case 16: {
                    return LootTableList.field_191192_o;
                }
                case 17: {
                    return LootTableList.field_186422_d;
                }
            }
            if (id >= 18 && id <= 31) {
                return new ResourceLocation("cqrepoured", "chests/custom_" + (id - 17));
            }
            CQRMain.logger.warn("Failed to read loottable for id {}!", (Object)id);
            return CQRLoottables.CHESTS_FOOD;
        }
    }

    public static class Factory
    implements PreparablePosInfo.Registry.IFactory<TileEntityExporterChest> {
        @Override
        public PreparablePosInfo create(World world, int x, int y, int z, IBlockState state, Supplier<TileEntityExporterChest> tileEntitySupplier) {
            return new PreparableLootChestInfo(x, y, z, tileEntitySupplier.get().getLootTable(), (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D));
        }
    }
}

