/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generation.preparable;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.tileentity.TileEntitySpawner;
import team.cqr.cqrepoured.util.SpawnerFactory;
import team.cqr.cqrepoured.world.structure.generation.generation.DungeonPlacement;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.GeneratableBlockInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.GeneratablePosInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparablePosInfo;
import team.cqr.cqrepoured.world.structure.generation.structurefile.BlockStatePalette;

public class PreparableSpawnerInfo
extends PreparablePosInfo {
    private final NBTTagCompound tileEntityData;

    public PreparableSpawnerInfo(BlockPos pos, NBTTagCompound tileEntityData) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), tileEntityData);
    }

    public PreparableSpawnerInfo(int x, int y, int z, NBTTagCompound tileEntityData) {
        super(x, y, z);
        this.tileEntityData = tileEntityData;
    }

    public PreparableSpawnerInfo(BlockPos pos, Collection<Entity> entities) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), PreparableSpawnerInfo.getNBTTagCompoundFromEntityList(entities.toArray(new Entity[0])));
    }

    public PreparableSpawnerInfo(int x, int y, int z, Collection<Entity> entities) {
        this(x, y, z, PreparableSpawnerInfo.getNBTTagCompoundFromEntityList(entities.toArray(new Entity[0])));
    }

    public PreparableSpawnerInfo(BlockPos pos, Entity ... entities) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), PreparableSpawnerInfo.getNBTTagCompoundFromEntityList(entities));
    }

    public PreparableSpawnerInfo(int x, int y, int z, Entity ... entities) {
        this(x, y, z, PreparableSpawnerInfo.getNBTTagCompoundFromEntityList(entities));
    }

    private static NBTTagCompound getNBTTagCompoundFromEntityList(Entity ... entities) {
        TileEntitySpawner tileEntitySpawner = new TileEntitySpawner();
        for (int i = 0; i < entities.length && i < tileEntitySpawner.inventory.getSlots(); ++i) {
            if (entities[i] == null) continue;
            tileEntitySpawner.inventory.setStackInSlot(i, SpawnerFactory.getSoulBottleItemStackForEntity(entities[i]));
        }
        return tileEntitySpawner.func_189515_b(new NBTTagCompound());
    }

    @Override
    protected GeneratablePosInfo prepare(World world, DungeonPlacement placement, BlockPos pos) {
        TileEntity tileEntity;
        IBlockState state;
        BlockPos p = pos.func_185334_h();
        if (this.tileEntityData.func_74767_n("vanillaSpawner")) {
            state = Blocks.field_150474_ac.func_176223_P();
            tileEntity = state.func_177230_c().createTileEntity(world, state);
            if (tileEntity instanceof TileEntityMobSpawner) {
                this.vanillaSpawnerReadFromNBT(world, placement, p, (TileEntityMobSpawner)tileEntity);
            }
        } else {
            state = CQRBlocks.SPAWNER.func_176223_P();
            tileEntity = state.func_177230_c().createTileEntity(world, state);
            if (tileEntity instanceof TileEntitySpawner) {
                this.cqrSpawnerReadFromNBT(world, placement, p, (TileEntitySpawner)tileEntity);
            }
        }
        return new GeneratableBlockInfo(p, state, tileEntity);
    }

    @Override
    protected GeneratablePosInfo prepareDebug(World world, DungeonPlacement placement, BlockPos pos) {
        IBlockState transformedState = CQRBlocks.SPAWNER.func_176223_P().func_185902_a(placement.getMirror()).func_185907_a(placement.getRotation());
        TileEntity tileEntity = null;
        if (this.tileEntityData != null) {
            this.tileEntityData.func_74768_a("x", pos.func_177958_n());
            this.tileEntityData.func_74768_a("y", pos.func_177956_o());
            this.tileEntityData.func_74768_a("z", pos.func_177952_p());
            tileEntity = TileEntity.func_190200_a((World)world, (NBTTagCompound)this.tileEntityData);
            if (tileEntity != null) {
                tileEntity.func_189668_a(placement.getMirror());
                tileEntity.func_189667_a(placement.getRotation());
            }
            this.tileEntityData.func_82580_o("x");
            this.tileEntityData.func_82580_o("y");
            this.tileEntityData.func_82580_o("z");
        }
        return new GeneratableBlockInfo(pos, transformedState, tileEntity);
    }

    private void vanillaSpawnerReadFromNBT(World world, DungeonPlacement placement, BlockPos pos, TileEntityMobSpawner tileEntity) {
        MobSpawnerBaseLogic spawnerBaseLogic = tileEntity.func_145881_a();
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74777_a("Delay", (short)20);
        if (this.tileEntityData.func_150297_b("MinSpawnDelay", 99)) {
            compound.func_74777_a("MinSpawnDelay", this.tileEntityData.func_74765_d("MinSpawnDelay"));
            compound.func_74777_a("MaxSpawnDelay", this.tileEntityData.func_74765_d("MaxSpawnDelay"));
            compound.func_74777_a("SpawnCount", this.tileEntityData.func_74765_d("SpawnCount"));
        }
        if (this.tileEntityData.func_150297_b("MaxNearbyEntities", 99)) {
            compound.func_74777_a("MaxNearbyEntities", this.tileEntityData.func_74765_d("MaxNearbyEntities"));
            compound.func_74777_a("RequiredPlayerRange", this.tileEntityData.func_74765_d("RequiredPlayerRange"));
        }
        if (this.tileEntityData.func_150297_b("SpawnRange", 99)) {
            compound.func_74777_a("SpawnRange", this.tileEntityData.func_74765_d("SpawnRange"));
        }
        NBTTagList nbttaglist = new NBTTagList();
        NBTTagList items = this.tileEntityData.func_74775_l("inventory").func_150295_c("Items", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound itemTag = items.func_150305_b(i);
            NBTTagCompound entityTag = itemTag.func_74775_l("tag").func_74775_l("EntityIn");
            Entity entity = PreparableSpawnerInfo.createEntityFromTag(world, placement, pos, entityTag);
            if (entity == null) continue;
            NBTTagCompound newEntityTag = new NBTTagCompound();
            entity.func_184198_c(newEntityTag);
            newEntityTag.func_82580_o("UUIDLeast");
            newEntityTag.func_82580_o("UUIDMost");
            newEntityTag.func_82580_o("Pos");
            if (nbttaglist.func_82582_d()) {
                compound.func_74782_a("SpawnData", (NBTBase)newEntityTag);
            }
            nbttaglist.func_74742_a((NBTBase)new WeightedSpawnerEntity((int)itemTag.func_74771_c("Count"), newEntityTag).func_185278_a());
        }
        compound.func_74782_a("SpawnPotentials", (NBTBase)nbttaglist);
        spawnerBaseLogic.func_98270_a(compound);
    }

    private void cqrSpawnerReadFromNBT(World world, DungeonPlacement placement, BlockPos pos, TileEntitySpawner tileEntity) {
        NBTTagList items = this.tileEntityData.func_74775_l("inventory").func_150295_c("Items", 10);
        for (int i = 0; i < items.func_74745_c() && i < tileEntity.inventory.getSlots(); ++i) {
            NBTTagCompound itemTag = items.func_150305_b(i);
            NBTTagCompound entityTag = itemTag.func_74775_l("tag").func_74775_l("EntityIn");
            Entity entity = PreparableSpawnerInfo.createEntityFromTag(world, placement, pos, entityTag);
            if (entity == null) continue;
            NBTTagCompound newEntityTag = new NBTTagCompound();
            entity.func_184198_c(newEntityTag);
            newEntityTag.func_82580_o("UUIDLeast");
            newEntityTag.func_82580_o("UUIDMost");
            newEntityTag.func_82580_o("Pos");
            ItemStack stack = new ItemStack(CQRItems.SOUL_BOTTLE, (int)itemTag.func_74771_c("Count"));
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74782_a("EntityIn", (NBTBase)newEntityTag);
            stack.func_77982_d(stackTag);
            tileEntity.inventory.insertItem(i, stack, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Entity createEntityFromTag(World world, DungeonPlacement placement, BlockPos pos, NBTTagCompound entityTag) {
        if (entityTag.func_82582_d()) {
            return null;
        }
        entityTag.func_82580_o("UUIDLeast");
        entityTag.func_82580_o("UUIDMost");
        entityTag.func_82580_o("Pos");
        String id = entityTag.func_74779_i("id");
        try {
            Entity entity;
            if (id.equals("cqrepoured:dummy")) {
                entityTag.func_74778_a("id", placement.getInhabitant().getEntityID().toString());
            }
            if ((entity = EntityList.func_75615_a((NBTTagCompound)entityTag, (World)world)) == null) {
                Entity entity2 = null;
                return entity2;
            }
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            if (entity instanceof EntityLivingBase) {
                for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                    ItemStack stack = ((EntityLivingBase)entity).func_184582_a(slot);
                    if (stack.func_190926_b()) continue;
                    ((EntityLivingBase)entity).func_110140_aT().func_111147_b(stack.func_111283_C(slot));
                    if (slot.func_188453_a() == EntityEquipmentSlot.Type.HAND) {
                        ((EntityLivingBase)entity).field_184630_bs.set(slot.func_188454_b(), (Object)stack);
                        continue;
                    }
                    ((EntityLivingBase)entity).field_184631_bt.set(slot.func_188454_b(), (Object)stack);
                }
                if (entity instanceof EntityLiving) {
                    ((EntityLiving)entity).func_110163_bv();
                    if (entity instanceof AbstractEntityCQR) {
                        ((AbstractEntityCQR)entity).onSpawnFromCQRSpawnerInDungeon(placement);
                    }
                }
            }
            NBTTagList passengers = entityTag.func_150295_c("Passengers", 10);
            for (NBTBase passengerNBT : passengers) {
                Entity passenger = PreparableSpawnerInfo.createEntityFromTag(world, placement, pos, (NBTTagCompound)passengerNBT);
                passenger.func_184220_m(entity);
            }
            Iterator iterator = entity;
            return iterator;
        }
        finally {
            entityTag.func_74778_a("id", id);
        }
    }

    public NBTTagCompound getTileEntityData() {
        return this.tileEntityData;
    }

    public static class Serializer
    implements PreparablePosInfo.Registry.ISerializer<PreparableSpawnerInfo> {
        @Override
        public void write(PreparableSpawnerInfo preparable, ByteBuf buf, BlockStatePalette palette, NBTTagList nbtList) {
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)nbtList.func_74745_c(), (int)5);
            nbtList.func_74742_a((NBTBase)preparable.tileEntityData);
        }

        @Override
        public PreparableSpawnerInfo read(int x, int y, int z, ByteBuf buf, BlockStatePalette palette, NBTTagList nbtList) {
            NBTTagCompound tileEntityData = nbtList.func_150305_b(ByteBufUtils.readVarInt((ByteBuf)buf, (int)5));
            return new PreparableSpawnerInfo(x, y, z, tileEntityData);
        }

        @Override
        @Deprecated
        public PreparableSpawnerInfo read(int x, int y, int z, NBTTagIntArray nbtIntArray, BlockStatePalette palette, NBTTagList nbtList) {
            int[] intArray = nbtIntArray.func_150302_c();
            NBTTagCompound tileEntityData = nbtList.func_150305_b(intArray[2]);
            return new PreparableSpawnerInfo(x, y, z, tileEntityData);
        }
    }

    public static class Factory
    implements PreparablePosInfo.Registry.IFactory<TileEntitySpawner> {
        @Override
        public PreparablePosInfo create(World world, int x, int y, int z, IBlockState state, Supplier<TileEntitySpawner> tileEntitySupplier) {
            TileEntitySpawner tileEntity = tileEntitySupplier.get();
            return new PreparableSpawnerInfo(x, y, z, Factory.getNBTFromTileEntity(world, tileEntity.func_174877_v(), tileEntity));
        }

        private static NBTTagCompound getNBTFromTileEntity(World world, BlockPos pos, TileEntitySpawner tileEntity) {
            NBTTagCompound compound = tileEntity.func_189515_b(new NBTTagCompound());
            compound.func_82580_o("x");
            compound.func_82580_o("y");
            compound.func_82580_o("z");
            NBTTagList items = compound.func_74775_l("inventory").func_150295_c("Items", 10);
            for (int i = 0; i < items.func_74745_c(); ++i) {
                NBTTagCompound itemTag = items.func_150305_b(i);
                NBTTagCompound itemTagCompound = itemTag.func_74775_l("tag");
                NBTTagCompound entityTag = itemTagCompound.func_74775_l("EntityIn");
                Entity entity = Factory.createEntityForExporting(entityTag, world, pos);
                if (entity == null) continue;
                NBTTagCompound newEntityTag = new NBTTagCompound();
                entity.func_184198_c(newEntityTag);
                itemTagCompound.func_74782_a("EntityIn", (NBTBase)newEntityTag);
            }
            return compound;
        }

        private static Entity createEntityForExporting(NBTTagCompound entityTag, World world, BlockPos pos) {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)entityTag, (World)world);
            if (entity != null) {
                entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                if (entity instanceof AbstractEntityCQR) {
                    ((AbstractEntityCQR)entity).onExportFromWorld();
                }
                NBTTagList passengers = entityTag.func_150295_c("Passengers", 10);
                for (NBTBase passengerNBT : passengers) {
                    Entity passenger = Factory.createEntityForExporting((NBTTagCompound)passengerNBT, world, pos);
                    passenger.func_184220_m(entity);
                }
            }
            return entity;
        }
    }
}

