/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators;

import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;

public class SuspensionBridgeHelper {
    private float tension = 5.0f;
    private int width = 5;
    private final BlockPos startPos;
    private final BlockPos endPos;
    private IBlockState pathBlock;
    private IBlockState fenceBlock;
    private IBlockState railingBlock;
    private IBlockState anchorBlock;

    public SuspensionBridgeHelper(IBridgeDataSupplier data, BlockPos start, BlockPos end) {
        this(data.getBridgeTension(), data.getBridgeWidth(), start, end, data.getBridgePathBlock(), data.getBridgeFenceBlock(), data.getBridgeRailingBlock(), data.getBridgeAnchorBlock());
    }

    public SuspensionBridgeHelper(float tension, int width, BlockPos start, BlockPos end, IBlockState pathBlock, IBlockState fenceBlock, IBlockState railingBlock, IBlockState anchorBlock) {
        this.tension = tension;
        this.width = width;
        this.pathBlock = pathBlock;
        this.fenceBlock = fenceBlock;
        this.anchorBlock = anchorBlock;
        this.railingBlock = railingBlock;
        this.startPos = start;
        this.endPos = end;
    }

    public boolean generate(Map<BlockPos, IBlockState> stateMap) {
        this.saggyPath(this.startPos, this.endPos, stateMap);
        return true;
    }

    private void saggyPath(BlockPos currentPos, BlockPos nextPos, Map<BlockPos, IBlockState> stateMap) {
        int iterY;
        double dx = nextPos.func_177958_n() - currentPos.func_177958_n();
        double dy = nextPos.func_177956_o() - currentPos.func_177956_o();
        double dz = nextPos.func_177952_p() - currentPos.func_177952_p();
        double distHorizontal = dx * dx + dz * dz;
        double distance = Math.sqrt(dy * dy + distHorizontal);
        double phi = Math.atan2(dy, Math.sqrt(distHorizontal));
        double theta = Math.atan2(dz, dx);
        double toTheRight = theta + 1.5707963267948966;
        double toTheLeft = theta - 1.5707963267948966;
        double lx = (double)currentPos.func_177958_n() + (double)(this.width / 2) * Math.cos(toTheLeft);
        double lz = (double)currentPos.func_177952_p() + (double)(this.width / 2) * Math.sin(toTheLeft);
        double rx = (double)currentPos.func_177958_n() + (double)(this.width / 2) * Math.cos(toTheRight);
        double rz = (double)currentPos.func_177952_p() + (double)(this.width / 2) * Math.sin(toTheRight);
        double ddx = rx - lx;
        double ddz = rz - lz;
        double dist = Math.ceil(Math.sqrt(ddx * ddx + ddz * ddz));
        double dthetax = 1.0;
        double dthetaz = 1.0;
        for (double i = 0.0; i <= dist; i += 0.5) {
            dthetax = Math.cos(toTheRight);
            dthetaz = Math.sin(toTheRight);
            double startX = lx + dthetax * i;
            double startZ = lz + dthetaz * i;
            this.drawSaggyArc(this.pathBlock, new BlockPos(startX, (double)currentPos.func_177956_o(), startZ), theta, phi, distance, stateMap);
        }
        for (iterY = 1; iterY <= 2; ++iterY) {
            this.drawSaggyArc(this.fenceBlock, new BlockPos(lx, (double)(currentPos.func_177956_o() + iterY), lz), theta, phi, distance, stateMap);
            this.drawSaggyArc(this.fenceBlock, new BlockPos(lx + dthetax * dist, (double)(currentPos.func_177956_o() + iterY), lz + dthetaz * dist), theta, phi, distance, stateMap);
        }
        for (iterY = 2; iterY <= 3; ++iterY) {
            this.drawSaggyArc(this.railingBlock, new BlockPos(lx, (double)(currentPos.func_177956_o() + iterY), lz), theta, phi, distance, stateMap);
            this.drawSaggyArc(this.railingBlock, new BlockPos(lx + dthetax * dist, (double)(currentPos.func_177956_o() + iterY), lz + dthetaz * dist), theta, phi, distance, stateMap);
        }
        BlockPos lxPos = new BlockPos(lx, (double)currentPos.func_177956_o(), lz);
        this.drawLine(this.anchorBlock, lxPos, lxPos.func_177982_a(0, 2, 0), stateMap);
        this.drawLine(this.anchorBlock, lxPos.func_177963_a(dthetax * dist, 0.0, dthetax * dist), lxPos.func_177963_a(dthetax * dist, 2.0, dthetax * dist), stateMap);
        this.drawLine(this.anchorBlock, lxPos.func_177963_a(distance * Math.cos(theta) * Math.cos(phi), distance * Math.sin(phi), distance * Math.sin(theta) * Math.cos(phi)), lxPos.func_177963_a(distance * Math.cos(theta) * Math.cos(phi), 3.0 + distance * Math.sin(phi), distance * Math.sin(theta) * Math.cos(phi)), stateMap);
        this.drawLine(this.anchorBlock, lxPos.func_177963_a(dthetax * dist + distance * Math.cos(theta) * Math.cos(phi), distance * Math.sin(phi), dthetaz * dist + distance * Math.sin(theta) * Math.cos(phi)), lxPos.func_177963_a(distance * Math.cos(theta) * Math.cos(phi), 3.0 + distance * Math.sin(phi), distance * Math.sin(theta) * Math.cos(phi)), stateMap);
    }

    private void drawSaggyArc(IBlockState material, BlockPos pos, double theta, double phi, double distance, Map<BlockPos, IBlockState> stateMap) {
        double midPoint = distance / 2.0;
        double scale = distance / (double)this.tension;
        BlockPos p = new BlockPos(0, 0, 0);
        for (double iterator = 0.0; iterator <= distance; iterator += 0.5) {
            double xx = (iterator - midPoint) / midPoint;
            double ddy = xx * xx * scale;
            BlockPos n = new BlockPos((int)((double)pos.func_177958_n() + iterator * Math.cos(theta) * Math.cos(phi)), (int)((double)pos.func_177956_o() + iterator * Math.sin(phi) + ddy - scale), (int)((double)pos.func_177952_p() + iterator * Math.sin(theta) * Math.cos(phi)));
            if (p.func_185332_f(0, 0, 0) != 0.0) {
                this.drawLine(material, p, n, stateMap);
            }
            p = n;
        }
    }

    private void drawLine(IBlockState material, BlockPos p, BlockPos n, Map<BlockPos, IBlockState> stateMap) {
        this.drawLineConstrained(material, p, n, stateMap, 0);
    }

    private void drawLineConstrained(IBlockState material, BlockPos p, BlockPos n, Map<BlockPos, IBlockState> stateMap, int maxLength) {
        int dz;
        double distHoriz;
        int dx = n.func_177958_n() - p.func_177958_n();
        int dy = n.func_177956_o() - p.func_177956_o();
        double distance = Math.sqrt((double)(dy * dy) + (distHoriz = (double)(dx * dx + (dz = n.func_177952_p() - p.func_177952_p()) * dz)));
        if (distance < (double)maxLength || maxLength < 1) {
            double phi = Math.atan2(dy, Math.sqrt(distHoriz));
            double theta = Math.atan2(dz, dx);
            for (double iterator = 0.0; iterator <= distance; iterator += 0.5) {
                stateMap.put(p.func_177963_a(iterator * Math.cos(theta) * Math.cos(phi), iterator * Math.sin(phi), iterator * Math.sin(theta) * Math.cos(phi)), material);
            }
        }
    }

    public static interface IBridgeDataSupplier {
        public float getBridgeTension();

        public int getBridgeWidth();

        public IBlockState getBridgePathBlock();

        public IBlockState getBridgeFenceBlock();

        public IBlockState getBridgeRailingBlock();

        public IBlockState getBridgeAnchorBlock();
    }
}

