/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.castleparts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.RoomGridCell;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.RoomGridPosition;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.CastleRoomReplacedRoof;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.CastleRoomWalkableRoof;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.EnumRoomType;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.segments.CastleMainStructWall;

public class RoomGrid {
    private int floors;
    private int roomsX;
    private int roomsZ;
    private RoomGridCell[][][] cellArray;
    private List<RoomGridCell> cellList;
    private List<CastleMainStructWall> wallList;
    private Area2D bossArea = null;

    public RoomGrid(int floors, int roomsX, int roomsZ, int roomWidth, int floorHeight, Random random) {
        this.floors = floors;
        this.roomsX = roomsX;
        this.roomsZ = roomsZ;
        this.cellArray = new RoomGridCell[floors][roomsX][roomsZ];
        this.cellList = new ArrayList<RoomGridCell>();
        this.wallList = new ArrayList<CastleMainStructWall>();
        for (int floor = 0; floor < floors; ++floor) {
            for (int x = 0; x < roomsX; ++x) {
                for (int z = 0; z < roomsZ; ++z) {
                    RoomGridCell cell;
                    this.cellArray[floor][x][z] = cell = new RoomGridCell(floor, x, z, roomWidth, floorHeight);
                    this.cellList.add(cell);
                }
            }
        }
        this.initializeCellLinks();
        this.initializeWalls(roomWidth, floorHeight);
    }

    private void initializeCellLinks() {
        for (int floor = 0; floor < this.floors; ++floor) {
            for (int x = 0; x < this.roomsX; ++x) {
                for (int z = 0; z < this.roomsZ; ++z) {
                    RoomGridCell cell = this.getCellAt(floor, x, z);
                    for (EnumFacing direction : EnumFacing.field_82609_l) {
                        RoomGridCell adjacent = this.getAdjacentCell(cell, direction);
                        if (adjacent == null) continue;
                        cell.registerAdjacentCell(adjacent, direction);
                        adjacent.registerAdjacentCell(cell, direction.func_176734_d());
                    }
                }
            }
        }
    }

    private void initializeWalls(int roomWidth, int floorHeight) {
        CastleMainStructWall wall;
        BlockPos wallOrigin;
        int zOffset;
        int yOffset;
        int xOffset;
        int z;
        int x;
        int floor;
        int wallWidth = roomWidth + 2;
        for (floor = 0; floor < this.floors; ++floor) {
            for (x = 0; x < this.roomsX + 1; ++x) {
                for (z = 0; z < this.roomsZ; ++z) {
                    RoomGridCell eastCell;
                    xOffset = x * (roomWidth + 1);
                    yOffset = floor * floorHeight;
                    zOffset = z * (roomWidth + 1);
                    wallOrigin = new BlockPos(xOffset, yOffset, zOffset);
                    wall = new CastleMainStructWall(wallOrigin, CastleMainStructWall.WallOrientation.VERTICAL, wallWidth, floorHeight);
                    this.wallList.add(wall);
                    RoomGridCell westCell = this.getCellAt(floor, x - 1, z);
                    if (westCell != null) {
                        wall.registerAdjacentCell(westCell, EnumFacing.WEST);
                        westCell.registerAdjacentWall(wall, EnumFacing.EAST);
                    }
                    if ((eastCell = this.getCellAt(floor, x, z)) == null) continue;
                    wall.registerAdjacentCell(eastCell, EnumFacing.EAST);
                    eastCell.registerAdjacentWall(wall, EnumFacing.WEST);
                }
            }
        }
        for (floor = 0; floor < this.floors; ++floor) {
            for (x = 0; x < this.roomsX; ++x) {
                for (z = 0; z < this.roomsZ + 1; ++z) {
                    RoomGridCell southCell;
                    xOffset = x * (roomWidth + 1);
                    yOffset = floor * floorHeight;
                    zOffset = z * (roomWidth + 1);
                    wallOrigin = new BlockPos(xOffset, yOffset, zOffset);
                    wall = new CastleMainStructWall(wallOrigin, CastleMainStructWall.WallOrientation.HORIZONTAL, wallWidth, floorHeight);
                    this.wallList.add(wall);
                    RoomGridCell northCell = this.getCellAt(floor, x, z - 1);
                    if (northCell != null) {
                        wall.registerAdjacentCell(northCell, EnumFacing.NORTH);
                        northCell.registerAdjacentWall(wall, EnumFacing.SOUTH);
                    }
                    if ((southCell = this.getCellAt(floor, x, z)) == null) continue;
                    wall.registerAdjacentCell(southCell, EnumFacing.SOUTH);
                    southCell.registerAdjacentWall(wall, EnumFacing.NORTH);
                }
            }
        }
    }

    public void setRoomReachable(int floor, int x, int z) {
        this.cellArray[floor][x][z].setReachable();
    }

    public List<RoomGridCell> getCellListCopy() {
        return new ArrayList<RoomGridCell>(this.cellList);
    }

    public List<RoomGridCell> getAllCellsWhere(Predicate<RoomGridCell> p) {
        return this.getCellListCopy().stream().filter(p).collect(Collectors.toList());
    }

    public List<RoomGridCell> getSelectedCellsInColumn(int floor, int columnIndex) {
        List<RoomGridCell> result = this.getCellListCopy();
        result.removeIf(r -> r.getFloor() != floor);
        result.removeIf(r -> r.getGridX() != columnIndex);
        result.removeIf(r -> !r.isSelectedForBuilding());
        result.removeIf(r -> !r.isPopulated());
        return result;
    }

    public List<RoomGridCell> getSelectedCellsInRow(int floor, int rowIndex) {
        List<RoomGridCell> result = this.getCellListCopy();
        result.removeIf(r -> r.getFloor() != floor);
        result.removeIf(r -> r.getGridZ() != rowIndex);
        result.removeIf(r -> !r.isSelectedForBuilding());
        result.removeIf(r -> !r.isPopulated());
        return result;
    }

    public List<RoomGridCell> getSelectedMainStructCells(int floor) {
        List<RoomGridCell> result = this.getCellListCopy();
        result.removeIf(r -> r.getFloor() != floor);
        result.removeIf(r -> !r.isSelectedForBuilding());
        result.removeIf(r -> !r.isMainStruct());
        return result;
    }

    public List<RoomGridCell> getCellsWithoutAType() {
        List<RoomGridCell> result = this.getCellListCopy();
        result.removeIf(r -> !r.needsRoomType());
        return result;
    }

    public List<Area2D> getAllGridAreasWhere(int floor, Predicate<RoomGridCell> condition, int minDimension1, int minDimension2) {
        ArrayList<RoomGridPosition> floorPositions = new ArrayList<RoomGridPosition>();
        condition = condition.and(c -> c.getFloor() == floor);
        this.getAllCellsWhere(condition).forEach(c -> floorPositions.add(c.getGridPosition()));
        ArrayList<Area2D> areas = new ArrayList<Area2D>();
        Area2D largest = this.getLargestAreaWhere(floorPositions, condition);
        while (largest != null && !floorPositions.isEmpty() && largest.dimensionsAreAtLeast(minDimension1, minDimension2)) {
            areas.add(largest);
            largest.removeFromList(floorPositions);
            largest = this.getLargestAreaWhere(floorPositions, condition);
        }
        return areas;
    }

    public Area2D getPotentialRoomBuildArea(RoomGridPosition rootPosition) {
        int x = 1;
        int z = 1;
        boolean incX = true;
        boolean incZ = true;
        block0: do {
            RoomGridPosition checkPos;
            int i;
            if (incX) {
                ++x;
            }
            for (i = 0; i < z; ++i) {
                checkPos = rootPosition.move(EnumFacing.EAST, x - 1).move(EnumFacing.SOUTH, i);
                if (this.getCellAt(checkPos) != null && this.getCellAt(checkPos).needsRoomType()) continue;
                incX = false;
                --x;
                break;
            }
            if (incZ) {
                ++z;
            }
            for (i = 0; i < x; ++i) {
                checkPos = rootPosition.move(EnumFacing.EAST, i).move(EnumFacing.SOUTH, z - 1);
                if (this.getCellAt(checkPos) != null && this.getCellAt(checkPos).needsRoomType()) continue;
                incZ = false;
                --z;
                continue block0;
            }
        } while (incX || incZ);
        return new Area2D(rootPosition, x, z);
    }

    @Nullable
    public Area2D getLargestAreaWhere(List<RoomGridPosition> floorPositions, Predicate<RoomGridCell> condition) {
        int largestArea = 0;
        int largestX = 0;
        int largestZ = 0;
        RoomGridPosition largestStart = null;
        if (!floorPositions.isEmpty()) {
            for (RoomGridPosition startPos : floorPositions) {
                int x = 1;
                int z = 1;
                boolean incX = true;
                boolean incZ = true;
                block1: do {
                    RoomGridPosition checkPos;
                    int i;
                    if (incX) {
                        ++x;
                    }
                    for (i = 0; i < z; ++i) {
                        checkPos = startPos.move(EnumFacing.EAST, x - 1).move(EnumFacing.SOUTH, i);
                        if (floorPositions.contains(checkPos) && this.withinGridBounds(checkPos) && condition.test(this.getCellAt(checkPos))) continue;
                        incX = false;
                        --x;
                        break;
                    }
                    if (incZ) {
                        ++z;
                    }
                    for (i = 0; i < x; ++i) {
                        checkPos = startPos.move(EnumFacing.EAST, i).move(EnumFacing.SOUTH, z - 1);
                        if (floorPositions.contains(checkPos) && this.withinGridBounds(checkPos) && condition.test(this.getCellAt(checkPos))) continue;
                        incZ = false;
                        --z;
                        continue block1;
                    }
                } while (incX || incZ);
                int area = x * z;
                if (area <= largestArea && (x <= 1 || z <= 1 || largestX != 1 && largestZ != 1)) continue;
                largestArea = x * z;
                largestX = x;
                largestZ = z;
                largestStart = startPos;
            }
            return new Area2D(largestStart, largestX, largestZ);
        }
        return null;
    }

    public int getContiguousUntypedRoomsX(RoomGridPosition start) {
        RoomGridPosition pos = start;
        RoomGridCell cell = this.getCellAt(pos);
        int result = 0;
        while (cell != null && cell.needsRoomType()) {
            ++result;
            pos = pos.move(EnumFacing.EAST);
            cell = this.getCellAt(pos);
        }
        return result;
    }

    public int getContiguousUntypedRoomsZ(RoomGridPosition start) {
        RoomGridPosition pos = start;
        RoomGridCell cell = this.getCellAt(pos);
        int result = 0;
        while (cell != null && cell.needsRoomType()) {
            ++result;
            pos = pos.move(EnumFacing.SOUTH);
            cell = this.getCellAt(pos);
        }
        return result;
    }

    public RoomGridCell getCellAt(int floor, int x, int z) {
        if (this.withinGridBounds(floor, x, z)) {
            return this.cellArray[floor][x][z];
        }
        return null;
    }

    @Nullable
    public RoomGridCell getCellAt(RoomGridPosition position) {
        if (this.withinGridBounds(position.getFloor(), position.getX(), position.getZ())) {
            return this.cellArray[position.getFloor()][position.getX()][position.getZ()];
        }
        return null;
    }

    public void selectBlockOfCellsForBuilding(Area2D area, int numFloors) {
        List<RoomGridPosition> positions = area.getPositionList();
        for (RoomGridPosition areaPos : positions) {
            RoomGridCell cell;
            RoomGridPosition gridPos;
            int floor;
            for (floor = 0; floor < numFloors; ++floor) {
                gridPos = areaPos.move(EnumFacing.UP, floor);
                cell = this.getCellAt(gridPos);
                if (cell == null) continue;
                cell.selectForBuilding();
            }
            gridPos = areaPos.move(EnumFacing.UP, floor);
            cell = this.getCellAt(gridPos);
            if (cell == null) continue;
            cell.setBuildable();
        }
        this.initPathingForCellArea(area, numFloors);
    }

    public void initPathingForCellArea(Area2D baseArea, int floors) {
        for (int floor = 0; floor < floors; ++floor) {
            Area2D currentFloorArea = floor == 0 ? baseArea : baseArea.addFloors(floor);
            HashSet<RoomGridCell> cellsInArea = new HashSet<RoomGridCell>();
            currentFloorArea.getPositionList().forEach(p -> cellsInArea.add(this.getCellAt((RoomGridPosition)p)));
            for (RoomGridCell cell : cellsInArea) {
                if (cell == null) {
                    CQRMain.logger.error("How did this happen?");
                    return;
                }
                cell.addPathableCells(cellsInArea);
            }
            this.setPathingForCellSet(cellsInArea);
        }
    }

    public void initPathingForSingleCell(RoomGridPosition gridPos) {
        if (this.withinGridBounds(gridPos) && this.getCellAt(gridPos) != null) {
            HashSet<RoomGridCell> cellsInArea = new HashSet<RoomGridCell>();
            cellsInArea.add(this.getCellAt(gridPos));
            this.setPathingForCellSet(cellsInArea);
        }
    }

    private void setPathingForCellSet(Set<RoomGridCell> cellsInArea) {
        HashSet<RoomGridCell> masterPathList = new HashSet<RoomGridCell>();
        for (RoomGridCell cell : cellsInArea) {
            masterPathList.add(cell);
            for (EnumFacing direction : EnumFacing.field_176754_o) {
                RoomGridCell adjacent = this.getAdjacentCell(cell, direction);
                if (adjacent == null || cellsInArea.contains(adjacent) || !adjacent.isSelectedForBuilding() || cell.getPathableCellsCopy().contains(adjacent)) continue;
                masterPathList.addAll(adjacent.getPathableCellsCopy());
            }
        }
        for (RoomGridCell cell : masterPathList) {
            cell.addPathableCells(masterPathList);
        }
    }

    public boolean adjacentCellIsPopulated(RoomGridCell startCell, EnumFacing direction) {
        RoomGridCell adjacent = this.getAdjacentCell(startCell, direction);
        return adjacent != null && adjacent.isPopulated();
    }

    public boolean adjacentCellIsFullRoom(RoomGridCell startCell, EnumFacing direction) {
        RoomGridCell adjacent = this.getAdjacentCell(startCell, direction);
        return adjacent != null && adjacent.isPopulated() && !(adjacent.getRoom() instanceof CastleRoomWalkableRoof);
    }

    public boolean adjacentCellIsSelected(RoomGridCell startCell, EnumFacing direction) {
        RoomGridCell adjacent = this.getAdjacentCell(startCell, direction);
        return adjacent != null && adjacent.isSelectedForBuilding();
    }

    public boolean adjacentCellIsWalkableRoof(RoomGridCell startCell, EnumFacing direction) {
        RoomGridCell adjacent = this.getAdjacentCell(startCell, direction);
        return adjacent != null && adjacent.isPopulated() && adjacent.getRoom() instanceof CastleRoomWalkableRoof;
    }

    public boolean cellIsValidForRoof(RoomGridCell cell) {
        RoomGridCell below = this.getAdjacentCell(cell, EnumFacing.DOWN);
        return below != null && !cell.isSelectedForBuilding() && below.isPopulated() && below.getFloor() != this.bossArea.start.getFloor();
    }

    public boolean cellIsOuterEdge(RoomGridCell cell, EnumFacing direction) {
        RoomGridPosition coords = cell.getGridPosition();
        coords = coords.move(direction);
        while (this.withinGridBounds(coords)) {
            if (this.getCellAt(coords).isPopulated()) {
                return false;
            }
            coords = coords.move(direction);
        }
        return true;
    }

    public List<RoomGridCell> getBridgeCells(RoomGridCell cell, EnumFacing direction) {
        ArrayList<RoomGridCell> result = new ArrayList<RoomGridCell>();
        Optional<RoomGridCell> next = cell.getAdjacentCell(direction);
        while (next.isPresent() && next.get().isValidForBridge()) {
            result.add(next.get());
            next = next.get().getAdjacentCell(direction);
        }
        if (!next.isPresent()) {
            result.clear();
        } else if (!next.get().isPopulated()) {
            result.clear();
        } else if (next.get().isPopulated() && !next.get().reachableFromSide(direction.func_176734_d())) {
            result.clear();
        } else if (next.get().isPopulated() && next.get().getRoom() instanceof CastleRoomReplacedRoof) {
            result.clear();
        }
        return result;
    }

    public List<RoomGridCell> getAdjacentSelectedCellsInRow(RoomGridPosition position) {
        ArrayList<RoomGridCell> result = new ArrayList<RoomGridCell>();
        while (this.getCellAt(position.move(EnumFacing.WEST)) != null && this.getCellAt(position.move(EnumFacing.WEST)).isSelectedForBuilding()) {
            position = position.move(EnumFacing.WEST);
        }
        result.add(this.getCellAt(position));
        while (this.getCellAt(position.move(EnumFacing.EAST)) != null && this.getCellAt(position.move(EnumFacing.EAST)).isSelectedForBuilding()) {
            position = position.move(EnumFacing.EAST);
            result.add(this.getCellAt(position));
        }
        return result;
    }

    public List<RoomGridCell> getAdjacentSelectedCellsInColumn(RoomGridPosition position) {
        ArrayList<RoomGridCell> result = new ArrayList<RoomGridCell>();
        while (this.getCellAt(position.move(EnumFacing.NORTH)) != null && this.getCellAt(position.move(EnumFacing.NORTH)).isSelectedForBuilding()) {
            position = position.move(EnumFacing.NORTH);
        }
        result.add(this.getCellAt(position));
        while (this.getCellAt(position.move(EnumFacing.SOUTH)) != null && this.getCellAt(position.move(EnumFacing.SOUTH)).isSelectedForBuilding()) {
            position = position.move(EnumFacing.SOUTH);
            result.add(this.getCellAt(position));
        }
        return result;
    }

    public boolean canAttachTower(RoomGridCell cell, EnumFacing side) {
        RoomGridCell adjacent = this.getAdjacentCell(cell, side);
        return !cell.getRoom().isTower() && adjacent != null && (!adjacent.isPopulated() || cell.getRoom().isStairsOrLanding());
    }

    public double distanceBetweenCells2D(RoomGridCell c1, RoomGridCell c2) {
        int distX = Math.abs(c1.getGridX() - c2.getGridX());
        int distZ = Math.abs(c1.getGridZ() - c2.getGridZ());
        return Math.hypot(distX, distZ);
    }

    public boolean cellBordersRoomType(RoomGridCell cell, EnumRoomType type) {
        for (EnumFacing side : EnumFacing.field_176754_o) {
            RoomGridCell adjacent = this.getAdjacentCell(cell, side);
            if (adjacent == null || !adjacent.isPopulated() || adjacent.getRoom().getRoomType() != type) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public RoomGridCell getAdjacentCell(RoomGridCell startCell, EnumFacing direction) {
        RoomGridPosition position = startCell.getGridPosition().move(direction);
        if (this.withinGridBounds(position)) {
            return this.cellArray[position.getFloor()][position.getX()][position.getZ()];
        }
        return null;
    }

    public void setBossArea(Area2D area) {
        this.bossArea = new Area2D(area);
    }

    public List<CastleMainStructWall> getWallListCopy() {
        return new ArrayList<CastleMainStructWall>(this.wallList);
    }

    @Nullable
    public Area2D getBossArea() {
        return this.bossArea;
    }

    public boolean bossAreaSet() {
        return this.bossArea != null;
    }

    public boolean withinGridBounds(int floor, int x, int z) {
        return floor >= 0 && floor < this.floors && this.withinFloorBounds(x, z);
    }

    public boolean withinGridBounds(RoomGridPosition position) {
        return position.getFloor() >= 0 && position.getFloor() < this.floors && this.withinFloorBounds(position.getX(), position.getZ());
    }

    public boolean withinFloorBounds(int x, int z) {
        return x >= 0 && x < this.roomsX && z >= 0 && z < this.roomsZ;
    }

    public static class Area2D {
        public RoomGridPosition start;
        public int sizeX;
        public int sizeZ;

        public Area2D(RoomGridPosition start, int sizeX, int sizeZ) {
            this.start = start;
            this.sizeX = sizeX;
            this.sizeZ = sizeZ;
        }

        public Area2D(Area2D area) {
            this.start = area.start;
            this.sizeX = area.sizeX;
            this.sizeZ = area.sizeZ;
        }

        public Area2D addFloors(int numFloors) {
            return new Area2D(this.start.move(EnumFacing.UP, numFloors), this.sizeX, this.sizeZ);
        }

        public int getStartX() {
            return this.start.getX();
        }

        public int getStartZ() {
            return this.start.getZ();
        }

        public int getEndX() {
            return this.start.getX() + this.sizeX - 1;
        }

        public int getEndZ() {
            return this.start.getZ() + this.sizeZ - 1;
        }

        public RoomGridPosition getTopRight() {
            return this.start.move(EnumFacing.EAST, this.sizeX - 1);
        }

        public RoomGridPosition getBottomLeft() {
            return this.start.move(EnumFacing.SOUTH, this.sizeZ - 1);
        }

        public boolean dimensionsAre(int dim1, int dim2) {
            return this.sizeX == dim1 && this.sizeZ == dim2 || this.sizeX == dim2 && this.sizeZ == 1;
        }

        public boolean dimensionsAreAtLeast(int dim1, int dim2) {
            int larger = Math.max(dim1, dim2);
            int smaller = Math.min(dim1, dim2);
            return Math.min(this.sizeX, this.sizeZ) >= smaller && Math.max(this.sizeX, this.sizeZ) >= larger;
        }

        public int countXCellsToPosition(RoomGridPosition gridPos) {
            return gridPos.getX() - this.start.getX();
        }

        public int countZCellsToPosition(RoomGridPosition gridPos) {
            return gridPos.getZ() - this.start.getZ();
        }

        public List<RoomGridPosition> getPositionList() {
            ArrayList<RoomGridPosition> positions = new ArrayList<RoomGridPosition>();
            for (int x = 0; x < this.sizeX; ++x) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    positions.add(this.start.move(EnumFacing.EAST, x).move(EnumFacing.SOUTH, z));
                }
            }
            return positions;
        }

        public void removeFromList(List<RoomGridPosition> positions) {
            List<RoomGridPosition> myPositions = this.getPositionList();
            positions.removeAll(myPositions);
        }

        public Area2D getRandomSubArea(Random random, int minDim1, int minDim2, boolean mustBeSmaller) {
            if (this.dimensionsAreAtLeast(minDim1, minDim2)) {
                int resultZ;
                int resultX;
                boolean fitsZ;
                int shrink = mustBeSmaller ? 1 : 0;
                int larger = Math.max(minDim1, minDim2);
                int smaller = Math.min(minDim1, minDim2);
                boolean fitsX = this.sizeX >= larger;
                boolean bl = fitsZ = this.sizeZ >= larger;
                if (fitsX && fitsZ) {
                    if (random.nextBoolean()) {
                        resultX = DungeonGenUtils.randomBetweenGaussian(larger, this.sizeX - shrink, random);
                        resultZ = DungeonGenUtils.randomBetweenGaussian(smaller, this.sizeZ - shrink, random);
                    } else {
                        resultZ = DungeonGenUtils.randomBetweenGaussian(larger, this.sizeZ - shrink, random);
                        resultX = DungeonGenUtils.randomBetweenGaussian(smaller, this.sizeX - shrink, random);
                    }
                } else if (fitsX) {
                    resultX = DungeonGenUtils.randomBetweenGaussian(larger, this.sizeX - shrink, random);
                    resultZ = DungeonGenUtils.randomBetweenGaussian(smaller, this.sizeZ - shrink, random);
                } else {
                    resultZ = DungeonGenUtils.randomBetweenGaussian(larger, this.sizeZ - shrink, random);
                    resultX = DungeonGenUtils.randomBetweenGaussian(smaller, this.sizeX - shrink, random);
                }
                return this.randomlyPositionSubArea(random, resultX, resultZ);
            }
            return this;
        }

        public Area2D getExactSubArea(Random random, int minDim1, int minDim2) {
            if (this.dimensionsAreAtLeast(minDim1, minDim2)) {
                int larger = Math.max(minDim1, minDim2);
                int smaller = Math.min(minDim1, minDim2);
                boolean fitsX = this.sizeX >= larger;
                boolean fitsZ = this.sizeZ >= larger;
                boolean xIsLonger = fitsX && fitsZ ? random.nextBoolean() : fitsX;
                int resultX = xIsLonger ? larger : smaller;
                int resultZ = xIsLonger ? smaller : larger;
                return this.randomlyPositionSubArea(random, resultX, resultZ);
            }
            return this;
        }

        private Area2D randomlyPositionSubArea(Random random, int resultX, int resultZ) {
            RoomGridPosition subStart = this.start;
            int maxMoveX = this.sizeX - resultX;
            int maxMoveZ = this.sizeZ - resultZ;
            if (maxMoveX > 0) {
                subStart = subStart.move(EnumFacing.EAST, random.nextInt(this.sizeX - resultX));
            }
            if (maxMoveZ > 0) {
                subStart = subStart.move(EnumFacing.SOUTH, random.nextInt(this.sizeZ - resultZ));
            }
            return new Area2D(subStart, resultX, resultZ);
        }

        @Nullable
        public Area2D sliceToSideOfArea(Area2D mask, EnumFacing side) {
            if (mask != null) {
                int resultSizeZ;
                int resultSizeX;
                RoomGridPosition resultStart;
                if (side == EnumFacing.NORTH) {
                    resultStart = this.start;
                    resultSizeX = this.sizeX;
                    resultSizeZ = mask.getStartZ() - this.getStartZ();
                } else if (side == EnumFacing.SOUTH) {
                    resultStart = new RoomGridPosition(this.start.getFloor(), this.start.getX(), mask.getEndZ() + 1);
                    resultSizeX = this.sizeX;
                    resultSizeZ = this.getEndZ() - mask.getEndZ();
                } else if (side == EnumFacing.WEST) {
                    resultStart = this.start;
                    resultSizeX = mask.getStartX() - this.getStartX();
                    resultSizeZ = this.sizeZ;
                } else {
                    resultStart = new RoomGridPosition(this.start.getFloor(), mask.getEndX() + 1, this.start.getZ());
                    resultSizeX = this.getEndX() - mask.getEndX();
                    resultSizeZ = this.sizeZ;
                }
                List<RoomGridPosition> boundary = this.getPositionList();
                if (boundary.contains(resultStart) && resultSizeX > 0 && resultSizeZ > 0) {
                    return new Area2D(resultStart, resultSizeX, resultSizeZ);
                }
                return null;
            }
            return null;
        }

        public void alignToSide(Random random, Area2D targetArea, EnumFacing side, Area2D boundary) {
            if (side == EnumFacing.NORTH) {
                this.start.setZ(targetArea.getStartZ() - this.sizeZ);
                int minSlide = Math.max(targetArea.getStartX() - (this.sizeX - 1), boundary.start.getX());
                int maxSlide = Math.min(targetArea.getEndX(), boundary.getEndX() - (this.sizeX - 1));
                int slideDest = DungeonGenUtils.randomBetweenGaussian(minSlide, maxSlide, random);
                this.start.setX(slideDest);
            } else if (side == EnumFacing.SOUTH) {
                this.start.setZ(targetArea.getEndZ() + 1);
                int minSlide = Math.max(targetArea.getStartX() - (this.sizeX - 1), boundary.start.getX());
                int maxSlide = Math.min(targetArea.getEndX(), boundary.getEndX() - (this.sizeX - 1));
                int slideDest = DungeonGenUtils.randomBetweenGaussian(minSlide, maxSlide, random);
                this.start.setX(slideDest);
            } else if (side == EnumFacing.WEST) {
                this.start.setX(targetArea.getStartX() - this.sizeX);
                int minSlide = Math.max(targetArea.getStartZ() - (this.sizeZ - 1), boundary.start.getZ());
                int maxSlide = Math.min(targetArea.getEndZ(), boundary.getEndZ() - (this.sizeZ - 1));
                int slideDest = DungeonGenUtils.randomBetweenGaussian(minSlide, maxSlide, random);
                this.start.setZ(slideDest);
            } else {
                this.start.setX(targetArea.getEndX() + 1);
                int minSlide = Math.max(targetArea.getStartZ() - (this.sizeZ - 1), boundary.start.getZ());
                int maxSlide = Math.min(targetArea.getEndZ(), boundary.getEndZ() - (this.sizeZ - 1));
                int slideDest = DungeonGenUtils.randomBetweenGaussian(minSlide, maxSlide, random);
                this.start.setZ(slideDest);
            }
        }

        public String toString() {
            return String.format("RoomGrid.Area2D{start=%s, sizeX=%d, sizeZ=%d}", this.start, this.sizeX, this.sizeZ);
        }
    }
}

