/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.decoration.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.CastleRoomBase;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.decoration.IRoomDecor;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.decoration.objects.DecoBlockBase;

public abstract class RoomDecorBlocksBase
implements IRoomDecor {
    protected List<DecoBlockBase> schematic = new ArrayList<DecoBlockBase>();

    protected RoomDecorBlocksBase() {
        this.makeSchematic();
    }

    protected abstract void makeSchematic();

    @Override
    public boolean wouldFit(BlockPos start, EnumFacing side, Set<BlockPos> decoArea, Set<BlockPos> decoMap, CastleRoomBase room) {
        List<DecoBlockBase> rotated = this.alignSchematic(side);
        for (DecoBlockBase placement : rotated) {
            BlockPos pos = start.func_177971_a(placement.offset);
            if (decoArea.contains(pos) && !decoMap.contains(pos)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void build(World world, BlockStateGenArray genArray, CastleRoomBase room, DungeonRandomizedCastle dungeon, BlockPos start, EnumFacing side, Set<BlockPos> decoMap) {
        List<DecoBlockBase> rotated = this.alignSchematic(side);
        for (DecoBlockBase placement : rotated) {
            BlockPos pos = start.func_177971_a(placement.offset);
            genArray.addBlockState(pos, placement.getState(side), placement.getGenPhase(), BlockStateGenArray.EnumPriority.MEDIUM);
            if (placement.getState(side).func_177230_c() == Blocks.field_150350_a) continue;
            decoMap.add(pos);
        }
    }

    protected List<DecoBlockBase> alignSchematic(EnumFacing side) {
        ArrayList<DecoBlockBase> result = new ArrayList<DecoBlockBase>();
        for (DecoBlockBase p : this.schematic) {
            result.add(new DecoBlockBase(DungeonGenUtils.rotateVec3i(p.offset, side), p.getState(side), p.getGenPhase()));
        }
        return result;
    }
}

