/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.decoration.paintings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class RoomDecorPainting {
    private Map<EntityPainting.EnumArt, List<Vec3i>> artFootprints = new EnumMap<EntityPainting.EnumArt, List<Vec3i>>(EntityPainting.EnumArt.class);

    public RoomDecorPainting() {
        for (EntityPainting.EnumArt art : EntityPainting.EnumArt.values()) {
            this.artFootprints.put(art, this.getFootPrintFromArtType(art));
        }
    }

    public boolean wouldFit(BlockPos start, EnumFacing side, Set<BlockPos> decoArea, Set<BlockPos> decoMap) {
        return !this.getArtThatWouldFit(start, side, decoArea, decoMap).isEmpty();
    }

    public void buildRandom(World world, BlockPos start, BlockStateGenArray genArray, EnumFacing side, Set<BlockPos> decoArea, Set<BlockPos> decoMap) {
        List<EntityPainting.EnumArt> artList = this.getArtThatWouldFit(start, side, decoArea, decoMap);
        if (!artList.isEmpty()) {
            Collections.shuffle(artList);
            this.build(artList.get(0), world, start, genArray, side, decoMap);
        }
    }

    public void build(EntityPainting.EnumArt art, World world, BlockPos start, BlockStateGenArray genArray, EnumFacing side, Set<BlockPos> decoMap) {
        List<Vec3i> rotated = this.alignFootprint(this.artFootprints.get(art), side);
        for (Vec3i placement : rotated) {
            BlockPos pos = start.func_177971_a(placement);
            decoMap.add(pos);
        }
        this.createEntityDecoration(art, world, start, genArray, side);
    }

    protected void createEntityDecoration(EntityPainting.EnumArt art, World world, BlockPos pos, BlockStateGenArray genArray, EnumFacing side) {
        EntityPainting painting = new EntityPainting(world);
        painting.field_70522_e = art;
        painting.field_174860_b = side.func_176734_d();
        float rotation = side.func_185119_l();
        painting.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        painting.field_70177_z = rotation;
        genArray.addEntity(BlockPos.field_177992_a, (Entity)painting);
    }

    public List<EntityPainting.EnumArt> getArtThatWouldFit(BlockPos start, EnumFacing side, Set<BlockPos> decoArea, Set<BlockPos> decoMap) {
        ArrayList<EntityPainting.EnumArt> fitList = new ArrayList<EntityPainting.EnumArt>();
        for (EntityPainting.EnumArt art : EntityPainting.EnumArt.values()) {
            boolean fits = true;
            List<Vec3i> rotated = this.alignFootprint(this.artFootprints.get(art), side);
            for (Vec3i placement : rotated) {
                BlockPos pos = start.func_177971_a(placement);
                if (decoArea.contains(pos) && !decoMap.contains(pos)) continue;
                fits = false;
                break;
            }
            if (!fits) continue;
            fitList.add(art);
        }
        return fitList;
    }

    private List<Vec3i> getFootPrintFromArtType(EntityPainting.EnumArt artType) {
        int pixelsPerBlock = 16;
        ArrayList<Vec3i> footprint = new ArrayList<Vec3i>();
        int blockWidth = artType.field_75703_B / 16;
        int blockHeight = artType.field_75704_C / 16;
        for (int x = 0; x < blockWidth; ++x) {
            for (int y = 0; y < blockHeight; ++y) {
                footprint.add(new Vec3i(x, y, 0));
            }
        }
        return footprint;
    }

    protected List<Vec3i> alignFootprint(List<Vec3i> unrotated, EnumFacing side) {
        ArrayList<Vec3i> result = new ArrayList<Vec3i>();
        unrotated.forEach(v -> result.add(DungeonGenUtils.rotateVec3i(v, side)));
        return result;
    }
}

