/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.hangingcity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonHangingCity;
import team.cqr.cqrepoured.world.structure.generation.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.world.structure.generation.generators.hangingcity.HangingCityBuilding;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.world.structure.generation.structurefile.CQStructure;

public class GeneratorHangingCity
extends AbstractDungeonGenerator<DungeonHangingCity> {
    private int islandCount = 1;
    private int islandDistance = 1;
    private HangingCityBuilding[][] buildingGrid;
    private Set<HangingCityBuilding> buildings = new HashSet<HangingCityBuilding>();
    private final DungeonInhabitant mobType = DungeonInhabitantManager.instance().getInhabitantByDistanceIfDefault(((DungeonHangingCity)this.dungeon).getDungeonMob(), this.world, this.pos.func_177958_n(), this.pos.func_177952_p());

    public GeneratorHangingCity(World world, BlockPos pos, DungeonHangingCity dungeon, Random rand) {
        super(world, pos, dungeon, rand);
    }

    @Override
    public void preProcess() {
        this.islandCount = DungeonGenUtils.randomBetween(((DungeonHangingCity)this.dungeon).getMinBuildings(), ((DungeonHangingCity)this.dungeon).getMaxBuildings(), this.random);
        this.islandDistance = DungeonGenUtils.randomBetween(((DungeonHangingCity)this.dungeon).getMinIslandDistance(), ((DungeonHangingCity)this.dungeon).getMaxIslandDistance(), this.random);
        if (this.islandCount % 2 == 0) {
            ++this.islandCount;
        }
        this.buildingGrid = new HangingCityBuilding[2 * this.islandCount + 4][2 * this.islandCount + 4];
        int offsetXY = this.islandCount + 2;
        HangingCityBuilding lastProcessed = null;
        CQStructure structure = this.loadStructureFromFile(((DungeonHangingCity)this.dungeon).pickCentralStructure(this.random));
        for (int i = 0; i < this.islandCount; ++i) {
            Tuple coords = new Tuple((Object)0, (Object)0);
            if (lastProcessed != null) {
                structure = this.loadStructureFromFile(((DungeonHangingCity)this.dungeon).pickStructure(this.random));
                ArrayList<HangingCityBuilding> buildings = new ArrayList<HangingCityBuilding>(this.buildings);
                Collections.shuffle(buildings, this.random);
                LinkedList<HangingCityBuilding> buildingQueue = new LinkedList<HangingCityBuilding>(buildings);
                while (!buildingQueue.isEmpty()) {
                    HangingCityBuilding chosen = (HangingCityBuilding)buildingQueue.remove();
                    if (!chosen.hasFreeNeighbourSpots()) continue;
                    ArrayList<Tuple<Integer, Integer>> spots = new ArrayList<Tuple<Integer, Integer>>(chosen.getFreeNeighbourSpots());
                    Collections.shuffle(spots, this.random);
                    coords = (Tuple)spots.get(0);
                    break;
                }
            }
            this.buildingGrid[offsetXY + ((Integer)coords.func_76341_a()).intValue()][offsetXY + ((Integer)coords.func_76340_b()).intValue()] = new HangingCityBuilding(this, (Integer)coords.func_76341_a(), (Integer)coords.func_76340_b(), structure);
            this.buildingGrid[offsetXY + (Integer)coords.func_76341_a()][offsetXY + (Integer)coords.func_76340_b()].preProcess(this.world, this.dungeonBuilder, null);
            this.buildings.add(this.buildingGrid[offsetXY + (Integer)coords.func_76341_a()][offsetXY + (Integer)coords.func_76340_b()]);
            lastProcessed = this.buildingGrid[offsetXY + (Integer)coords.func_76341_a()][offsetXY + (Integer)coords.func_76340_b()];
        }
        if (((DungeonHangingCity)this.dungeon).isConstructBridges()) {
            block2: for (HangingCityBuilding building : this.buildings) {
                int[] directNeighbours;
                HangingCityBuilding[] neighbours = building.getNeighbours();
                for (int in : directNeighbours = new int[]{3, 6, 4, 1, 0, 5, 7, 2}) {
                    if (neighbours[in] == null || building.isConnectedTo(neighbours[in])) continue;
                    building.connectTo(neighbours[in]);
                    continue block2;
                }
            }
        }
    }

    @Override
    public void buildStructure() {
        for (HangingCityBuilding building : this.buildings) {
            building.generate(this.getWorld(), this.dungeonBuilder, this.mobType);
        }
    }

    @Override
    public void postProcess() {
        for (HangingCityBuilding building : this.buildings) {
            building.generatePost(this.getWorld(), this.dungeonBuilder, this.mobType);
        }
    }

    HangingCityBuilding getBuildingFromGridPos(int x, int y) {
        return this.buildingGrid[x += this.islandCount + 2][y += this.islandCount + 2];
    }

    final BlockPos getCenterPosForIsland(HangingCityBuilding building) {
        BlockPos centerGen = this.pos;
        int offsetX = this.islandDistance * building.getGridPosX();
        int offsetZ = this.islandDistance * building.getGridPosY();
        int offsetY = ((DungeonHangingCity)this.dungeon).getRandomHeightVariation(this.random);
        BlockPos pos = centerGen.func_177982_a(offsetX, offsetY, offsetZ);
        return pos;
    }

    public BlockPos getPos() {
        return this.pos;
    }
}

