/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.stronghold.linear;

import java.io.File;
import java.util.Random;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import team.cqr.cqrepoured.util.ESkyDirection;
import team.cqr.cqrepoured.world.structure.generation.generation.GeneratableDungeon;
import team.cqr.cqrepoured.world.structure.generation.generators.AbstractDungeonGenerationComponent;
import team.cqr.cqrepoured.world.structure.generation.generators.stronghold.EStrongholdRoomType;
import team.cqr.cqrepoured.world.structure.generation.generators.stronghold.GeneratorStronghold;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.world.structure.generation.structurefile.CQStructure;
import team.cqr.cqrepoured.world.structure.generation.structurefile.Offset;

public class StrongholdFloor
extends AbstractDungeonGenerationComponent<GeneratorStronghold> {
    private final Random random;
    private int sideLength;
    private EStrongholdRoomType[][] roomPattern;
    private ESkyDirection currentDirection;
    private boolean lastFloor;
    private int lastX;
    private int lastZ;

    public StrongholdFloor(int size, GeneratorStronghold generator, boolean isLastFloor, Random rand) {
        super(generator);
        this.sideLength = size;
        this.lastFloor = isLastFloor;
        this.roomPattern = new EStrongholdRoomType[size][size];
        this.random = rand;
    }

    public void generateRoomPattern(int gridPosX, int gridPosZ, ESkyDirection prevFloorExitDir) {
        int slCounter;
        this.setRoomType(gridPosX, gridPosZ, EStrongholdRoomType.NONE);
        boolean curve = gridPosX == 0 && gridPosZ == 0;
        Tuple<Integer, Integer> roomCoord = new Tuple<Integer, Integer>((Object)gridPosX, (Object)gridPosZ);
        boolean reversed = !curve;
        int sideLengthTemp = reversed ? this.sideLength : 1;
        int n = slCounter = reversed ? sideLengthTemp * 4 - 4 - 1 : 1;
        if (reversed && sideLengthTemp <= 3) {
            --slCounter;
        }
        this.currentDirection = prevFloorExitDir;
        int roomCount = this.sideLength * this.sideLength;
        --roomCount;
        while (roomCount > 0) {
            roomCoord = this.getNextRoomCoordinates((Integer)roomCoord.func_76341_a(), (Integer)roomCoord.func_76340_b(), this.currentDirection);
            --slCounter;
            if (--roomCount == 0) {
                if (this.lastFloor) {
                    this.setRoomType((Integer)roomCoord.func_76341_a(), (Integer)roomCoord.func_76340_b(), EStrongholdRoomType.BOSS);
                    break;
                }
                this.setRoomType((Integer)roomCoord.func_76341_a(), (Integer)roomCoord.func_76340_b(), this.getStair(this.currentDirection));
                this.currentDirection = this.getRoomExitDirection(this.getStair(this.currentDirection));
                break;
            }
            if (slCounter <= 0 || !reversed && slCounter > 1 && this.isCurveRoom((Integer)roomCoord.func_76341_a(), (Integer)roomCoord.func_76340_b()) || reversed && slCounter > 1 && slCounter < sideLengthTemp * 4 - 4 - 2 && this.isCurveRoom((Integer)roomCoord.func_76341_a(), (Integer)roomCoord.func_76340_b())) {
                if (slCounter <= 0) {
                    slCounter = (sideLengthTemp += reversed ? -2 : 2) * 4 - 4;
                    if (reversed) {
                        --slCounter;
                    }
                }
                this.setRoomType((Integer)roomCoord.func_76341_a(), (Integer)roomCoord.func_76340_b(), this.getCurve(this.currentDirection, reversed));
                this.currentDirection = this.getRoomExitDirection(this.getCurve(this.currentDirection, reversed));
                continue;
            }
            this.setRoomType((Integer)roomCoord.func_76341_a(), (Integer)roomCoord.func_76340_b(), this.getHallway(this.currentDirection));
        }
    }

    private EStrongholdRoomType getHallway(ESkyDirection dir) {
        switch (dir) {
            case EAST: {
                return EStrongholdRoomType.HALLWAY_WE;
            }
            case NORTH: {
                return EStrongholdRoomType.HALLWAY_SN;
            }
            case SOUTH: {
                return EStrongholdRoomType.HALLWAY_NS;
            }
            case WEST: {
                return EStrongholdRoomType.HALLWAY_EW;
            }
        }
        return null;
    }

    private EStrongholdRoomType getStair(ESkyDirection dir) {
        switch (dir) {
            case EAST: {
                return EStrongholdRoomType.STAIR_WW;
            }
            case NORTH: {
                return EStrongholdRoomType.STAIR_SS;
            }
            case SOUTH: {
                return EStrongholdRoomType.STAIR_NN;
            }
            case WEST: {
                return EStrongholdRoomType.STAIR_EE;
            }
        }
        return null;
    }

    private EStrongholdRoomType getCurve(ESkyDirection dir, boolean reversed) {
        switch (dir) {
            case EAST: {
                return reversed ? EStrongholdRoomType.CURVE_WS : EStrongholdRoomType.CURVE_WN;
            }
            case NORTH: {
                return reversed ? EStrongholdRoomType.CURVE_SE : EStrongholdRoomType.CURVE_SW;
            }
            case SOUTH: {
                return reversed ? EStrongholdRoomType.CURVE_NW : EStrongholdRoomType.CURVE_NE;
            }
            case WEST: {
                return reversed ? EStrongholdRoomType.CURVE_EN : EStrongholdRoomType.CURVE_ES;
            }
        }
        return null;
    }

    public void generateRooms(int centerX, int centerZ, int y, PlacementSettings settings, GeneratableDungeon.Builder dungeonBuilder, World world, DungeonInhabitant mobType) {
        for (int iX = 0; iX < this.sideLength; ++iX) {
            for (int iZ = 0; iZ < this.sideLength; ++iZ) {
                EStrongholdRoomType room = this.roomPattern[iX][iZ];
                if (room == null || room == EStrongholdRoomType.NONE) continue;
                Tuple<Integer, Integer> gridPos = this.arrayIndiciesToGridPos((Tuple<Integer, Integer>)new Tuple((Object)iX, (Object)iZ));
                int x = centerX + (Integer)gridPos.func_76341_a() * ((GeneratorStronghold)this.generator).getDungeon().getRoomSizeX();
                int z = centerZ + (Integer)gridPos.func_76340_b() * ((GeneratorStronghold)this.generator).getDungeon().getRoomSizeZ();
                int y1 = y;
                if (room.toString().startsWith("STAIR_")) {
                    y1 -= ((GeneratorStronghold)this.generator).getDungeon().getRoomSizeY();
                }
                BlockPos pos = new BlockPos(x, y1, z);
                File struct = ((GeneratorStronghold)this.generator).getDungeon().getRoom(room, this.random);
                if (struct == null) continue;
                CQStructure structure = ((GeneratorStronghold)this.generator).loadStructureFromFile(struct);
                structure.addAll(dungeonBuilder, pos, Offset.CENTER);
            }
        }
    }

    private Tuple<Integer, Integer> getNextRoomCoordinates(int oldX, int oldZ, ESkyDirection direction) {
        switch (direction) {
            case EAST: {
                return new Tuple((Object)(oldX + 1), (Object)oldZ);
            }
            case NORTH: {
                return new Tuple((Object)oldX, (Object)(oldZ - 1));
            }
            case SOUTH: {
                return new Tuple((Object)oldX, (Object)(oldZ + 1));
            }
            case WEST: {
                return new Tuple((Object)(oldX - 1), (Object)oldZ);
            }
        }
        return new Tuple((Object)oldX, (Object)oldZ);
    }

    public Tuple<Integer, Integer> getLastRoomGridPos() {
        return new Tuple((Object)this.lastX, (Object)this.lastZ);
    }

    private Tuple<Integer, Integer> gridPosToArrayIndices(Tuple<Integer, Integer> gridPosIn) {
        int x = (int)Math.floor((double)this.sideLength / 2.0);
        return new Tuple((Object)((Integer)gridPosIn.func_76341_a() + x), (Object)((Integer)gridPosIn.func_76340_b() + x));
    }

    private Tuple<Integer, Integer> arrayIndiciesToGridPos(Tuple<Integer, Integer> arrayIndiciesIn) {
        int x = (int)Math.floor((double)this.sideLength / 2.0);
        return new Tuple((Object)((Integer)arrayIndiciesIn.func_76341_a() - x), (Object)((Integer)arrayIndiciesIn.func_76340_b() - x));
    }

    public ESkyDirection getExitDirection() {
        return this.currentDirection;
    }

    private boolean isCurveRoom(int gpX, int gpZ) {
        return Math.abs(gpX) == Math.abs(gpZ);
    }

    private void setRoomType(int gpX, int gpZ, EStrongholdRoomType type) {
        Tuple<Integer, Integer> coords = this.gridPosToArrayIndices((Tuple<Integer, Integer>)new Tuple((Object)gpX, (Object)gpZ));
        this.lastX = gpX;
        this.lastZ = gpZ;
        this.roomPattern[((Integer)coords.func_76341_a()).intValue()][((Integer)coords.func_76340_b()).intValue()] = type;
    }

    private ESkyDirection getRoomExitDirection(EStrongholdRoomType room) {
        switch (room) {
            case CURVE_EN: 
            case CURVE_WN: 
            case HALLWAY_SN: 
            case STAIR_NN: {
                return ESkyDirection.NORTH;
            }
            case CURVE_ES: 
            case CURVE_WS: 
            case HALLWAY_NS: 
            case STAIR_SS: {
                return ESkyDirection.SOUTH;
            }
            case CURVE_NE: 
            case CURVE_SE: 
            case HALLWAY_WE: 
            case STAIR_EE: {
                return ESkyDirection.EAST;
            }
            case CURVE_NW: 
            case CURVE_SW: 
            case HALLWAY_EW: 
            case STAIR_WW: {
                return ESkyDirection.WEST;
            }
        }
        return null;
    }

    @Override
    public void preProcess(World world, GeneratableDungeon.Builder dungeonBuilder, DungeonInhabitant mobType) {
    }

    @Override
    public void generate(World world, GeneratableDungeon.Builder dungeonBuilder, DungeonInhabitant mobType) {
    }

    @Override
    public void generatePost(World world, GeneratableDungeon.Builder dungeonBuilder, DungeonInhabitant mobType) {
    }
}

