/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.stronghold.spiral;

import java.io.File;
import java.util.Random;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonVolcano;
import team.cqr.cqrepoured.world.structure.generation.generation.GeneratableDungeon;
import team.cqr.cqrepoured.world.structure.generation.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.world.structure.generation.generators.stronghold.EStrongholdRoomType;
import team.cqr.cqrepoured.world.structure.generation.structurefile.CQStructure;
import team.cqr.cqrepoured.world.structure.generation.structurefile.Offset;

public class SpiralStrongholdFloor {
    private final Random random;
    private AbstractDungeonGenerator<DungeonVolcano> generator;
    private GeneratableDungeon.Builder dungeonBuilder;
    private Tuple<Integer, Integer> entranceCoordinates;
    private Tuple<Integer, Integer> entranceIndex;
    private Tuple<Integer, Integer> exitCoordinates;
    private Tuple<Integer, Integer> exitIndex;
    private boolean isLastFloor = false;
    private int sideLength;
    private int roomCount;
    private EStrongholdRoomType[][] roomGrid;
    private Tuple[][] previousCoords;
    private BlockPos[][] coordinateGrid;
    private boolean isReversed;

    public SpiralStrongholdFloor(AbstractDungeonGenerator<DungeonVolcano> generator, GeneratableDungeon.Builder dungeonBuilder, Tuple<Integer, Integer> entrancePos, int entranceX, int entranceZ, boolean isLastFloor, int sideLength, int roomCount, Random rand, boolean isReversed) {
        this.generator = generator;
        this.dungeonBuilder = dungeonBuilder;
        this.entranceCoordinates = entrancePos;
        this.entranceIndex = new Tuple((Object)entranceX, (Object)entranceZ);
        this.isLastFloor = isLastFloor;
        this.sideLength = sideLength;
        this.roomCount = roomCount;
        this.roomGrid = new EStrongholdRoomType[sideLength][sideLength];
        this.coordinateGrid = new BlockPos[sideLength][sideLength];
        this.previousCoords = new Tuple[sideLength][sideLength];
        this.random = rand;
        this.isReversed = isReversed;
    }

    public void calculateRoomGrid(EStrongholdRoomType entranceRoomType) {
        int x = (Integer)this.entranceIndex.func_76341_a();
        int z = (Integer)this.entranceIndex.func_76340_b();
        boolean isFirst = true;
        int lastX = x;
        int lastZ = z;
        while (this.roomCount > 0) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.previousCoords[x][z] = new Tuple((Object)lastX, (Object)lastZ);
            }
            lastX = x;
            lastZ = z;
            --this.roomCount;
            if (this.roomCount == 0) {
                this.exitIndex = new Tuple((Object)x, (Object)z);
                if (this.isLastFloor) {
                    this.roomGrid[x][z] = EStrongholdRoomType.BOSS;
                    break;
                }
                this.roomGrid[x][z] = this.getExitRoomType(x, z, this.isReversed);
                break;
            }
            if (x == 0 && z == 0) {
                if (this.isReversed) {
                    this.roomGrid[x][z] = EStrongholdRoomType.CURVE_SE;
                    ++x;
                    continue;
                }
                this.roomGrid[x][z] = EStrongholdRoomType.CURVE_ES;
                ++z;
                continue;
            }
            if (x == this.sideLength - 1 && z == this.sideLength - 1) {
                if (this.isReversed) {
                    this.roomGrid[x][z] = EStrongholdRoomType.CURVE_NW;
                    --x;
                    continue;
                }
                this.roomGrid[x][z] = EStrongholdRoomType.CURVE_WN;
                --z;
                continue;
            }
            if (x == 0 && z == this.sideLength - 1) {
                if (this.isReversed) {
                    this.roomGrid[x][z] = EStrongholdRoomType.CURVE_EN;
                    --z;
                    continue;
                }
                this.roomGrid[x][z] = EStrongholdRoomType.CURVE_NE;
                ++x;
                continue;
            }
            if (x == this.sideLength - 1 && z == 0) {
                if (this.isReversed) {
                    this.roomGrid[x][z] = EStrongholdRoomType.CURVE_WS;
                    ++z;
                    continue;
                }
                this.roomGrid[x][z] = EStrongholdRoomType.CURVE_SW;
                --x;
                continue;
            }
            if (x == 0) {
                if (!this.isReversed) {
                    this.roomGrid[x][z] = EStrongholdRoomType.HALLWAY_NS;
                    ++z;
                    continue;
                }
                this.roomGrid[x][z] = EStrongholdRoomType.HALLWAY_SN;
                --z;
                continue;
            }
            if (x == this.sideLength - 1) {
                if (this.isReversed) {
                    this.roomGrid[x][z] = EStrongholdRoomType.HALLWAY_NS;
                    ++z;
                    continue;
                }
                this.roomGrid[x][z] = EStrongholdRoomType.HALLWAY_SN;
                --z;
                continue;
            }
            if (z == 0) {
                if (this.isReversed) {
                    this.roomGrid[x][z] = EStrongholdRoomType.HALLWAY_WE;
                    ++x;
                    continue;
                }
                this.roomGrid[x][z] = EStrongholdRoomType.HALLWAY_EW;
                --x;
                continue;
            }
            if (z != this.sideLength - 1) continue;
            if (!this.isReversed) {
                this.roomGrid[x][z] = EStrongholdRoomType.HALLWAY_WE;
                ++x;
                continue;
            }
            this.roomGrid[x][z] = EStrongholdRoomType.HALLWAY_EW;
            --x;
        }
        this.roomGrid[((Integer)this.entranceIndex.func_76341_a()).intValue()][((Integer)this.entranceIndex.func_76340_b()).intValue()] = entranceRoomType;
    }

    private EStrongholdRoomType getExitRoomType(int iX, int iZ, boolean rev) {
        if (iX == 0 && iZ == 0) {
            return rev ? EStrongholdRoomType.STAIR_SS : EStrongholdRoomType.STAIR_EE;
        }
        if (iX == 0 && iZ == this.sideLength - 1) {
            return rev ? EStrongholdRoomType.STAIR_EE : EStrongholdRoomType.STAIR_NN;
        }
        if (iX == this.sideLength - 1 && iZ == 0) {
            return rev ? EStrongholdRoomType.STAIR_WW : EStrongholdRoomType.STAIR_SS;
        }
        if (iX == this.sideLength - 1 && iZ == this.sideLength - 1) {
            return rev ? EStrongholdRoomType.STAIR_NN : EStrongholdRoomType.STAIR_WW;
        }
        if (iZ == 0) {
            return rev ? EStrongholdRoomType.STAIR_WW : EStrongholdRoomType.STAIR_EE;
        }
        if (iZ == this.sideLength - 1) {
            return rev ? EStrongholdRoomType.STAIR_EE : EStrongholdRoomType.STAIR_WW;
        }
        if (iX == 0) {
            return rev ? EStrongholdRoomType.STAIR_SS : EStrongholdRoomType.STAIR_NN;
        }
        if (iX == this.sideLength - 1) {
            return rev ? EStrongholdRoomType.STAIR_NN : EStrongholdRoomType.STAIR_SS;
        }
        return EStrongholdRoomType.NONE;
    }

    public void calculateCoordinates(int y, int roomSizeX, int roomSizeZ) {
        BlockPos entrancePos;
        this.coordinateGrid[((Integer)this.entranceIndex.func_76341_a()).intValue()][((Integer)this.entranceIndex.func_76340_b()).intValue()] = entrancePos = new BlockPos(((Integer)this.entranceCoordinates.func_76341_a()).intValue(), y, ((Integer)this.entranceCoordinates.func_76340_b()).intValue());
        for (int iX = 0; iX < this.sideLength; ++iX) {
            for (int iZ = 0; iZ < this.sideLength; ++iZ) {
                EStrongholdRoomType room;
                if (iX != 0 && iX != this.sideLength - 1 && iZ != 0 && iZ != this.sideLength - 1 || (room = this.roomGrid[iX][iZ]) == null || room == EStrongholdRoomType.NONE) continue;
                int x = (iX - (Integer)this.entranceIndex.func_76341_a()) * roomSizeX;
                int z = (iZ - (Integer)this.entranceIndex.func_76340_b()) * roomSizeZ;
                this.coordinateGrid[iX][iZ] = new BlockPos(x += entrancePos.func_177958_n(), y, z += entrancePos.func_177952_p());
            }
        }
        this.coordinateGrid[((Integer)this.entranceIndex.func_76341_a()).intValue()][((Integer)this.entranceIndex.func_76340_b()).intValue()] = entrancePos;
        if (!this.isLastFloor) {
            int x = ((Integer)this.exitIndex.func_76341_a() - (Integer)this.entranceIndex.func_76341_a()) * roomSizeX;
            int z = ((Integer)this.exitIndex.func_76340_b() - (Integer)this.entranceIndex.func_76340_b()) * roomSizeZ;
            this.coordinateGrid[((Integer)this.exitIndex.func_76341_a()).intValue()][((Integer)this.exitIndex.func_76340_b()).intValue()] = new BlockPos(x += entrancePos.func_177958_n(), y, z += entrancePos.func_177952_p());
            this.exitCoordinates = new Tuple((Object)x, (Object)z);
        }
    }

    public Tuple<Integer, Integer> getExitCoordinates() {
        return this.exitCoordinates;
    }

    public Tuple<Integer, Integer> getExitIndex() {
        return this.exitIndex;
    }

    public void overrideFirstRoomType(EStrongholdRoomType type) {
        this.roomGrid[((Integer)this.entranceIndex.func_76341_a()).intValue()][((Integer)this.entranceIndex.func_76340_b()).intValue()] = type;
    }

    public void overrideLastRoomType(EStrongholdRoomType type) {
        if (!this.isLastFloor) {
            this.roomGrid[((Integer)this.exitIndex.func_76341_a()).intValue()][((Integer)this.exitIndex.func_76340_b()).intValue()] = type;
        }
    }

    public EStrongholdRoomType[][] getRoomGrid() {
        return this.roomGrid;
    }

    public void buildRooms(DungeonVolcano dungeon, World world) {
        File[][] fileMap = new File[this.sideLength][this.sideLength];
        for (int iX = 0; iX < this.sideLength; ++iX) {
            for (int iZ = 0; iZ < this.sideLength; ++iZ) {
                File file;
                EStrongholdRoomType type;
                if (iX != 0 && iX != this.sideLength - 1 && iZ != 0 && iZ != this.sideLength - 1 || (type = this.roomGrid[iX][iZ]) == null || type == EStrongholdRoomType.NONE || dungeon == null || world == null) continue;
                Tuple prevCoords = this.previousCoords[iX][iZ];
                File previous = null;
                EStrongholdRoomType prevType = EStrongholdRoomType.NONE;
                if (prevCoords != null) {
                    previous = fileMap[(Integer)prevCoords.func_76341_a()][(Integer)prevCoords.func_76340_b()];
                    prevType = this.roomGrid[(Integer)prevCoords.func_76341_a()][(Integer)prevCoords.func_76340_b()];
                }
                if ((file = dungeon.getRoomNBTFileForType(type, this.random)).equals(previous) && dungeon.getRoomNBTCountForType(prevType) > 1) {
                    for (int counter = 0; file.equals(previous) && counter < 8; ++counter) {
                        file = dungeon.getRoomNBTFileForType(type, this.random);
                    }
                }
                fileMap[iX][iZ] = file;
                if (file == null) continue;
                CQStructure room = this.generator.loadStructureFromFile(file);
                room.addAll(this.dungeonBuilder, this.coordinateGrid[iX][iZ], Offset.CENTER);
            }
        }
    }

    public EStrongholdRoomType getExitRoomType() {
        return this.roomGrid[(Integer)this.exitIndex.func_76341_a()][(Integer)this.exitIndex.func_76340_b()];
    }
}

