/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.volcano;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;

public class StairCaseHelper {
    public static EStairSection getRandomStartSection() {
        switch (new Random().nextInt(4)) {
            case 0: {
                return EStairSection.NORTH_EAST;
            }
            case 1: {
                return EStairSection.SOUTH_EAST;
            }
            case 2: {
                return EStairSection.NORTH_WEST;
            }
            case 3: {
                return EStairSection.SOUTH_WEST;
            }
        }
        return EStairSection.SOUTH_WEST;
    }

    public static boolean isPillarCenterLocation(int x, int z, int radiusOfCircle) {
        if (x == 0 && Math.abs(z) == Math.abs(radiusOfCircle / 2)) {
            return true;
        }
        return z == 0 && Math.abs(x) == Math.abs(radiusOfCircle / 2);
    }

    public static EnumFacing getFacingWithRotation(EnumFacing orig, Rotation rotation) {
        EnumFacing ret = orig;
        block0 : switch (orig) {
            case EAST: {
                switch (rotation) {
                    case CLOCKWISE_180: {
                        ret = EnumFacing.WEST;
                        break block0;
                    }
                    case CLOCKWISE_90: {
                        ret = EnumFacing.SOUTH;
                        break block0;
                    }
                    case COUNTERCLOCKWISE_90: {
                        ret = EnumFacing.NORTH;
                        break block0;
                    }
                }
                break;
            }
            case NORTH: {
                switch (rotation) {
                    case CLOCKWISE_180: {
                        ret = EnumFacing.SOUTH;
                        break block0;
                    }
                    case CLOCKWISE_90: {
                        ret = EnumFacing.EAST;
                        break block0;
                    }
                    case COUNTERCLOCKWISE_90: {
                        ret = EnumFacing.WEST;
                        break block0;
                    }
                }
                break;
            }
            case SOUTH: {
                switch (rotation) {
                    case CLOCKWISE_180: {
                        ret = EnumFacing.NORTH;
                        break block0;
                    }
                    case CLOCKWISE_90: {
                        ret = EnumFacing.WEST;
                        break block0;
                    }
                    case COUNTERCLOCKWISE_90: {
                        ret = EnumFacing.EAST;
                        break block0;
                    }
                }
                break;
            }
            case WEST: {
                switch (rotation) {
                    case CLOCKWISE_180: {
                        ret = EnumFacing.EAST;
                        break block0;
                    }
                    case CLOCKWISE_90: {
                        ret = EnumFacing.NORTH;
                        break block0;
                    }
                    case COUNTERCLOCKWISE_90: {
                        ret = EnumFacing.SOUTH;
                        break block0;
                    }
                }
                break;
            }
        }
        return ret;
    }

    public static boolean isLocationFine(EStairSection section, int x, int z, int radiusOfCircle) {
        switch (section) {
            case NORTH: {
                if (z >= 0 || 0 > x || x > radiusOfCircle / 3) break;
                return true;
            }
            case NORTH_SEC: {
                if (z >= 0 || -(radiusOfCircle / 3) > x || x > 0) break;
                return true;
            }
            case SOUTH: {
                if (z <= 0 || -(radiusOfCircle / 3) > x || x > 0) break;
                return true;
            }
            case SOUTH_SEC: {
                if (z <= 0 || 0 > x || x > radiusOfCircle / 3) break;
                return true;
            }
            case EAST: {
                if (x <= 0 || 0 > z || z > radiusOfCircle / 3) break;
                return true;
            }
            case EAST_SEC: {
                if (x <= 0 || -(radiusOfCircle / 3) > z || z > 0) break;
                return true;
            }
            case WEST: {
                if (x >= 0 || -(radiusOfCircle / 3) > z || z > 0) break;
                return true;
            }
            case WEST_SEC: {
                if (x >= 0 || 0 > z || z > radiusOfCircle / 3) break;
                return true;
            }
            case SOUTH_EAST: {
                if (x <= 0 || z <= 0 || x < radiusOfCircle / 3 || z < radiusOfCircle / 3) break;
                return true;
            }
            case SOUTH_WEST: {
                if (x >= 0 || z <= 0 || x > -(radiusOfCircle / 3) || z < radiusOfCircle / 3) break;
                return true;
            }
            case NORTH_EAST: {
                if (x <= 0 || z >= 0 || x < radiusOfCircle / 3 || z > -(radiusOfCircle / 3)) break;
                return true;
            }
            case NORTH_WEST: {
                if (x >= 0 || z >= 0 || x > -(radiusOfCircle / 3) || z > -(radiusOfCircle / 3)) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public static enum EStairSection {
        NORTH("NORTH_EAST"),
        NORTH_EAST("EAST_SEC"),
        EAST_SEC("EAST"),
        EAST("SOUTH_EAST"),
        SOUTH_EAST("SOUTH_SEC"),
        SOUTH_SEC("SOUTH"),
        SOUTH("SOUTH_WEST"),
        SOUTH_WEST("WEST_SEC"),
        WEST_SEC("WEST"),
        WEST("NORTH_WEST"),
        NORTH_WEST("NORTH_SEC"),
        NORTH_SEC("NORTH");

        private String successorName;

        private EStairSection(String successor) {
            this.successorName = successor;
        }

        public EStairSection getSuccessor() {
            return EStairSection.valueOf(this.successorName);
        }

        @Nullable
        public EStairSection getPredeccessor() {
            for (EStairSection section : EStairSection.values()) {
                if (!section.successorName.equalsIgnoreCase(this.name())) continue;
                return section;
            }
            return null;
        }

        public EnumFacing getAsSkyDirection() {
            switch (this) {
                case EAST: 
                case EAST_SEC: {
                    return EnumFacing.EAST;
                }
                case NORTH: 
                case NORTH_SEC: {
                    return EnumFacing.NORTH;
                }
                case SOUTH: 
                case SOUTH_SEC: {
                    return EnumFacing.SOUTH;
                }
                case WEST: 
                case WEST_SEC: {
                    return EnumFacing.WEST;
                }
            }
            return this.getPredeccessor().getAsSkyDirection();
        }
    }
}

