/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.lootchests;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import meldexun.reflectionutil.ReflectionConstructor;
import meldexun.reflectionutil.ReflectionField;
import net.minecraft.item.Item;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.LootTableLoadEvent;
import org.apache.commons.io.FileUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.init.CQRLoottables;

public class LootTableLoader {
    private static final ReflectionField<List<JsonElement>> JsonArray_elements = new ReflectionField(JsonArray.class, "elements", null);
    private static final ThreadLocal<Deque<?>> lootContext = (ThreadLocal)new ReflectionField(ForgeHooks.class, "lootContext", null).get(null);
    private static final ReflectionConstructor<?> LootTableContext = new ReflectionConstructor("net.minecraftforge.common.ForgeHooks$LootTableContext", ResourceLocation.class, Boolean.TYPE);

    public static void loadLootTableFromConfig(LootTableLoadEvent event) {
        if (Files.exists(LootTableLoader.jsonFile(event.getName()), new LinkOption[0])) {
            LootTableLoader.loadJsonLootTable(event);
        } else if (Files.exists(LootTableLoader.propertiesFile(event.getName()), new LinkOption[0])) {
            LootTableLoader.loadPropertiesLootTable(event);
        }
    }

    private static Path jsonFile(ResourceLocation name) {
        return new File(CQRMain.CQ_CHEST_FOLDER, name.func_110623_a() + ".json").toPath();
    }

    private static Path propertiesFile(ResourceLocation name) {
        return new File(CQRMain.CQ_CHEST_FOLDER, name.func_110623_a() + ".properties").toPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadJsonLootTable(LootTableLoadEvent event) {
        Path jsonFile = LootTableLoader.jsonFile(event.getName());
        try {
            Deque<?> que;
            JsonObject json;
            try (BufferedReader reader = Files.newBufferedReader(jsonFile);){
                json = (JsonObject)LootTableManager.field_186526_b.fromJson((Reader)reader, JsonObject.class);
            }
            if (json.has("pools")) {
                JsonArray_elements.get(json.get("pools")).removeIf(pool -> {
                    if (!pool.getAsJsonObject().has("entries")) {
                        return true;
                    }
                    JsonArray entries = pool.getAsJsonObject().getAsJsonArray("entries");
                    JsonArray_elements.get(entries).removeIf(entry -> entry.getAsJsonObject().get("type").getAsString().equals("item") && Item.func_111206_d((String)entry.getAsJsonObject().get("name").getAsString()) == null);
                    return entries.size() == 0;
                });
            }
            if ((que = lootContext.get()) == null) {
                que = new ArrayDeque();
                lootContext.set(que);
            }
            que.push(LootTableContext.newInstance(event.getName(), true));
            try {
                event.setTable((LootTable)LootTableManager.field_186526_b.fromJson((JsonElement)json, LootTable.class));
            }
            finally {
                que.pop();
            }
        }
        catch (JsonParseException | IOException e) {
            CQRMain.logger.error("Failed to read json loot table {}", (Object)Launch.minecraftHome.toPath().relativize(jsonFile), (Object)e);
        }
    }

    private static void loadPropertiesLootTable(LootTableLoadEvent event) {
        Path propertiesFile = LootTableLoader.propertiesFile(event.getName());
        try {
            LootPool[] pools = CQRConfig.general.singleLootPoolPerLootTable ? new LootPool[]{new LootPool((LootEntry[])LootTableLoader.parseLootEntries(propertiesFile).toArray(LootEntry[]::new), new LootCondition[0], new RandomValueRange((float)CQRConfig.general.minItemsPerLootChest, (float)CQRConfig.general.maxItemsPerLootChest), new RandomValueRange(0.0f), event.getName().func_110623_a())} : (LootPool[])LootTableLoader.parseLootEntries(propertiesFile).map(entry -> new LootPool(new LootEntry[]{entry}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f), entry.getEntryName())).toArray(LootPool[]::new);
            event.setTable(new LootTable(pools));
        }
        catch (IOException e) {
            CQRMain.logger.error("Failed to read prop loot table {}", (Object)Launch.minecraftHome.toPath().relativize(propertiesFile), (Object)e);
        }
    }

    private static Stream<LootEntry> parseLootEntries(Path file) throws IOException {
        return Files.lines(file).map(LootTableLoader::parseLootEntry).filter(Objects::nonNull);
    }

    private static LootEntry parseLootEntry(String s) {
        if (s.startsWith("#")) {
            return null;
        }
        int i = s.indexOf(61);
        if (i < 0) {
            return null;
        }
        String name = s.substring(0, i).trim();
        StringTokenizer tokenizer = new StringTokenizer(s.substring(i + 1), ",");
        Item item = Item.func_111206_d((String)tokenizer.nextToken().trim());
        if (item == null) {
            return null;
        }
        int meta = LootTableLoader.parseInt(tokenizer, 0);
        int countMin = LootTableLoader.parseInt(tokenizer, 1);
        int countMax = LootTableLoader.parseInt(tokenizer, 1);
        int weight = LootTableLoader.parseInt(tokenizer, 100);
        boolean enchant = LootTableLoader.parseBoolean(tokenizer, false);
        int enchantMin = LootTableLoader.parseInt(tokenizer, 1);
        int enchantMax = LootTableLoader.parseInt(tokenizer, 30);
        boolean enchantTreasure = LootTableLoader.parseBoolean(tokenizer, false);
        int enchantChance = LootTableLoader.parseInt(tokenizer, 100);
        ArrayList<Object> functionsBuilder = new ArrayList<Object>();
        if (countMin != 1 || countMax != 1) {
            functionsBuilder.add(new SetCount(new LootCondition[0], new RandomValueRange((float)countMin, (float)countMax)));
        }
        if (enchant && enchantChance > 0) {
            LootCondition[] lootConditionArray;
            if (enchantChance < 100) {
                LootCondition[] lootConditionArray2 = new LootCondition[1];
                lootConditionArray = lootConditionArray2;
                lootConditionArray2[0] = new RandomChance((float)enchantChance / 100.0f);
            } else {
                lootConditionArray = new LootCondition[]{};
            }
            functionsBuilder.add(new EnchantWithLevels(lootConditionArray, new RandomValueRange((float)enchantMin, (float)enchantMax), enchantTreasure));
        }
        if (meta != 0) {
            functionsBuilder.add(new SetMetadata(new LootCondition[0], new RandomValueRange((float)meta)));
        }
        LootFunction[] functions = functionsBuilder.toArray(new LootFunction[functionsBuilder.size()]);
        return new LootEntryItem(item, weight, 0, functions, new LootCondition[0], name);
    }

    private static boolean parseBoolean(StringTokenizer tokenizer, boolean defaultValue) {
        return tokenizer.hasMoreTokens() ? Boolean.parseBoolean(tokenizer.nextToken().trim()) : defaultValue;
    }

    private static int parseInt(StringTokenizer tokenizer, int defaultValue) {
        if (!tokenizer.hasMoreTokens()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(tokenizer.nextToken().trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static void registerCustomLootTables(WorldServer worldServer) {
        Collection files = FileUtils.listFiles((File)new File(CQRMain.CQ_CHEST_FOLDER, "chests"), (String[])new String[]{"json", "properties"}, (boolean)false);
        Set<ResourceLocation> cqrChestLootTables = CQRLoottables.getChestLootTables();
        LootTableManager lootTableManager = worldServer.func_184146_ak();
        for (File file : files) {
            String s = file.getName();
            ResourceLocation name = new ResourceLocation("cqrepoured", "chests/" + s.substring(0, s.lastIndexOf(46)));
            if (cqrChestLootTables.contains(name)) continue;
            LootTable table = new LootTable(new LootPool[0]);
            table = ForgeEventFactory.loadLootTable((ResourceLocation)name, (LootTable)table, (LootTableManager)lootTableManager);
            lootTableManager.field_186527_c.put((Object)name, (Object)table);
        }
    }
}

