/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.thewall;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.biome.BiomeSnow;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.world.structure.generation.DungeonDataManager;
import team.cqr.cqrepoured.world.structure.generation.generation.DungeonGenerationManager;
import team.cqr.cqrepoured.world.structure.generation.generation.GeneratableDungeon;
import team.cqr.cqrepoured.world.structure.generation.generation.SpawnpointGenerationHandler;
import team.cqr.cqrepoured.world.structure.generation.thewall.wallparts.IWallPart;
import team.cqr.cqrepoured.world.structure.generation.thewall.wallparts.WallPartRailingTower;
import team.cqr.cqrepoured.world.structure.generation.thewall.wallparts.WallPartRailingWall;
import team.cqr.cqrepoured.world.structure.generation.thewall.wallparts.WallPartTower;
import team.cqr.cqrepoured.world.structure.generation.thewall.wallparts.WallPartWall;

public class WorldWallGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (((SpawnpointGenerationHandler)world).isDungeonGenerationDelayed(chunkX, chunkZ)) {
            return;
        }
        if (!CQRConfig.wall.enabled || world.field_72995_K || world.field_73011_w.getDimension() != 0) {
            return;
        }
        if (this.isWallRegion(chunkX, chunkZ, world)) {
            // empty if block
        }
        if (chunkZ < 0 && Math.abs(chunkZ) == Math.abs(CQRConfig.wall.distance)) {
            BlockPos pos = new BlockPos((chunkX << 4) + 8, world.func_181545_F(), (chunkZ << 4) + 8);
            GeneratableDungeon.Builder dungeonBuilder = new GeneratableDungeon.Builder(world, pos, "Wall in the North", CQRConfig.wall.mob);
            Biome biome = world.func_72959_q().func_180631_a(pos);
            if (biome instanceof BiomePlains || biome instanceof BiomeSnow) {
                // empty if block
            }
            IWallPart wallPart = null;
            IWallPart railingPart = null;
            if (chunkX % CQRConfig.wall.towerDistance == 0) {
                wallPart = new WallPartTower();
                railingPart = new WallPartRailingTower();
            } else {
                wallPart = new WallPartWall();
                railingPart = new WallPartRailingWall();
            }
            wallPart.generateWall(chunkX, chunkZ, world, world.func_72964_e(chunkX, chunkZ), dungeonBuilder);
            railingPart.generateWall(chunkX, chunkZ, world, world.func_72964_e(chunkX, chunkZ), dungeonBuilder);
            DungeonGenerationManager.generate(world, dungeonBuilder, null, DungeonDataManager.DungeonSpawnType.DUNGEON_GENERATION);
        }
    }

    private boolean isWallRegion(int chunkX, int chunkZ, World world) {
        if (!CQRConfig.wall.enabled) {
            return false;
        }
        if (world.field_73011_w.getDimension() != 0) {
            return false;
        }
        if (chunkZ >= 0) {
            return false;
        }
        if (Math.abs(chunkZ) < Math.abs(CQRConfig.wall.distance - 8)) {
            return false;
        }
        return Math.abs(chunkZ) <= Math.abs(CQRConfig.wall.distance + 8);
    }
}

