/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.protection;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.util.ByteBufUtil;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.NBTCollectors;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonBase;
import team.cqr.cqrepoured.world.structure.protection.IProtectedRegionManager;
import team.cqr.cqrepoured.world.structure.protection.ProtectedRegionManager;

public class ProtectedRegion {
    public static final String PROTECTED_REGION_VERSION = "1.2.0";
    public static boolean logVersionWarnings = true;
    private final World world;
    private UUID uuid = MathHelper.func_188210_a();
    private String name;
    private BlockPos pos;
    private BlockPos startPos;
    private BlockPos endPos;
    private BlockPos size;
    private byte[] protectionStates;
    private boolean preventBlockBreaking = false;
    private boolean preventBlockPlacing = false;
    private boolean preventExplosionsTNT = false;
    private boolean preventExplosionsOther = false;
    private boolean preventFireSpreading = false;
    private boolean preventEntitySpawning = false;
    private boolean ignoreNoBossOrNexus = false;
    private boolean isGenerating = true;
    private final Set<UUID> entityDependencies = new HashSet<UUID>();
    private final Set<BlockPos> blockDependencies = new HashSet<BlockPos>();
    private boolean needsSaving = false;
    private boolean needsSyncing = false;

    public ProtectedRegion(World world, String dungeonName, BlockPos pos, BlockPos startPos, BlockPos endPos) {
        this.world = world;
        this.name = dungeonName;
        this.pos = pos.func_185334_h();
        this.startPos = DungeonGenUtils.getValidMinPos(startPos, endPos);
        this.endPos = DungeonGenUtils.getValidMaxPos(startPos, endPos);
        int sizeX = this.endPos.func_177958_n() - this.startPos.func_177958_n() + 1;
        int sizeY = this.endPos.func_177956_o() - this.startPos.func_177956_o() + 1;
        int sizeZ = this.endPos.func_177952_p() - this.startPos.func_177952_p() + 1;
        this.size = new BlockPos(sizeX, sizeY, sizeZ);
        this.protectionStates = new byte[sizeX * sizeY * sizeZ];
    }

    public ProtectedRegion(World world, NBTTagCompound compound) {
        this.world = world;
        this.readFromNBT(compound);
        this.clearNeedsSaving();
        this.clearNeedsSyncing();
    }

    public ProtectedRegion(World world, ByteBuf buf) {
        this.world = world;
        this.readFromByteBuf(buf);
        this.clearNeedsSaving();
        this.clearNeedsSyncing();
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return tag;
    }

    public void markDirty() {
        this.needsSaving = true;
        this.needsSyncing = true;
    }

    public void clearNeedsSaving() {
        this.needsSaving = false;
    }

    public void clearNeedsSyncing() {
        this.needsSyncing = false;
    }

    public boolean needsSaving() {
        return this.needsSaving;
    }

    public boolean needsSyncing() {
        return this.needsSyncing;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("version", PROTECTED_REGION_VERSION);
        compound.func_74782_a("uuid", (NBTBase)NBTUtil.func_186862_a((UUID)this.uuid));
        compound.func_74778_a("name", this.name);
        compound.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.pos));
        compound.func_74782_a("startPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.startPos));
        compound.func_74782_a("endPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.endPos));
        compound.func_74773_a("protectionStates", this.protectionStates);
        compound.func_74757_a("preventBlockBreaking", this.preventBlockBreaking);
        compound.func_74757_a("preventBlockPlacing", this.preventBlockPlacing);
        compound.func_74757_a("preventExplosionsTNT", this.preventExplosionsTNT);
        compound.func_74757_a("preventExplosionsOther", this.preventExplosionsOther);
        compound.func_74757_a("preventFireSpreading", this.preventFireSpreading);
        compound.func_74757_a("preventEntitySpawning", this.preventEntitySpawning);
        compound.func_74757_a("ignoreNoBossOrNexus", this.ignoreNoBossOrNexus);
        compound.func_74757_a("isGenerating", this.isGenerating);
        NBTTagList nbtTagList1 = new NBTTagList();
        for (UUID entityUuid : this.entityDependencies) {
            nbtTagList1.func_74742_a((NBTBase)NBTUtil.func_186862_a((UUID)entityUuid));
        }
        compound.func_74782_a("entityDependencies", (NBTBase)nbtTagList1);
        NBTTagList nbtTagList2 = new NBTTagList();
        for (BlockPos blockPos : this.blockDependencies) {
            nbtTagList2.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)blockPos));
        }
        compound.func_74782_a("blockDependencies", (NBTBase)nbtTagList2);
    }

    public void readFromNBT(NBTTagCompound compound) {
        String version = compound.func_74779_i("version");
        if (logVersionWarnings && !version.equals(PROTECTED_REGION_VERSION)) {
            CQRMain.logger.warn("Warning! Trying to create protected region from file which was created with an older/newer version of CQR! Expected {} but got {}.", (Object)PROTECTED_REGION_VERSION, (Object)version);
        }
        this.uuid = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("uuid"));
        this.name = compound.func_74779_i("name");
        this.pos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("pos"));
        this.startPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("startPos"));
        this.endPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("endPos"));
        int sizeX = this.endPos.func_177958_n() - this.startPos.func_177958_n() + 1;
        int sizeY = this.endPos.func_177956_o() - this.startPos.func_177956_o() + 1;
        int sizeZ = this.endPos.func_177952_p() - this.startPos.func_177952_p() + 1;
        this.size = new BlockPos(sizeX, sizeY, sizeZ);
        this.protectionStates = compound.func_150297_b("protectionStates", 7) ? compound.func_74770_j("protectionStates") : new byte[sizeX * sizeY * sizeZ];
        this.preventBlockBreaking = compound.func_74767_n("preventBlockBreaking");
        this.preventBlockPlacing = compound.func_74767_n("preventBlockPlacing");
        this.preventExplosionsTNT = compound.func_74767_n("preventExplosionsTNT");
        this.preventExplosionsOther = compound.func_74767_n("preventExplosionsOther");
        this.preventFireSpreading = compound.func_74767_n("preventFireSpreading");
        this.preventEntitySpawning = compound.func_74767_n("preventEntitySpawning");
        this.ignoreNoBossOrNexus = compound.func_74767_n("ignoreNoBossOrNexus");
        this.isGenerating = compound.func_74767_n("isGenerating");
        this.entityDependencies.clear();
        NBTTagList nbtTagList1 = compound.func_150295_c("entityDependencies", 10);
        for (int i = 0; i < nbtTagList1.func_74745_c(); ++i) {
            this.entityDependencies.add(NBTUtil.func_186860_b((NBTTagCompound)nbtTagList1.func_150305_b(i)));
        }
        this.blockDependencies.clear();
        NBTTagList nbtTagList2 = compound.func_150295_c("blockDependencies", 10);
        for (int i = 0; i < nbtTagList2.func_74745_c(); ++i) {
            this.blockDependencies.add(NBTUtil.func_186861_c((NBTTagCompound)nbtTagList2.func_150305_b(i)));
        }
        this.markDirty();
    }

    public void writeToByteBuf(ByteBuf buf) {
        ByteBufUtil.writeUuid(buf, this.uuid);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtil.writeBlockPos(buf, this.pos);
        ByteBufUtil.writeBlockPos(buf, this.startPos);
        ByteBufUtil.writeBlockPos(buf, this.endPos);
        buf.writeBytes(this.protectionStates);
        byte flags = 0;
        flags = (byte)(flags | (this.preventBlockBreaking ? 1 : 0));
        flags = (byte)(flags | (this.preventBlockPlacing ? 2 : 0));
        flags = (byte)(flags | (this.preventExplosionsTNT ? 4 : 0));
        flags = (byte)(flags | (this.preventExplosionsOther ? 8 : 0));
        flags = (byte)(flags | (this.preventFireSpreading ? 16 : 0));
        flags = (byte)(flags | (this.preventEntitySpawning ? 32 : 0));
        flags = (byte)(flags | (this.ignoreNoBossOrNexus ? 64 : 0));
        flags = (byte)(flags | (this.isGenerating ? 128 : 0));
        buf.writeByte((int)flags);
        buf.writeShort(this.entityDependencies.size());
        for (UUID entityUuid : this.entityDependencies) {
            ByteBufUtil.writeUuid(buf, entityUuid);
        }
        buf.writeShort(this.blockDependencies.size());
        for (BlockPos blockPos : this.blockDependencies) {
            ByteBufUtil.writeBlockPos(buf, blockPos);
        }
    }

    public void readFromByteBuf(ByteBuf buf) {
        this.uuid = ByteBufUtil.readUuid(buf);
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = ByteBufUtil.readBlockPos(buf);
        this.startPos = ByteBufUtil.readBlockPos(buf);
        this.endPos = ByteBufUtil.readBlockPos(buf);
        int sizeX = this.endPos.func_177958_n() - this.startPos.func_177958_n() + 1;
        int sizeY = this.endPos.func_177956_o() - this.startPos.func_177956_o() + 1;
        int sizeZ = this.endPos.func_177952_p() - this.startPos.func_177952_p() + 1;
        this.size = new BlockPos(sizeX, sizeY, sizeZ);
        this.protectionStates = new byte[sizeX * sizeY * sizeZ];
        buf.readBytes(this.protectionStates);
        byte flags = buf.readByte();
        this.preventBlockBreaking = (flags & 1) == 1;
        this.preventBlockPlacing = (flags >> 1 & 1) == 1;
        this.preventExplosionsTNT = (flags >> 2 & 1) == 1;
        this.preventExplosionsOther = (flags >> 3 & 1) == 1;
        this.preventFireSpreading = (flags >> 4 & 1) == 1;
        this.preventEntitySpawning = (flags >> 5 & 1) == 1;
        this.ignoreNoBossOrNexus = (flags >> 6 & 1) == 1;
        this.isGenerating = (flags >> 7 & 1) == 1;
        int entityDependenciesCount = buf.readShort();
        for (int i = 0; i < entityDependenciesCount; ++i) {
            this.entityDependencies.add(ByteBufUtil.readUuid(buf));
        }
        int blockDependenciesCount = buf.readShort();
        for (int i = 0; i < blockDependenciesCount; ++i) {
            this.blockDependencies.add(ByteBufUtil.readBlockPos(buf));
        }
        this.markDirty();
    }

    public boolean isInsideProtectedRegion(BlockPos pos) {
        if (pos.func_177958_n() < this.startPos.func_177958_n()) {
            return false;
        }
        if (pos.func_177956_o() < this.startPos.func_177956_o()) {
            return false;
        }
        if (pos.func_177952_p() < this.startPos.func_177952_p()) {
            return false;
        }
        if (pos.func_177958_n() > this.endPos.func_177958_n()) {
            return false;
        }
        if (pos.func_177956_o() > this.endPos.func_177956_o()) {
            return false;
        }
        return pos.func_177952_p() <= this.endPos.func_177952_p();
    }

    public boolean isBreakable(BlockPos pos) {
        int z;
        int y;
        if (!this.isInsideProtectedRegion(pos)) {
            return true;
        }
        int x = (pos.func_177958_n() - this.startPos.func_177958_n()) * this.size.func_177956_o() * this.size.func_177952_p();
        return this.protectionStates[x + (y = (pos.func_177956_o() - this.startPos.func_177956_o()) * this.size.func_177952_p()) + (z = pos.func_177952_p() - this.startPos.func_177952_p())] != 0;
    }

    public int getProtectionState(BlockPos pos) {
        if (!this.isInsideProtectedRegion(pos)) {
            return -1;
        }
        int x = (pos.func_177958_n() - this.startPos.func_177958_n()) * this.size.func_177956_o() * this.size.func_177952_p();
        int y = (pos.func_177956_o() - this.startPos.func_177956_o()) * this.size.func_177952_p();
        int z = pos.func_177952_p() - this.startPos.func_177952_p();
        return this.protectionStates[x + y + z];
    }

    public void setProtectionState(BlockPos pos, int i) {
        byte newState;
        int z;
        int y;
        if (!this.isInsideProtectedRegion(pos)) {
            return;
        }
        int x = (pos.func_177958_n() - this.startPos.func_177958_n()) * this.size.func_177956_o() * this.size.func_177952_p();
        if (this.protectionStates[x + (y = (pos.func_177956_o() - this.startPos.func_177956_o()) * this.size.func_177952_p()) + (z = pos.func_177952_p() - this.startPos.func_177952_p())] != (newState = (byte)(i & 0xFF))) {
            this.protectionStates[x + y + z] = newState;
            this.markDirty();
        }
    }

    public byte[] getProtectionStates() {
        return this.protectionStates;
    }

    public boolean isValid() {
        return this.isGenerating || !this.entityDependencies.isEmpty() || !this.blockDependencies.isEmpty() || this.ignoreNoBossOrNexus;
    }

    public void setup(boolean preventBlockBreaking, boolean preventBlockPlacing, boolean preventExplosionsTNT, boolean preventExplosionsOther, boolean preventFireSpreading, boolean preventEntitySpawning, boolean ignoreNoBossOrNexus) {
        if (!this.isGenerating) {
            return;
        }
        this.preventBlockBreaking = preventBlockBreaking;
        this.preventBlockPlacing = preventBlockPlacing;
        this.preventExplosionsTNT = preventExplosionsTNT;
        this.preventExplosionsOther = preventExplosionsOther;
        this.preventFireSpreading = preventFireSpreading;
        this.preventEntitySpawning = preventEntitySpawning;
        this.ignoreNoBossOrNexus = ignoreNoBossOrNexus;
        this.markDirty();
    }

    public World getWorld() {
        return this.world;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockPos getStartPos() {
        return this.startPos;
    }

    public BlockPos getEndPos() {
        return this.endPos;
    }

    public boolean preventBlockBreaking() {
        return this.preventBlockBreaking;
    }

    public boolean preventBlockPlacing() {
        return this.preventBlockPlacing;
    }

    public boolean preventExplosionsTNT() {
        return this.preventExplosionsTNT;
    }

    public boolean preventExplosionsOther() {
        return this.preventExplosionsOther;
    }

    public boolean preventFireSpreading() {
        return this.preventFireSpreading;
    }

    public boolean preventEntitySpawning() {
        return this.preventEntitySpawning;
    }

    public boolean ignoreNoBossOrNexus() {
        return this.ignoreNoBossOrNexus;
    }

    public void addEntityDependency(UUID uuid) {
        if (!this.isGenerating) {
            return;
        }
        if (this.entityDependencies.add(uuid)) {
            this.markDirty();
        }
    }

    public void removeEntityDependency(UUID uuid) {
        boolean flag = this.entityDependencies.remove(uuid);
        if (flag && this.world != null && !this.world.field_72995_K) {
            IProtectedRegionManager protectedRegionManager;
            this.markDirty();
            if (!this.isValid() && (protectedRegionManager = ProtectedRegionManager.getInstance(this.world)) != null) {
                protectedRegionManager.removeProtectedRegion(this);
            }
        }
    }

    public boolean isEntityDependency(UUID uuid) {
        return this.entityDependencies.contains(uuid);
    }

    public Set<UUID> getEntityDependencies() {
        return Collections.unmodifiableSet(this.entityDependencies);
    }

    public void addBlockDependency(BlockPos pos) {
        if (!this.isGenerating) {
            return;
        }
        if (this.blockDependencies.add(pos.func_185334_h())) {
            this.markDirty();
        }
    }

    public void removeBlockDependency(BlockPos pos) {
        if (this.blockDependencies.remove(pos)) {
            IProtectedRegionManager protectedRegionManager;
            this.markDirty();
            if (!this.isValid() && (protectedRegionManager = ProtectedRegionManager.getInstance(this.world)) != null) {
                protectedRegionManager.removeProtectedRegion(this);
            }
        }
    }

    public boolean isBlockDependency(BlockPos pos) {
        return this.blockDependencies.contains(pos);
    }

    public Set<BlockPos> getBlockDependencies() {
        return Collections.unmodifiableSet(this.blockDependencies);
    }

    public void finishGenerating() {
        if (!this.isGenerating) {
            return;
        }
        this.isGenerating = false;
        this.markDirty();
    }

    public boolean isGenerating() {
        return this.isGenerating;
    }

    public static class Builder {
        private final String dungeonName;
        private final BlockPos dungeonPos;
        private BlockPos min;
        private BlockPos max;
        private boolean protectionSystemEnabled;
        private boolean preventBlockBreaking;
        private boolean preventBlockPlacing;
        private boolean preventEntitySpawning;
        private boolean preventExplosionsOther;
        private boolean preventExplosionsTNT;
        private boolean preventFireSpreading;
        private boolean ignoreNoBossOrNexus;
        private final Set<UUID> entityDependencies = new HashSet<UUID>();
        private final Set<BlockPos> blockDependencies = new HashSet<BlockPos>();
        private final Set<BlockPos> unprotectedBlocks = new HashSet<BlockPos>();

        public Builder(String dungeonName, BlockPos dungeonPos) {
            this.dungeonName = dungeonName;
            this.min = this.dungeonPos = dungeonPos.func_185334_h();
            this.max = this.dungeonPos;
        }

        public Builder(DungeonBase dungeonConfig, BlockPos dungeonPos) {
            this.dungeonName = dungeonConfig.getDungeonName();
            this.min = this.dungeonPos = dungeonPos.func_185334_h();
            this.max = this.dungeonPos;
            this.setup(dungeonConfig);
        }

        public void setup(boolean enabled, boolean breaking, boolean placing, boolean spawning, boolean explosions, boolean tnt, boolean fire, boolean persistent) {
            this.protectionSystemEnabled = enabled;
            this.preventBlockBreaking = breaking;
            this.preventBlockPlacing = placing;
            this.preventEntitySpawning = spawning;
            this.preventExplosionsOther = explosions;
            this.preventExplosionsTNT = tnt;
            this.preventFireSpreading = fire;
            this.ignoreNoBossOrNexus = persistent;
        }

        public void setup(DungeonBase dungeonConfig) {
            this.protectionSystemEnabled = dungeonConfig.isProtectionSystemEnabled();
            this.preventBlockBreaking = dungeonConfig.preventBlockBreaking();
            this.preventBlockPlacing = dungeonConfig.preventBlockPlacing();
            this.preventEntitySpawning = dungeonConfig.preventEntitySpawning();
            this.preventExplosionsOther = dungeonConfig.preventExplosionsOther();
            this.preventExplosionsTNT = dungeonConfig.preventExplosionsTNT();
            this.preventFireSpreading = dungeonConfig.preventFireSpreading();
            this.ignoreNoBossOrNexus = dungeonConfig.ignoreNoBossOrNexus();
        }

        public Builder(NBTTagCompound compound) {
            this.dungeonName = compound.func_74779_i("dungeonName");
            this.dungeonPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("dungeonPos"));
            this.min = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("min"));
            this.max = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("max"));
            this.protectionSystemEnabled = compound.func_74767_n("protectionSystemEnabled");
            this.preventBlockBreaking = compound.func_74767_n("preventBlockBreaking");
            this.preventBlockPlacing = compound.func_74767_n("preventBlockPlacing");
            this.preventEntitySpawning = compound.func_74767_n("preventEntitySpawning");
            this.preventExplosionsOther = compound.func_74767_n("preventExplosionsOther");
            this.preventExplosionsTNT = compound.func_74767_n("preventExplosionsTNT");
            this.preventFireSpreading = compound.func_74767_n("preventFireSpreading");
            this.ignoreNoBossOrNexus = compound.func_74767_n("ignoreNoBossOrNexus");
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])compound.func_74770_j("entityDependencies"));
            while (buf.readerIndex() < buf.writerIndex()) {
                this.entityDependencies.add(ByteBufUtil.readUuid(buf));
            }
            ByteBuf buf1 = Unpooled.wrappedBuffer((byte[])compound.func_74770_j("entityDependencies"));
            while (buf1.readerIndex() < buf1.writerIndex()) {
                this.blockDependencies.add(ByteBufUtil.readBlockPos(buf1));
            }
            ByteBuf buf2 = Unpooled.wrappedBuffer((byte[])compound.func_74770_j("entityDependencies"));
            while (buf2.readerIndex() < buf2.writerIndex()) {
                this.unprotectedBlocks.add(ByteBufUtil.readBlockPos(buf2));
            }
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("dungeonName", this.dungeonName);
            compound.func_74782_a("dungeonPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.dungeonPos));
            compound.func_74782_a("min", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.min));
            compound.func_74782_a("max", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.max));
            compound.func_74757_a("protectionSystemEnabled", this.protectionSystemEnabled);
            compound.func_74757_a("preventBlockBreaking", this.preventBlockBreaking);
            compound.func_74757_a("preventBlockPlacing", this.preventBlockPlacing);
            compound.func_74757_a("preventEntitySpawning", this.preventEntitySpawning);
            compound.func_74757_a("preventExplosionsOther", this.preventExplosionsOther);
            compound.func_74757_a("preventExplosionsTNT", this.preventExplosionsTNT);
            compound.func_74757_a("preventFireSpreading", this.preventFireSpreading);
            compound.func_74757_a("ignoreNoBossOrNexus", this.ignoreNoBossOrNexus);
            compound.func_74782_a("entityDependencies", (NBTBase)this.entityDependencies.stream().collect(NBTCollectors.toNBTByteArray(ByteBufUtil::writeUuid)));
            compound.func_74782_a("blockDependencies", (NBTBase)this.blockDependencies.stream().collect(NBTCollectors.toNBTByteArray(ByteBufUtil::writeBlockPos)));
            compound.func_74782_a("unprotectedBlocks", (NBTBase)this.blockDependencies.stream().collect(NBTCollectors.toNBTByteArray(ByteBufUtil::writeBlockPos)));
            return compound;
        }

        public void addEntity(Entity entity) {
            if (!this.protectionSystemEnabled) {
                return;
            }
            this.entityDependencies.add(entity.getPersistentID());
        }

        public void addBlock(BlockPos pos) {
            if (!this.protectionSystemEnabled) {
                return;
            }
            this.blockDependencies.add(pos.func_185334_h());
        }

        public void excludePos(BlockPos pos) {
            if (!this.protectionSystemEnabled) {
                return;
            }
            this.unprotectedBlocks.add(pos.func_185334_h());
        }

        public void updateMin(BlockPos pos) {
            this.min = new BlockPos(Math.min(pos.func_177958_n(), this.min.func_177958_n()), Math.min(pos.func_177956_o(), this.min.func_177956_o()), Math.min(pos.func_177952_p(), this.min.func_177952_p()));
        }

        public void updateMax(BlockPos pos) {
            this.max = new BlockPos(Math.max(pos.func_177958_n(), this.max.func_177958_n()), Math.max(pos.func_177956_o(), this.max.func_177956_o()), Math.max(pos.func_177952_p(), this.max.func_177952_p()));
        }

        @Nullable
        public ProtectedRegion build(World world) {
            if (!this.protectionSystemEnabled) {
                return null;
            }
            ProtectedRegion protectedRegion = new ProtectedRegion(world, this.dungeonName, this.dungeonPos, this.min, this.max);
            protectedRegion.preventBlockBreaking = this.preventBlockBreaking;
            protectedRegion.preventBlockPlacing = this.preventBlockPlacing;
            protectedRegion.preventEntitySpawning = this.preventEntitySpawning;
            protectedRegion.preventExplosionsOther = this.preventExplosionsOther;
            protectedRegion.preventExplosionsTNT = this.preventExplosionsTNT;
            protectedRegion.preventFireSpreading = this.preventFireSpreading;
            protectedRegion.ignoreNoBossOrNexus = this.ignoreNoBossOrNexus;
            protectedRegion.isGenerating = false;
            protectedRegion.blockDependencies.addAll(this.blockDependencies);
            protectedRegion.entityDependencies.addAll(this.entityDependencies);
            this.unprotectedBlocks.forEach(p -> protectedRegion.setProtectionState((BlockPos)p, 1));
            return protectedRegion;
        }
    }
}

