/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.client.gui;

import appeng.util.helpers.ItemHandlerUtil;
import dev.beecube31.crazyae2.client.gui.sprites.StateSprite;
import dev.beecube31.crazyae2.common.containers.base.CrazyAEBaseContainer;
import dev.beecube31.crazyae2.common.interfaces.gui.IColorizeableSlot;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class CrazyAESlot
extends Slot
implements IColorizeableSlot {
    private static final IInventory emptyInventory = new InventoryBasic("[undefined]", true, 0);
    private final IItemHandler itemHandler;
    private final int index;
    private final int defX;
    private final int defY;
    private boolean isDraggable = true;
    private boolean isPlayerSide = false;
    private CrazyAEBaseContainer myContainer = null;
    private StateSprite IIcon;
    private hasCalculatedValidness isValid;
    private boolean isDisplay = false;
    private boolean returnAsSingleStack;
    private int stackLimit = -1;

    public CrazyAESlot(IItemHandler inv, int idx, int x, int y) {
        super(emptyInventory, idx, x, y);
        this.itemHandler = inv;
        this.index = idx;
        this.defX = x;
        this.defY = y;
        this.setIsValid(hasCalculatedValidness.NotAvailable);
    }

    public CrazyAESlot setNotDraggable() {
        this.setDraggable(false);
        return this;
    }

    public CrazyAESlot setPlayerSide() {
        this.isPlayerSide = true;
        return this;
    }

    public String getTooltip() {
        return null;
    }

    public void clearStack() {
        ItemHandlerUtil.setStackInSlot((IItemHandler)this.itemHandler, (int)this.index, (ItemStack)ItemStack.field_190927_a);
    }

    public boolean func_75214_a(@Nonnull ItemStack par1ItemStack) {
        if (this.isSlotEnabled()) {
            return this.itemHandler.isItemValid(this.index, par1ItemStack);
        }
        return false;
    }

    @Nonnull
    public ItemStack func_75211_c() {
        if (!this.isSlotEnabled()) {
            return ItemStack.field_190927_a;
        }
        if (this.itemHandler.getSlots() <= this.getSlotIndex()) {
            return ItemStack.field_190927_a;
        }
        if (this.isDisplay()) {
            this.setDisplay(false);
            if (this.returnAsSingleStack()) {
                this.setReturnAsSingleStack(false);
                ItemStack ret = this.getDisplayStack().func_77946_l();
                ret.func_190920_e(1);
                return ret;
            }
            return this.getDisplayStack();
        }
        return this.itemHandler.getStackInSlot(this.index);
    }

    private boolean returnAsSingleStack() {
        return this.returnAsSingleStack;
    }

    public void setReturnAsSingleStack(boolean returnAsSingleStack) {
        this.returnAsSingleStack = returnAsSingleStack;
    }

    public void func_75215_d(@NotNull ItemStack stack) {
        if (this.isSlotEnabled()) {
            ItemHandlerUtil.setStackInSlot((IItemHandler)this.itemHandler, (int)this.index, (ItemStack)stack);
            if (this.getContainer() != null) {
                this.getContainer().onSlotChange(this);
            }
        }
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public void func_75218_e() {
        this.setIsValid(hasCalculatedValidness.NotAvailable);
        if (this.isSlotEnabled() && this.itemHandler != null) {
            ItemHandlerUtil.setStackInSlot((IItemHandler)this.itemHandler, (int)this.index, (ItemStack)this.func_75211_c().func_77946_l());
            if (this.getContainer() != null) {
                this.getContainer().onSlotChange(this);
            }
        }
        super.func_75218_e();
    }

    public int func_75219_a() {
        if (this.stackLimit != -1) {
            return this.stackLimit;
        }
        return this.itemHandler.getSlotLimit(this.index);
    }

    public CrazyAESlot setStackLimit(int i) {
        this.stackLimit = i;
        return this;
    }

    public int func_178170_b(@Nonnull ItemStack stack) {
        return Math.min(this.func_75219_a(), stack.func_77976_d());
    }

    public boolean func_82869_a(@NotNull EntityPlayer par1EntityPlayer) {
        if (this.isSlotEnabled()) {
            ItemStack draggedStack = par1EntityPlayer.field_71071_by.func_70445_o();
            ItemStack slotStack = this.func_75211_c();
            if (!draggedStack.func_190926_b() && (draggedStack.func_77969_a(slotStack) ? draggedStack.func_190916_E() >= draggedStack.func_77976_d() : slotStack.func_190916_E() > slotStack.func_77976_d())) {
                return false;
            }
        }
        if (this.isSlotEnabled()) {
            return !this.itemHandler.extractItem(this.index, Integer.MAX_VALUE, true).func_190926_b();
        }
        return false;
    }

    @Nonnull
    public ItemStack func_75209_a(int amount) {
        return this.itemHandler.extractItem(this.index, amount, false);
    }

    public boolean isSameInventory(@NotNull Slot other) {
        return other instanceof CrazyAESlot && ((CrazyAESlot)other).itemHandler == this.itemHandler;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_111238_b() {
        return this.isSlotEnabled();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CrazyAESlot getTarget() {
        return this;
    }

    public boolean isSlotEnabled() {
        return true;
    }

    public ItemStack getDisplayStack() {
        if (this.itemHandler == null || !this.isSlotEnabled() || this.itemHandler.getSlots() <= this.index) {
            return ItemStack.field_190927_a;
        }
        return this.itemHandler.getStackInSlot(this.index);
    }

    public float getOpacityOfIcon() {
        return 0.4f;
    }

    public boolean renderIconWithItem() {
        return false;
    }

    public StateSprite getIcon() {
        return this.getIIcon();
    }

    public boolean isPlayerSide() {
        return this.isPlayerSide;
    }

    public boolean shouldDisplay() {
        return this.isSlotEnabled();
    }

    public int getX() {
        return this.defX;
    }

    public int getY() {
        return this.defY;
    }

    private StateSprite getIIcon() {
        return this.IIcon;
    }

    public Slot setIIcon(StateSprite iIcon) {
        this.IIcon = iIcon;
        return this;
    }

    private boolean isDisplay() {
        return this.isDisplay;
    }

    public void setDisplay(boolean isDisplay) {
        this.isDisplay = isDisplay;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }

    private void setDraggable(boolean isDraggable) {
        this.isDraggable = isDraggable;
    }

    void setPlayerSide(boolean isPlayerSide) {
        this.isPlayerSide = isPlayerSide;
    }

    public hasCalculatedValidness getIsValid() {
        return this.isValid;
    }

    public void setIsValid(hasCalculatedValidness isValid) {
        this.isValid = isValid;
    }

    protected CrazyAEBaseContainer getContainer() {
        return this.myContainer;
    }

    public void setContainer(CrazyAEBaseContainer myContainer) {
        this.myContainer = myContainer;
    }

    public static enum hasCalculatedValidness {
        NotAvailable,
        Valid,
        Invalid;

    }
}

