/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.client.gui.components;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class ComponentHue {
    public static final int DEFAULT_TEXT_COLOR = 0x404040;
    private float red;
    private float green;
    private float blue;
    private float alpha;

    public ComponentHue() {
        this.red = 1.0f;
        this.green = 1.0f;
        this.blue = 1.0f;
        this.alpha = 1.0f;
    }

    public ComponentHue(int intColor) {
        this.red = (float)(intColor >> 16 & 0xFF) / 255.0f;
        this.blue = (float)(intColor >> 8 & 0xFF) / 255.0f;
        this.green = (float)(intColor & 0xFF) / 255.0f;
        this.alpha = (float)(intColor >> 24 & 0xFF) / 255.0f;
    }

    public ComponentHue(float red, float green, float blue, float alpha) {
        if ((double)red > 1.0) {
            return;
        }
        if ((double)green > 1.0) {
            return;
        }
        if ((double)blue > 1.0) {
            return;
        }
        if ((double)alpha > 1.0) {
            return;
        }
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public void drawHue() {
        GlStateManager.func_179131_c((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
    }

    public void drawHue(float red, float green, float blue, float alpha) {
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void endDrawHue() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void setRed(float red) {
        if ((double)red > 1.0) {
            return;
        }
        this.red = red;
    }

    public void setGreen(float green) {
        if ((double)green > 1.0) {
            return;
        }
        this.green = green;
    }

    public void setBlue(float blue) {
        if ((double)blue > 1.0) {
            return;
        }
        this.blue = blue;
    }

    public void setAlpha(float alpha) {
        if ((double)alpha > 1.0) {
            return;
        }
        this.alpha = alpha;
    }

    public void setParams(float red, float green, float blue, float alpha) {
        if ((double)red > 1.0) {
            return;
        }
        if ((double)green > 1.0) {
            return;
        }
        if ((double)blue > 1.0) {
            return;
        }
        if ((double)alpha > 1.0) {
            return;
        }
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public int getIntColor() {
        int r = (int)(this.red * 255.0f) & 0xFF;
        int g = (int)(this.green * 255.0f) & 0xFF;
        int b = (int)(this.blue * 255.0f) & 0xFF;
        int a = (int)(this.alpha * 255.0f) & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public void drawString(String str, int x, int y, FontRenderer renderer) {
        renderer.func_78276_b(str, x, y, this.getIntColor());
    }

    public void drawCenteredText(String text, int centerX, int centerY, int color, FontRenderer renderer) {
        int textWidth = renderer.func_78256_a(text);
        int drawX = centerX - textWidth / 2;
        renderer.func_78276_b(text, drawX, centerY, color);
    }

    public void drawCenteredText(String text, int centerX, int centerY, FontRenderer renderer) {
        int textWidth = renderer.func_78256_a(text);
        int drawX = centerX - textWidth / 2;
        renderer.func_78276_b(text, drawX, centerY, this.getIntColor());
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public static void drawGradient(int x1, int y1, int x2, int y2, int colorLeft, int colorMid, int colorRight) {
        int midX = x1 + (x2 - x1) / 2;
        ComponentHue.drawGradientRect(x1, y1, midX, y2, colorLeft, colorMid);
        ComponentHue.drawGradientRect(midX, y1, x2, y2, colorMid, colorRight);
    }

    protected static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)right, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }
}

