/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.client.gui.implementations;

import dev.beecube31.crazyae2.client.gui.CrazyAEBaseGui;
import dev.beecube31.crazyae2.client.gui.sprites.StateSprite;
import dev.beecube31.crazyae2.client.gui.widgets.HexTextField;
import dev.beecube31.crazyae2.client.gui.widgets.HoverImageButton;
import dev.beecube31.crazyae2.client.gui.widgets.OptionSideButton;
import dev.beecube31.crazyae2.client.gui.widgets.Slider;
import dev.beecube31.crazyae2.common.containers.ContainerColorizerGui;
import dev.beecube31.crazyae2.common.enums.ColorizerType;
import dev.beecube31.crazyae2.common.i18n.CrazyAEGuiText;
import dev.beecube31.crazyae2.common.interfaces.gui.IGuiElementsCallbackHandler;
import dev.beecube31.crazyae2.common.items.ColorizerObj;
import dev.beecube31.crazyae2.common.networking.network.NetworkHandler;
import dev.beecube31.crazyae2.common.networking.packets.PacketSwitchGuis;
import dev.beecube31.crazyae2.common.networking.packets.PacketUptadeTextField;
import dev.beecube31.crazyae2.common.util.ColorUtils;
import dev.beecube31.crazyae2.common.util.SystemUtils;
import dev.beecube31.crazyae2.core.CrazyAE;
import dev.beecube31.crazyae2.core.client.CrazyAEClientConfig;
import dev.beecube31.crazyae2.core.client.CrazyAEClientState;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class GuiColorizerGui
extends CrazyAEBaseGui
implements IGuiElementsCallbackHandler {
    private static final String texture = "guis/gui_colorizer.png";
    private OptionSideButton colorizerTypeBtn;
    private OptionSideButton restoreDefaults;
    private HoverImageButton copyToClipboard;
    private HoverImageButton pasteFromClipboard;
    private HexTextField textField;
    private Slider sliderR;
    private Slider sliderG;
    private Slider sliderB;
    private final ContainerColorizerGui container;
    protected final ColorizerType type;

    public GuiColorizerGui(InventoryPlayer inventoryPlayer, ColorizerObj te) {
        super(new ContainerColorizerGui(inventoryPlayer, te));
        this.container = (ContainerColorizerGui)this.field_147002_h;
        this.field_147000_g = 128;
        this.field_146999_f += 26;
        this.type = ColorizerType.GUI;
    }

    protected void func_146284_a(GuiButton btn) throws IOException {
        String toPaste;
        super.func_146284_a(btn);
        if (btn == this.restoreDefaults) {
            this.restoreDefaults();
        }
        if (btn == this.colorizerTypeBtn) {
            NetworkHandler.instance().sendToServer(new PacketSwitchGuis((Object)this.type.toGUI()));
        }
        if (btn == this.copyToClipboard) {
            SystemUtils.copyToClipboard(this.textField.func_146179_b());
        }
        if (btn == this.pasteFromClipboard && (toPaste = SystemUtils.pasteFromClipboard()) != null && ColorUtils.getRGBFromHex(toPaste) != null) {
            this.textField.func_146180_a("");
            this.textField.func_146191_b(toPaste);
            NetworkHandler.instance().sendToServer(new PacketUptadeTextField("Colorizer.Text", toPaste));
        }
    }

    private void restoreDefaults() {
        this.sliderR.setScroll(255.0f);
        this.sliderG.setScroll(255.0f);
        this.sliderB.setScroll(255.0f);
        this.onInteractionUpdate();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (!CrazyAEClientConfig.isColorizingEnabled()) {
            this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentString(CrazyAEGuiText.COLORIZING_DISABLED.getLocal()), false);
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        this.sliderR = new Slider(56, 25, 114, 0.0f, 255.0f, this.getGuiHue(), this);
        this.sliderR.setScroll(CrazyAEClientConfig.getColorizerColorRed());
        this.sliderG = new Slider(56, 56, 114, 0.0f, 255.0f, this.getGuiHue(), this);
        this.sliderG.setScroll(CrazyAEClientConfig.getColorizerColorGreen());
        this.sliderB = new Slider(56, 87, 114, 0.0f, 255.0f, this.getGuiHue(), this);
        this.sliderB.setScroll(CrazyAEClientConfig.getColorizerColorBlue());
        this.registerScrollSrc(this.sliderR);
        this.registerScrollSrc(this.sliderG);
        this.registerScrollSrc(this.sliderB);
        this.colorizerTypeBtn = new OptionSideButton(this.field_147003_i + 174, this.field_147009_r, StateSprite.ABC, this.type.toLocal(), "", this.field_146296_j, this.getGuiHue(), this.getTextHue(), 0, OptionSideButton.ButtonType.NO_BOTTOM);
        this.field_146292_n.add(this.colorizerTypeBtn);
        this.restoreDefaults = new OptionSideButton(this.field_147003_i + 174, this.field_147009_r + StateSprite.OPTION_SIDE_BUTTON.getSizeY(), StateSprite.RESTORE_DEFAULTS, CrazyAEGuiText.RESTORE_DEFAULTS.getLocal(), "", this.field_146296_j, this.getGuiHue(), this.getTextHue(), 0, OptionSideButton.ButtonType.NO_TOP);
        this.field_146292_n.add(this.restoreDefaults);
        this.textField = new HexTextField(this.field_146289_q, this.field_147003_i + 54, this.field_147009_r + 109, 60, this.field_146289_q.field_78288_b, 0, this.sliderR, this.sliderG, this.sliderB);
        this.textField.func_146185_a(false);
        this.textField.func_146195_b(true);
        this.container.setTextField(this.textField);
        this.copyToClipboard = new HoverImageButton(0, this.field_147003_i + 106, this.field_147009_r + 107, 12, 12, StateSprite.COPY_TO_CLIPBOARD_SMALL, CrazyAEGuiText.COPY_TO_CLIPBOARD.getLocal(), this.getGuiHue());
        this.field_146292_n.add(this.copyToClipboard);
        this.pasteFromClipboard = new HoverImageButton(0, this.field_147003_i + 120, this.field_147009_r + 107, 12, 12, StateSprite.PASTE_FROM_CLIPBOARD_SMALL, CrazyAEGuiText.PASTE_FROM_CLIPBOARD.getLocal(), this.getGuiHue());
        this.field_146292_n.add(this.pasteFromClipboard);
        this.updateTextField();
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.drawString(this.getGuiDisplayName(CrazyAEGuiText.GUI_COLORIZER_GUI.getLocal()), 8, 6);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawBG(offsetX, offsetY, mouseX, mouseY);
        this.bindTexture(texture);
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
        this.textField.func_146194_f();
        GuiColorizerGui.func_73734_a((int)(this.field_147003_i + 13), (int)(this.field_147009_r + 19), (int)(this.field_147003_i + 37), (int)(this.field_147009_r + 43), (int)new Color(0xFF0000).getRGB());
        GuiColorizerGui.func_73734_a((int)(this.field_147003_i + 13), (int)(this.field_147009_r + 50), (int)(this.field_147003_i + 37), (int)(this.field_147009_r + 74), (int)new Color(65280).getRGB());
        GuiColorizerGui.func_73734_a((int)(this.field_147003_i + 13), (int)(this.field_147009_r + 81), (int)(this.field_147003_i + 37), (int)(this.field_147009_r + 105), (int)new Color(255).getRGB());
    }

    @Override
    public void onInteractionStart() {
    }

    @Override
    public void onInteractionUpdate() {
        CrazyAEClientState.applyColorizerGui((int)this.sliderR.getCurrentScroll(), (int)this.sliderG.getCurrentScroll(), (int)this.sliderB.getCurrentScroll(), this.getGuiHue());
        this.updateTextField();
    }

    private void updateTextField() {
        try {
            String hex = ColorUtils.getHexFromRGB((int)this.sliderR.getCurrentScroll(), (int)this.sliderG.getCurrentScroll(), (int)this.sliderB.getCurrentScroll());
            if (hex != null && !hex.isEmpty()) {
                this.textField.func_146180_a(hex);
                NetworkHandler.instance().sendToServer(new PacketUptadeTextField("Colorizer.Text", ColorUtils.getHexFromRGB((int)this.sliderR.getCurrentScroll(), (int)this.sliderG.getCurrentScroll(), (int)this.sliderB.getCurrentScroll())));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void onInteractionEnd() {
    }

    @Override
    public CrazyAEBaseGui getCallbackHandler() {
        return this;
    }

    protected void func_73869_a(char character, int key) throws IOException {
        if (!this.func_146983_a(key)) {
            if ((key == 211 || key == 205 || key == 203 || key == 14 || Character.toString(character).equals("#") || ColorUtils.isCharHex(Character.valueOf(character))) && this.textField.func_146201_a(character, key)) {
                try {
                    String out = this.textField.func_146179_b();
                    NetworkHandler.instance().sendToServer(new PacketUptadeTextField("Colorizer.Text", out));
                }
                catch (IOException e) {
                    CrazyAE.logger().debug((Object)e);
                }
            } else {
                super.func_73869_a(character, key);
            }
        }
    }
}

