/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.client.gui.implementations;

import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.definitions.IItemDefinition;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigManager;
import appeng.client.gui.widgets.ISortSource;
import appeng.core.localization.GuiText;
import appeng.util.IConfigManagerHost;
import dev.beecube31.crazyae2.client.gui.CrazyAEBaseGui;
import dev.beecube31.crazyae2.client.gui.sprites.Sprite;
import dev.beecube31.crazyae2.client.gui.widgets.ProgressBar;
import dev.beecube31.crazyae2.client.me.EnergyRepo;
import dev.beecube31.crazyae2.common.containers.ContainerEnergyTerminal;
import dev.beecube31.crazyae2.common.containers.base.slot.InternalEnergySlotME;
import dev.beecube31.crazyae2.common.containers.base.slot.SlotEnergyME;
import dev.beecube31.crazyae2.common.i18n.CrazyAEGuiText;
import dev.beecube31.crazyae2.common.i18n.CrazyAEGuiTooltip;
import dev.beecube31.crazyae2.common.interfaces.gui.ICrazyAEProgressProvider;
import dev.beecube31.crazyae2.common.interfaces.gui.IGuiElementsCallbackHandler;
import dev.beecube31.crazyae2.common.util.Utils;
import dev.beecube31.crazyae2.core.CrazyAE;
import dev.beecube31.crazyae2.core.CrazyAESidedHandler;
import dev.beecube31.crazyae2.core.client.CrazyAEClientConfig;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.input.Keyboard;

public class GuiEnergyTerminal
extends CrazyAEBaseGui
implements ISortSource,
IConfigManagerHost,
IGuiElementsCallbackHandler,
ICrazyAEProgressProvider {
    private final List<SlotEnergyME> slots = new LinkedList<SlotEnergyME>();
    private final EnergyRepo repo;
    private final ContainerEnergyTerminal container;
    private ProgressBar efBar;
    private ProgressBar euBar;
    private ProgressBar feBar;
    private ProgressBar qeBar;
    private ProgressBar seBar;
    protected ITerminalHost terminal;
    private final List<ProgressBar> activeProgressBars = new ArrayList<ProgressBar>();
    private final Map<Integer, IItemDefinition> progressBarEnergyTypes = new LinkedHashMap<Integer, IItemDefinition>();

    public GuiEnergyTerminal(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        this(inventoryPlayer, te, new ContainerEnergyTerminal(inventoryPlayer, te));
    }

    public GuiEnergyTerminal(InventoryPlayer inventoryPlayer, ITerminalHost te, ContainerEnergyTerminal c) {
        super(c);
        this.terminal = te;
        this.field_146999_f = 176;
        this.field_147000_g = 190;
        this.repo = new EnergyRepo();
        this.container = (ContainerEnergyTerminal)this.field_147002_h;
        this.container.setGui(this);
        this.progressBarEnergyTypes.put(1, CrazyAE.definitions().items().EFEnergyAsAeStack());
        this.progressBarEnergyTypes.put(2, CrazyAE.definitions().items().FEEnergyAsAeStack());
        this.progressBarEnergyTypes.put(5, CrazyAE.definitions().items().EUEnergyAsAeStack());
        this.progressBarEnergyTypes.put(3, CrazyAE.definitions().items().SEEnergyAsAeStack());
        this.progressBarEnergyTypes.put(4, CrazyAE.definitions().items().QEEnergyAsAeStack());
    }

    @Override
    public void func_73866_w_() {
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.activeProgressBars.clear();
        for (int x = 0; x < 6; ++x) {
            SlotEnergyME slot = new SlotEnergyME(new InternalEnergySlotME(this.repo, x, Integer.MIN_VALUE, Integer.MIN_VALUE));
            this.getSlots().add(slot);
        }
        ProgressBar protoEfBar = new ProgressBar(this, 0, 0, 72, 18, ProgressBar.Direction.HORIZONTAL, CrazyAEGuiText.EF_ENERGY.getLocal(), 1, this.getGuiHue(), Sprite.ENERGY_BAR_EF, Sprite.ENERGY_BAR_EMPTY, true).disableHue();
        ProgressBar protoFeBar = new ProgressBar(this, 0, 0, 72, 18, ProgressBar.Direction.HORIZONTAL, CrazyAEGuiText.FE_ENERGY.getLocal(), 2, this.getGuiHue(), Sprite.ENERGY_BAR_NE, Sprite.ENERGY_BAR_EMPTY, true).disableHue();
        ProgressBar protoSeBar = new ProgressBar(this, 0, 0, 72, 18, ProgressBar.Direction.HORIZONTAL, CrazyAEGuiText.SE_ENERGY.getLocal(), 3, this.getGuiHue(), Sprite.ENERGY_BAR_SE, Sprite.ENERGY_BAR_EMPTY, true).disableHue();
        ProgressBar protoQeBar = new ProgressBar(this, 0, 0, 72, 18, ProgressBar.Direction.HORIZONTAL, CrazyAEGuiText.QE_ENERGY.getLocal(), 4, this.getGuiHue(), Sprite.ENERGY_BAR_QE, Sprite.ENERGY_BAR_EMPTY, true).disableHue();
        ProgressBar protoEuBar = new ProgressBar(this, 0, 0, 72, 18, ProgressBar.Direction.HORIZONTAL, CrazyAEGuiText.EU_ENERGY.getLocal(), 5, this.getGuiHue(), Sprite.ENERGY_BAR_EU, Sprite.ENERGY_BAR_EMPTY, true).disableHue();
        LinkedHashMap<IItemDefinition, ProgressBar> protoBars = new LinkedHashMap<IItemDefinition, ProgressBar>();
        protoBars.put(this.progressBarEnergyTypes.get(1), protoEfBar);
        protoBars.put(this.progressBarEnergyTypes.get(2), protoFeBar);
        protoBars.put(this.progressBarEnergyTypes.get(5), protoEuBar);
        protoBars.put(this.progressBarEnergyTypes.get(3), protoSeBar);
        protoBars.put(this.progressBarEnergyTypes.get(4), protoQeBar);
        for (Map.Entry entry : protoBars.entrySet()) {
            IItemDefinition energyType = (IItemDefinition)entry.getKey();
            ProgressBar bar = (ProgressBar)entry.getValue();
            if (!CrazyAESidedHandler.availableEnergyTypes.contains(energyType)) continue;
            this.activeProgressBars.add(bar);
        }
        this.positionActiveProgressBars();
        this.field_146292_n.addAll(this.activeProgressBars);
        this.getGuiHue().setParams((float)CrazyAEClientConfig.getColorizerColorRed() / 255.0f, (float)CrazyAEClientConfig.getColorizerColorGreen() / 255.0f, (float)CrazyAEClientConfig.getColorizerColorBlue() / 255.0f, 1.0f);
        this.getTextHue().setParams((float)CrazyAEClientConfig.getColorizerTextColorRed() / 255.0f, (float)CrazyAEClientConfig.getColorizerTextColorGreen() / 255.0f, (float)CrazyAEClientConfig.getColorizerTextColorBlue() / 255.0f, 1.0f);
    }

    private void positionActiveProgressBars() {
        int barWidth = 72;
        int barHeight = 18;
        int horizontalSpacing = 12;
        int verticalSpacing = 15;
        int areaX = this.field_147003_i + 10;
        int areaY = this.field_147009_r + 18;
        int areaWidth = this.field_146999_f - 20;
        int barsPerRow = Math.max(1, areaWidth / (barWidth + horizontalSpacing));
        if (areaWidth % (barWidth + horizontalSpacing) < barWidth && barsPerRow > 1) {
            barsPerRow = Math.max(1, areaWidth / barWidth);
        }
        barsPerRow = Math.min(barsPerRow, 2);
        int numActiveBars = this.activeProgressBars.size();
        if (numActiveBars == 0) {
            return;
        }
        switch (numActiveBars) {
            case 1: {
                ProgressBar bar = this.activeProgressBars.get(0);
                bar.field_146128_h = this.field_147003_i + (this.field_146999_f - barWidth) / 2;
                bar.field_146129_i = areaY + barHeight;
                break;
            }
            case 2: {
                int startX;
                ProgressBar bar1 = this.activeProgressBars.get(0);
                ProgressBar bar2 = this.activeProgressBars.get(1);
                int totalWidth = barWidth * 2 + horizontalSpacing;
                bar1.field_146128_h = startX = this.field_147003_i + (this.field_146999_f - totalWidth) / 2;
                bar1.field_146129_i = areaY + barHeight;
                bar2.field_146128_h = startX + barWidth + horizontalSpacing;
                bar2.field_146129_i = areaY + barHeight;
                break;
            }
            case 3: {
                int startXFirstRow;
                int totalWidthFirstRow = barWidth * 2 + horizontalSpacing;
                this.activeProgressBars.get((int)0).field_146128_h = startXFirstRow = this.field_147003_i + (this.field_146999_f - totalWidthFirstRow) / 2;
                this.activeProgressBars.get((int)0).field_146129_i = areaY;
                this.activeProgressBars.get((int)1).field_146128_h = startXFirstRow + barWidth + horizontalSpacing;
                this.activeProgressBars.get((int)1).field_146129_i = areaY;
                this.activeProgressBars.get((int)2).field_146128_h = this.field_147003_i + (this.field_146999_f - barWidth) / 2;
                this.activeProgressBars.get((int)2).field_146129_i = areaY + barHeight + verticalSpacing;
                break;
            }
            case 4: {
                int startXRow;
                int totalWidthRow = barWidth * 2 + horizontalSpacing;
                this.activeProgressBars.get((int)0).field_146128_h = startXRow = this.field_147003_i + (this.field_146999_f - totalWidthRow) / 2;
                this.activeProgressBars.get((int)0).field_146129_i = areaY;
                this.activeProgressBars.get((int)1).field_146128_h = startXRow + barWidth + horizontalSpacing;
                this.activeProgressBars.get((int)1).field_146129_i = areaY;
                this.activeProgressBars.get((int)2).field_146128_h = startXRow;
                this.activeProgressBars.get((int)2).field_146129_i = areaY + barHeight + verticalSpacing;
                this.activeProgressBars.get((int)3).field_146128_h = startXRow + barWidth + horizontalSpacing;
                this.activeProgressBars.get((int)3).field_146129_i = areaY + barHeight + verticalSpacing;
                break;
            }
            case 5: {
                int startXRow;
                int totalWidthRow = barWidth * 2 + horizontalSpacing;
                this.activeProgressBars.get((int)0).field_146128_h = startXRow = this.field_147003_i + (this.field_146999_f - totalWidthRow) / 2;
                this.activeProgressBars.get((int)0).field_146129_i = areaY;
                this.activeProgressBars.get((int)1).field_146128_h = startXRow + barWidth + horizontalSpacing;
                this.activeProgressBars.get((int)1).field_146129_i = areaY;
                this.activeProgressBars.get((int)2).field_146128_h = startXRow;
                this.activeProgressBars.get((int)2).field_146129_i = areaY + barHeight + verticalSpacing;
                this.activeProgressBars.get((int)3).field_146128_h = startXRow + barWidth + horizontalSpacing;
                this.activeProgressBars.get((int)3).field_146129_i = areaY + barHeight + verticalSpacing;
                this.activeProgressBars.get((int)4).field_146128_h = this.field_147003_i + (this.field_146999_f - barWidth) / 2;
                this.activeProgressBars.get((int)4).field_146129_i = areaY + (barHeight + verticalSpacing) * 2;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid energy bars size");
            }
        }
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.drawString(CrazyAEGuiText.ENERGY_TERMINAL.getLocal(), 8, 6);
        this.drawString(GuiText.inventory.getLocal(), 8, this.field_147000_g - 96 + 3);
        this.getTextHue().endDrawHue();
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawBG(offsetX, offsetY, mouseX, mouseY);
        this.bindTexture(this.getBackground());
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_73876_c() {
        this.repo.setPower(this.container.isPowered());
        super.func_73876_c();
    }

    public void postUpdate(List<IAEItemStack> list) {
        for (IAEItemStack is : list) {
            this.repo.postUpdate(is);
        }
        this.repo.updateView();
    }

    public Enum<SortOrder> getSortBy() {
        return SortOrder.NAME;
    }

    public Enum<SortDir> getSortDir() {
        return SortDir.ASCENDING;
    }

    public Enum<ViewItems> getSortDisplay() {
        return ViewItems.ALL;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.repo.updateView();
    }

    protected List<SlotEnergyME> getSlots() {
        return this.slots;
    }

    @Override
    protected boolean isPowered() {
        return this.repo.hasPower();
    }

    protected String getBackground() {
        return "guis/energy_terminal.png";
    }

    @Override
    public void onInteractionStart() {
    }

    @Override
    public void onInteractionUpdate() {
    }

    @Override
    public void onInteractionEnd() {
    }

    @Override
    public CrazyAEBaseGui getCallbackHandler() {
        return this;
    }

    @Override
    public double getCurrentProgress() {
        return -404.0;
    }

    @Override
    public double getCurrentProgress(int index) {
        AtomicLong ret = new AtomicLong();
        switch (index) {
            case 1: {
                this.getSlots().forEach(is -> {
                    if (CrazyAE.definitions().items().EFEnergyAsAeStack().isSameAs(is.getDefinition())) {
                        ret.set(is.getAEStack().getStackSize());
                    }
                });
                break;
            }
            case 2: {
                this.getSlots().forEach(is -> {
                    if (CrazyAE.definitions().items().FEEnergyAsAeStack().isSameAs(is.getDefinition())) {
                        ret.set(is.getAEStack().getStackSize());
                    }
                });
                break;
            }
            case 3: {
                this.getSlots().forEach(is -> {
                    if (CrazyAE.definitions().items().SEEnergyAsAeStack().isSameAs(is.getDefinition())) {
                        ret.set(is.getAEStack().getStackSize());
                    }
                });
                break;
            }
            case 4: {
                this.getSlots().forEach(is -> {
                    if (CrazyAE.definitions().items().QEEnergyAsAeStack().isSameAs(is.getDefinition())) {
                        ret.set(is.getAEStack().getStackSize());
                    }
                });
                break;
            }
            case 5: {
                this.getSlots().forEach(is -> {
                    if (CrazyAE.definitions().items().EUEnergyAsAeStack().isSameAs(is.getDefinition())) {
                        ret.set(is.getAEStack().getStackSize());
                    }
                });
            }
        }
        return ret.get();
    }

    @Override
    public double getMaxProgress() {
        return 1.0;
    }

    @Override
    public double getMaxProgress(int index) {
        return 1.0;
    }

    @Override
    public String getTooltip(String title, boolean disableMaxProgress, int tooltipID) {
        return title + "\n" + CrazyAEGuiTooltip.STORED.getLocalWithSpaceAtEnd() + (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? Utils.getFullDecimalOf(this.getCurrentProgress(tooltipID)) : Utils.format4(this.getCurrentProgress(tooltipID)));
    }
}

