/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.client.gui.implementations;

import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigManager;
import appeng.client.gui.widgets.ISortSource;
import appeng.core.localization.GuiText;
import appeng.util.IConfigManagerHost;
import dev.beecube31.crazyae2.client.gui.CrazyAEBaseGui;
import dev.beecube31.crazyae2.client.gui.CrazyAEBaseMEGui;
import dev.beecube31.crazyae2.client.gui.widgets.Scrollbar;
import dev.beecube31.crazyae2.client.me.ManaRepo;
import dev.beecube31.crazyae2.common.containers.ContainerManaTerminal;
import dev.beecube31.crazyae2.common.containers.base.slot.InternalManaSlotME;
import dev.beecube31.crazyae2.common.containers.base.slot.SlotManaME;
import dev.beecube31.crazyae2.common.i18n.CrazyAEGuiText;
import dev.beecube31.crazyae2.common.i18n.CrazyAEGuiTooltip;
import dev.beecube31.crazyae2.common.interfaces.gui.IGuiElementsCallbackHandler;
import dev.beecube31.crazyae2.core.client.CrazyAEClientConfig;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;

public class GuiManaTerminal
extends CrazyAEBaseMEGui
implements ISortSource,
IConfigManagerHost,
IGuiElementsCallbackHandler {
    private final List<SlotManaME> meManaSlots = new LinkedList<SlotManaME>();
    private final ManaRepo repo;
    private final ContainerManaTerminal container;
    private final int rows = 6;
    private final int perRow = 9;
    protected ITerminalHost terminal;

    public GuiManaTerminal(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        this(inventoryPlayer, te, new ContainerManaTerminal(inventoryPlayer, te));
    }

    public GuiManaTerminal(InventoryPlayer inventoryPlayer, ITerminalHost te, ContainerManaTerminal c) {
        super(c);
        this.terminal = te;
        this.field_146999_f = 185;
        this.field_147000_g = 222;
        Scrollbar scrollbar = new Scrollbar(this.getGuiHue(), this);
        this.registerScrollSrc(scrollbar);
        this.repo = new ManaRepo(scrollbar);
        this.container = (ContainerManaTerminal)this.field_147002_h;
        this.container.setGui(this);
    }

    @Override
    public void func_73866_w_() {
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.perRow; ++x) {
                int offsetX = 9;
                SlotManaME slot = new SlotManaME(new InternalManaSlotME(this.repo, x + y * this.perRow, offsetX + x * 18, 18 + y * 18));
                this.getMeManaSlots().add(slot);
                this.field_147002_h.field_75151_b.add(slot);
            }
        }
        this.setScrollBar();
        this.getGuiHue().setParams((float)CrazyAEClientConfig.getColorizerColorRed() / 255.0f, (float)CrazyAEClientConfig.getColorizerColorGreen() / 255.0f, (float)CrazyAEClientConfig.getColorizerColorBlue() / 255.0f, 1.0f);
        this.getTextHue().setParams((float)CrazyAEClientConfig.getColorizerTextColorRed() / 255.0f, (float)CrazyAEClientConfig.getColorizerTextColorGreen() / 255.0f, (float)CrazyAEClientConfig.getColorizerTextColorBlue() / 255.0f, 1.0f);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.drawString(CrazyAEGuiText.MANA_TERMINAL.getLocal(), 8, 6);
        this.drawString(GuiText.inventory.getLocal(), 8, this.field_147000_g - 96 + 3);
        this.getTextHue().endDrawHue();
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawBG(offsetX, offsetY, mouseX, mouseY);
        this.bindTexture(this.getBackground());
        int x_width = 197;
        this.func_73729_b(offsetX, offsetY, 0, 0, 197, 18);
        for (int x = 0; x < 6; ++x) {
            this.func_73729_b(offsetX, offsetY + 18 + x * 18, 0, 18, 197, 18);
        }
        this.func_73729_b(offsetX, offsetY + 16 + 108, 0, 70, 197, 176);
    }

    public void func_73876_c() {
        this.repo.setPower(this.container.isPowered());
        super.func_73876_c();
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        Slot slot = this.getSlot(mouseX, mouseY);
        if (slot instanceof SlotManaME) {
            SlotManaME itemSlot = (SlotManaME)slot;
            if (slot.func_111238_b()) {
                IAEItemStack myStack = null;
                try {
                    myStack = itemSlot.getAEStack();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (myStack != null) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(CrazyAEGuiTooltip.MANA.getLocal());
                    list.add(String.format(CrazyAEGuiTooltip.STORED_MANA.getLocal(), NumberFormat.getNumberInstance(Locale.US).format(myStack.getStackSize())));
                    this.func_146283_a(list, mouseX, mouseY);
                    return;
                }
            }
        }
        super.func_191948_b(mouseX, mouseY);
    }

    @Override
    protected void func_184098_a(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
    }

    public void postUpdate(List<IAEItemStack> list) {
        for (IAEItemStack is : list) {
            this.repo.postUpdate(is);
        }
        this.repo.updateView();
        this.setScrollBar();
    }

    private void setScrollBar() {
        Object e = this.getScrollSrcList().stream().findFirst().get();
        if (e instanceof Scrollbar) {
            Scrollbar s = (Scrollbar)e;
            s.setTop(18).setLeft(175).setHeight(this.rows * 18 - 2);
            s.setRange(0, 0, 0);
        }
    }

    public Enum<SortOrder> getSortBy() {
        return SortOrder.NAME;
    }

    public Enum<SortDir> getSortDir() {
        return SortDir.ASCENDING;
    }

    public Enum<ViewItems> getSortDisplay() {
        return ViewItems.ALL;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.repo.updateView();
    }

    protected List<SlotManaME> getMeManaSlots() {
        return this.meManaSlots;
    }

    @Override
    protected boolean isPowered() {
        return this.repo.hasPower();
    }

    protected String getBackground() {
        return "guis/terminal.png";
    }

    @Override
    public void onInteractionStart() {
    }

    @Override
    public void onInteractionUpdate() {
    }

    @Override
    public void onInteractionEnd() {
    }

    @Override
    public CrazyAEBaseGui getCallbackHandler() {
        return this;
    }
}

