/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.client.gui.implementations;

import dev.beecube31.crazyae2.client.gui.CrazyAEBaseGui;
import dev.beecube31.crazyae2.client.gui.sprites.StateSprite;
import dev.beecube31.crazyae2.client.gui.widgets.BasicButton;
import dev.beecube31.crazyae2.client.gui.widgets.OptionSideButton;
import dev.beecube31.crazyae2.common.containers.ContainerQuantumCPU;
import dev.beecube31.crazyae2.common.i18n.CrazyAEGuiText;
import dev.beecube31.crazyae2.common.networking.network.NetworkHandler;
import dev.beecube31.crazyae2.common.networking.packets.PacketSwitchGuis;
import dev.beecube31.crazyae2.common.networking.packets.PacketToggleGuiObject;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiBridge;
import dev.beecube31.crazyae2.common.tile.crafting.TileQuantumCPU;
import dev.beecube31.crazyae2.core.client.CrazyAEClientState;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Mouse;

public class GuiQuantumCPU
extends CrazyAEBaseGui {
    private final ContainerQuantumCPU container;
    private OptionSideButton craftingBlockList;
    private BasicButton pageUpButton;
    private BasicButton pageDownButton;

    public GuiQuantumCPU(InventoryPlayer inventoryPlayer, TileQuantumCPU te) {
        super(new ContainerQuantumCPU(inventoryPlayer, te));
        this.field_147000_g = 256;
        this.field_146999_f += 26;
        this.container = (ContainerQuantumCPU)this.field_147002_h;
    }

    protected void func_146284_a(@NotNull GuiButton par1GuiButton) throws IOException {
        super.func_146284_a(par1GuiButton);
        if (par1GuiButton == this.craftingBlockList) {
            NetworkHandler.instance().sendToServer(new PacketSwitchGuis((Object)CrazyAEGuiBridge.GUI_CRAFTING_BLOCKS_LIST));
        } else if (par1GuiButton == this.pageUpButton) {
            this.changePage(true);
        } else if (par1GuiButton == this.pageDownButton) {
            this.changePage(false);
        }
    }

    private void changePage(boolean scrollUp) {
        int currentPage = this.container.getCurrentPage();
        int newPage = scrollUp ? currentPage - 1 : currentPage + 1;
        int totalPages = this.container.getTotalPages();
        if (newPage < 0) {
            newPage = 0;
        }
        if (newPage >= totalPages) {
            newPage = totalPages > 0 ? totalPages - 1 : 0;
        }
        try {
            if (currentPage != newPage) {
                CrazyAEClientState.lastQCpuPage = newPage;
                this.container.setCurrentPage(newPage);
                NetworkHandler.instance().sendToServer(new PacketToggleGuiObject("CRAZYAE.GUI.QCPU.page.change", String.valueOf(newPage)));
                this.updatePageButtonStates();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void goToPage(int pageNum) {
        int currentPage = this.container.getCurrentPage();
        int totalPages = this.container.getTotalPages();
        if (pageNum < 0) {
            pageNum = 0;
        }
        if (pageNum >= totalPages) {
            pageNum = totalPages > 0 ? totalPages - 1 : 0;
        }
        try {
            if (currentPage != pageNum) {
                CrazyAEClientState.lastQCpuPage = pageNum;
                this.container.setCurrentPage(pageNum);
                NetworkHandler.instance().sendToServer(new PacketToggleGuiObject("CRAZYAE.GUI.QCPU.page.change", String.valueOf(pageNum)));
                this.updatePageButtonStates();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.craftingBlockList = new OptionSideButton(this.field_147003_i + 174, this.field_147009_r, StateSprite.QUARTZ_WRENCH, CrazyAEGuiText.OPEN_CRAFTING_BLOCK_LIST.getLocal(), "", this.field_146296_j, this.getGuiHue(), this.getTextHue(), 0, OptionSideButton.ButtonType.DEFAULT);
        this.field_146292_n.add(this.craftingBlockList);
        this.pageUpButton = new BasicButton(998, this.field_147003_i + 69, this.field_147009_r + 160, 17, 11, "", this.getGuiHue()).hide(true);
        this.field_146292_n.add(this.pageUpButton);
        this.pageDownButton = new BasicButton(999, this.field_147003_i + 90, this.field_147009_r + 160, 17, 11, "", this.getGuiHue()).hide(true);
        this.field_146292_n.add(this.pageDownButton);
        this.goToPage(CrazyAEClientState.lastQCpuPage);
        this.updatePageButtonStates();
    }

    private void updatePageButtonStates() {
        int currentPage = this.container.getCurrentPage();
        int totalPages = this.container.getTotalPages();
        this.pageUpButton.field_146124_l = currentPage > 0;
        this.pageDownButton.field_146124_l = currentPage < totalPages - 1 && totalPages > 1;
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int dWheel = Mouse.getDWheel();
        if (dWheel != 0) {
            int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            int slotAreaXStart = this.field_147003_i + 17;
            int slotAreaYStart = this.field_147009_r + 15;
            int slotAreaXEnd = slotAreaXStart + 144;
            int slotAreaYEnd = slotAreaYStart + 144;
            if (mouseX >= slotAreaXStart && mouseX < slotAreaXEnd && mouseY >= slotAreaYStart && mouseY < slotAreaYEnd) {
                this.changePage(dWheel > 0);
            }
        }
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        String pageText = String.format("%d / %d", this.container.getCurrentPage() + 1, Math.max(1, this.container.getTotalPages()));
        this.drawString(this.getGuiDisplayName(this.getName().getLocal()) + " - " + CrazyAEGuiText.PAGE.getLocalWithSpaceAtEnd() + pageText, 8, 6);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.updatePageButtonStates();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawBG(offsetX, offsetY, mouseX, mouseY);
        this.bindTexture(this.getBackground());
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected String getBackground() {
        return "guis/quantum_cpu.png";
    }

    protected CrazyAEGuiText getName() {
        return CrazyAEGuiText.QUANTUM_CPU;
    }
}

