/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.client.gui.widgets;

import dev.beecube31.crazyae2.client.gui.components.ComponentHue;
import dev.beecube31.crazyae2.client.gui.sprites.Sprite;
import dev.beecube31.crazyae2.common.interfaces.gui.ICrazyAEProgressProvider;
import dev.beecube31.crazyae2.common.interfaces.gui.ITooltipObj;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import org.jetbrains.annotations.NotNull;

public class ProgressBar
extends GuiButton
implements ITooltipObj {
    private final ICrazyAEProgressProvider source;
    private final int id;
    private final Direction layout;
    private final String titleName;
    private String forceMsg;
    private boolean disableHue;
    private final ComponentHue hue;
    private boolean disableMaxProgress = false;
    private final Sprite filledSprite;
    private final Sprite emptySprite;

    public ProgressBar(ICrazyAEProgressProvider source, int posX, int posY, int width, int height, Direction dir, String title, int id, ComponentHue hue, Sprite filledSprite, Sprite emptySprite, boolean disableMaxProgress) {
        super(id, posX, posY, "");
        this.source = source;
        this.field_146128_h = posX;
        this.field_146129_i = posY;
        this.field_146120_f = width;
        this.field_146121_g = height;
        this.layout = dir;
        this.titleName = title;
        this.id = id;
        this.hue = hue;
        this.filledSprite = filledSprite;
        this.emptySprite = emptySprite;
        this.disableMaxProgress = disableMaxProgress;
    }

    public void func_146113_a(@NotNull SoundHandler soundHandlerIn) {
    }

    public void func_191745_a(Minecraft par1Minecraft, int par2, int par3, float partial) {
        if (this.field_146125_m) {
            if (!this.disableHue) {
                this.hue.drawHue();
            }
            if (this.emptySprite != null) {
                par1Minecraft.func_110434_K().func_110577_a(this.emptySprite.getTexture());
                this.func_73729_b(this.field_146128_h, this.field_146129_i, this.emptySprite.getTextureX(), this.emptySprite.getTextureY(), this.field_146120_f, this.field_146121_g);
            }
            double max = this.source.getMaxProgress(this.id);
            double current = this.source.getCurrentProgress(this.id);
            int texX = this.filledSprite.getTextureX();
            int texY = this.filledSprite.getTextureY();
            if (this.layout == Direction.VERTICAL) {
                int diff = (int)Math.min((double)this.field_146121_g * current / max, 100.0);
                par1Minecraft.func_110434_K().func_110577_a(this.filledSprite.getTexture());
                this.func_73729_b(this.field_146128_h, this.field_146129_i, texX, texY, this.field_146120_f, this.disableMaxProgress && current > 0.0 ? this.filledSprite.getSizeY() : diff);
            } else {
                int diff = (int)Math.min((double)this.field_146120_f * current / max, 100.0);
                par1Minecraft.func_110434_K().func_110577_a(this.filledSprite.getTexture());
                this.func_73729_b(this.field_146128_h, this.field_146129_i, texX, texY, this.disableMaxProgress && current > 0.0 ? this.filledSprite.getSizeX() : diff, this.field_146121_g);
            }
            if (!this.disableHue) {
                this.hue.endDrawHue();
            }
            this.func_146119_b(par1Minecraft, par2, par3);
        }
    }

    public ProgressBar disableHue() {
        this.disableHue = true;
        return this;
    }

    public void setVisible(boolean v) {
        this.field_146125_m = v;
    }

    public void setForceMsg(String msg) {
        this.forceMsg = msg;
    }

    @Override
    public String getTooltipMsg() {
        return this.forceMsg != null ? this.forceMsg : this.source.getTooltip(this.titleName, this.disableMaxProgress, this.id);
    }

    @Override
    public int xPos() {
        return this.field_146128_h - 2;
    }

    @Override
    public int yPos() {
        return this.field_146129_i - 2;
    }

    @Override
    public int getWidth() {
        return this.field_146120_f + 4;
    }

    @Override
    public int getHeight() {
        return this.field_146121_g + 4;
    }

    @Override
    public boolean isVisible() {
        return this.field_146125_m;
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

