/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.client.gui.widgets;

import dev.beecube31.crazyae2.client.gui.CrazyAEBaseGui;
import dev.beecube31.crazyae2.client.gui.components.ComponentHue;
import dev.beecube31.crazyae2.common.interfaces.gui.IGuiElementsCallbackHandler;
import dev.beecube31.crazyae2.common.interfaces.gui.IScrollSrc;
import net.minecraft.client.renderer.GlStateManager;
import org.jetbrains.annotations.Nullable;

public class Scrollbar
implements IScrollSrc {
    private int displayX = 0;
    private int displayY = 0;
    private int width = 12;
    private int height = 16;
    private int pageSize = 1;
    private int maxScroll = 0;
    private int minScroll = 0;
    private int currentScroll = 0;
    private final ComponentHue hue;
    private final IGuiElementsCallbackHandler gui;

    public Scrollbar(ComponentHue hue, @Nullable IGuiElementsCallbackHandler gui) {
        this.hue = hue;
        this.gui = gui;
    }

    @Override
    public void draw(CrazyAEBaseGui g) {
        g.bindTexture("minecraft", "gui/container/creative_inventory/tabs.png");
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.getRange() == 0) {
            g.func_73729_b(this.displayX, this.displayY, 232 + this.width, 0, this.width, 15);
        } else {
            this.hue.drawHue();
            int offset = (this.currentScroll - this.minScroll) * (this.height - 15) / this.getRange();
            g.func_73729_b(this.displayX, offset + this.displayY, 232, 0, this.width, 15);
            this.hue.endDrawHue();
        }
    }

    private int getRange() {
        return this.maxScroll - this.minScroll;
    }

    public int getLeft() {
        return this.displayX;
    }

    public Scrollbar setLeft(int v) {
        this.displayX = v;
        return this;
    }

    public int getTop() {
        return this.displayY;
    }

    public Scrollbar setTop(int v) {
        this.displayY = v;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public Scrollbar setWidth(int v) {
        this.width = v;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public Scrollbar setHeight(int v) {
        this.height = v;
        return this;
    }

    public void setRange(int min, int max, int pageSize) {
        this.minScroll = min;
        this.maxScroll = max;
        this.pageSize = pageSize;
        if (this.minScroll > this.maxScroll) {
            this.maxScroll = this.minScroll;
        }
        this.applyRange();
    }

    private void applyRange() {
        this.currentScroll = Math.max(Math.min(this.currentScroll, this.maxScroll), this.minScroll);
    }

    @Override
    public float getCurrentScroll() {
        return this.currentScroll;
    }

    @Override
    public void click(CrazyAEBaseGui aeBaseGui, int x, int y) {
        if (this.getRange() == 0) {
            return;
        }
        if (this.gui != null) {
            this.gui.onInteractionUpdate();
        }
        if (x > this.displayX && x <= this.displayX + this.width && y > this.displayY && y <= this.displayY + this.height) {
            this.currentScroll = y - this.displayY;
            this.currentScroll = this.minScroll + this.currentScroll * 2 * this.getRange() / this.height;
            this.currentScroll = this.currentScroll + 1 >> 1;
            this.applyRange();
        }
    }

    @Override
    public void onClickEnd(CrazyAEBaseGui aeBaseGui, int x, int y) {
        if (this.gui != null) {
            this.gui.onInteractionEnd();
        }
    }

    @Override
    public void wheel(int delta) {
        delta = Math.max(Math.min(-delta, 1), -1);
        this.currentScroll += delta * this.pageSize;
        this.applyRange();
    }
}

