/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.client.gui.widgets;

import dev.beecube31.crazyae2.client.gui.CrazyAEBaseGui;
import dev.beecube31.crazyae2.client.gui.components.ComponentHue;
import dev.beecube31.crazyae2.client.gui.sprites.StateSprite;
import dev.beecube31.crazyae2.common.interfaces.gui.IGuiElementsCallbackHandler;
import dev.beecube31.crazyae2.common.interfaces.gui.IScrollSrc;
import net.minecraft.client.renderer.GlStateManager;

public class Slider
implements IScrollSrc {
    private float maxScroll;
    private float minScroll;
    private float currentScroll;
    private final int displayX;
    private final int displayY;
    private final int maxDisplayX;
    private final int width = 8;
    private final int height = 13;
    private final ComponentHue hue;
    private final IGuiElementsCallbackHandler gui;

    public Slider(int x, int y, int maxX, float minScroll, float maxScroll, ComponentHue hue, IGuiElementsCallbackHandler gui) {
        this.displayX = x;
        this.displayY = y;
        this.maxDisplayX = maxX;
        this.minScroll = minScroll;
        this.maxScroll = maxScroll;
        this.hue = hue;
        this.gui = gui;
        this.currentScroll = minScroll;
    }

    public float getRange() {
        return this.maxScroll - this.minScroll;
    }

    public void setRange(float min, float max) {
        this.minScroll = min;
        this.maxScroll = max;
        if (this.minScroll > this.maxScroll) {
            this.maxScroll = this.minScroll;
        }
        this.checkRange();
    }

    public void setScroll(float value) {
        this.currentScroll = Math.max(Math.min(value, this.maxScroll), this.minScroll);
    }

    public void setScroll(float value, boolean shouldUpdate) {
        this.currentScroll = Math.max(Math.min(value, this.maxScroll), this.minScroll);
        if (shouldUpdate) {
            this.gui.onInteractionUpdate();
        }
    }

    @Override
    public float getCurrentScroll() {
        return this.currentScroll;
    }

    @Override
    public void click(CrazyAEBaseGui aeBaseGui, int mouseX, int mouseY) {
        if (this.getRange() == 0.0f) {
            return;
        }
        if (mouseX >= this.displayX && mouseX <= this.displayX + this.maxDisplayX && mouseY >= this.displayY && mouseY <= this.displayY + this.height) {
            this.gui.onInteractionUpdate();
            int relativeX = mouseX - 4 - this.displayX;
            float percentage = (float)relativeX / (float)(this.maxDisplayX - this.width);
            this.currentScroll = this.minScroll + percentage * this.getRange();
            this.checkRange();
        }
    }

    @Override
    public void onClickEnd(CrazyAEBaseGui aeBaseGui, int x, int y) {
        this.gui.onInteractionEnd();
    }

    private void checkRange() {
        this.currentScroll = Math.max(Math.min(this.currentScroll, this.maxScroll), this.minScroll);
    }

    @Override
    public void draw(CrazyAEBaseGui g) {
        g.bindTexture("crazyae", "guis/states.png");
        if (this.getRange() == 0.0f) {
            GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            g.func_73729_b(this.displayX, this.displayY, StateSprite.SLIDER.getTextureX(), StateSprite.SLIDER.getTextureY(), StateSprite.SLIDER.getSizeX(), StateSprite.SLIDER.getSizeY());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            this.hue.drawHue();
            int offset = Math.round((this.currentScroll - this.minScroll) * (float)(this.maxDisplayX - this.width) / this.getRange());
            g.func_73729_b(this.displayX + offset, this.displayY, StateSprite.SLIDER.getTextureX(), StateSprite.SLIDER.getTextureY(), StateSprite.SLIDER.getSizeX(), StateSprite.SLIDER.getSizeY());
            this.hue.endDrawHue();
        }
    }

    @Override
    public void wheel(int delta) {
    }
}

