/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.client.rendering.models;

import appeng.block.storage.DriveSlotState;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dev.beecube31.crazyae2.client.rendering.models.baked.ImprovedDriveBakedModel;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ImprovedDriveModel
implements IModel {
    private static final ResourceLocation MODEL_BASE = new ResourceLocation("crazyae:block/driveimp_base");
    private static final Map<DriveSlotState, ResourceLocation> MODELS_CELLS = ImmutableMap.builder().put((Object)DriveSlotState.EMPTY, (Object)new ResourceLocation("crazyae:block/drive_cells/drive_cell_empty")).put((Object)DriveSlotState.OFFLINE, (Object)new ResourceLocation("crazyae:block/drive_cells/drive_cell_off")).put((Object)DriveSlotState.ONLINE, (Object)new ResourceLocation("crazyae:block/drive_cells/drive_cell_on")).put((Object)DriveSlotState.TYPES_FULL, (Object)new ResourceLocation("crazyae:block/drive_cells/drive_cell_types_full")).put((Object)DriveSlotState.FULL, (Object)new ResourceLocation("crazyae:block/drive_cells/drive_cell_full")).put((Object)DriveSlotState.NO_CONTENTS, (Object)new ResourceLocation("crazyae:block/drive_cells/drive_cell_no_contents")).build();

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.builder().add((Object)MODEL_BASE).addAll(MODELS_CELLS.values()).build();
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.emptyList();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel baseModel;
        EnumMap<DriveSlotState, IBakedModel> cellModels = new EnumMap<DriveSlotState, IBakedModel>(DriveSlotState.class);
        try {
            baseModel = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_BASE);
            for (DriveSlotState slotState : MODELS_CELLS.keySet()) {
                IModel model = ModelLoaderRegistry.getModel((ResourceLocation)MODELS_CELLS.get(slotState));
                cellModels.put(slotState, model.bake(state, format, bakedTextureGetter));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IBakedModel bakedBase = baseModel.bake(state, format, bakedTextureGetter);
        return new ImprovedDriveBakedModel(bakedBase, cellModels);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

