/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.client.rendering.models;

import com.google.common.collect.ImmutableMap;
import dev.beecube31.crazyae2.client.rendering.models.baked.ManapoolEncodedPatternBakedModel;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ManapoolEncodedPatternModel
implements IModel {
    private static final ResourceLocation BASE_MODEL = new ResourceLocation("crazyae", "item/manapool_encoded_pattern");

    public Collection<ResourceLocation> getDependencies() {
        return Collections.singletonList(BASE_MODEL);
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.emptyList();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel baseModel;
        try {
            baseModel = ModelLoaderRegistry.getModel((ResourceLocation)BASE_MODEL).bake(state, format, bakedTextureGetter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ImmutableMap transforms = PerspectiveMapWrapper.getTransforms((IModelState)state);
        return new ManapoolEncodedPatternBakedModel(baseModel, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transforms);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

