/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.client.rendering.models.baked;

import appeng.block.storage.DriveSlotState;
import appeng.block.storage.DriveSlotsState;
import dev.beecube31.crazyae2.client.rendering.models.baked.MatrixVertexTransformer;
import dev.beecube31.crazyae2.common.blocks.storage.BlockDriveImproved;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.jetbrains.annotations.NotNull;

public class ImprovedDriveBakedModel
implements IBakedModel {
    private final IBakedModel bakedBase;
    private final Map<DriveSlotState, IBakedModel> bakedCells;

    public ImprovedDriveBakedModel(IBakedModel bakedBase, Map<DriveSlotState, IBakedModel> bakedCells) {
        this.bakedBase = bakedBase;
        this.bakedCells = bakedCells;
    }

    @NotNull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(this.bakedBase.func_188616_a(state, side, rand));
        if (side == null && state instanceof IExtendedBlockState) {
            IExtendedBlockState extState = (IExtendedBlockState)state;
            if (!extState.getUnlistedNames().contains(BlockDriveImproved.SLOTS_STATE)) {
                return result;
            }
            DriveSlotsState slotsState = (DriveSlotsState)extState.getValue(BlockDriveImproved.SLOTS_STATE);
            for (int row = 0; row < 5; ++row) {
                for (int col = 0; col < 7; ++col) {
                    DriveSlotState slotState = slotsState.getState(row * 7 + col);
                    IBakedModel bakedCell = this.bakedCells.get(slotState);
                    Matrix4f transform = new Matrix4f();
                    transform.setIdentity();
                    float xOffset = (float)(-col * 2) / 16.0f;
                    float yOffset = (float)(-row * 3) / 16.0f;
                    transform.setTranslation(new Vector3f(xOffset, yOffset, 0.0f));
                    MatrixVertexTransformer transformer = new MatrixVertexTransformer(transform);
                    for (BakedQuad bakedQuad : bakedCell.func_188616_a(state, null, rand)) {
                        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(bakedQuad.getFormat());
                        transformer.setParent((IVertexConsumer)builder);
                        transformer.setVertexFormat(builder.getVertexFormat());
                        bakedQuad.pipe((IVertexConsumer)transformer);
                        result.add((BakedQuad)builder.build());
                    }
                }
            }
        }
        return result;
    }

    public boolean func_177555_b() {
        return this.bakedBase.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.bakedBase.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.bakedBase.func_177556_c();
    }

    @NotNull
    public TextureAtlasSprite func_177554_e() {
        return this.bakedBase.func_177554_e();
    }

    @NotNull
    public ItemCameraTransforms func_177552_f() {
        return this.bakedBase.func_177552_f();
    }

    @NotNull
    public ItemOverrideList func_188617_f() {
        return this.bakedBase.func_188617_f();
    }
}

