/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.client.rendering.models.crafting;

import com.google.common.collect.ImmutableList;
import dev.beecube31.crazyae2.client.rendering.models.crafting.DenseLightBakedModel;
import dev.beecube31.crazyae2.common.blocks.crafting.BlockDenseCraftingUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
public class DenseCraftingCubeModel
implements IModel {
    private static final ResourceLocation RING_CORNER = DenseCraftingCubeModel.texture("ring_corner");
    private static final ResourceLocation RING_SIDE_HOR = DenseCraftingCubeModel.texture("ring_side_hor");
    private static final ResourceLocation RING_SIDE_VER = DenseCraftingCubeModel.texture("ring_side_ver");
    private static final ResourceLocation UNIT_BASE = DenseCraftingCubeModel.texture("unit_base");
    private static final ResourceLocation LIGHT_BASE = DenseCraftingCubeModel.texture("light_base");
    private static final ResourceLocation MONITOR_BASE = DenseCraftingCubeModel.texture("monitor_base");
    private static final ResourceLocation MONITOR_LIGHT_DARK = DenseCraftingCubeModel.texture("monitor_light_dark");
    private static final ResourceLocation MONITOR_LIGHT_MEDIUM = DenseCraftingCubeModel.texture("monitor_light_medium");
    private static final ResourceLocation MONITOR_LIGHT_BRIGHT = DenseCraftingCubeModel.texture("monitor_light_bright");
    private static final ResourceLocation COPROCESSOR_4X_LIGHT = DenseCraftingCubeModel.crazyAETexture("accelerator_4x_light");
    private static final ResourceLocation COPROCESSOR_16X_LIGHT = DenseCraftingCubeModel.crazyAETexture("accelerator_16x_light");
    private static final ResourceLocation COPROCESSOR_64X_LIGHT = DenseCraftingCubeModel.crazyAETexture("accelerator_64x_light");
    private static final ResourceLocation COPROCESSOR_256X_LIGHT = DenseCraftingCubeModel.crazyAETexture("accelerator_256x_light");
    private static final ResourceLocation COPROCESSOR_1024X_LIGHT = DenseCraftingCubeModel.crazyAETexture("accelerator_1024x_light");
    private static final ResourceLocation COPROCESSOR_4096X_LIGHT = DenseCraftingCubeModel.crazyAETexture("accelerator_4096x_light");
    private static final ResourceLocation COPROCESSOR_16384X_LIGHT = DenseCraftingCubeModel.crazyAETexture("accelerator_16384x_light");
    private static final ResourceLocation COPROCESSOR_65536X_LIGHT = DenseCraftingCubeModel.crazyAETexture("accelerator_65536x_light");
    private static final ResourceLocation COPROCESSOR_262144X_LIGHT = DenseCraftingCubeModel.crazyAETexture("accelerator_262144x_light");
    private static final ResourceLocation COPROCESSOR_1048576X_LIGHT = DenseCraftingCubeModel.crazyAETexture("accelerator_1048576x_light");
    private static final ResourceLocation COPROCESSOR_4194304X_LIGHT = DenseCraftingCubeModel.crazyAETexture("accelerator_4194304x_light");
    private static final ResourceLocation COPROCESSOR_CREATIVE_LIGHT = DenseCraftingCubeModel.crazyAETexture("accelerator_creative_light");
    private static final ResourceLocation STORAGE_256K_LIGHT = DenseCraftingCubeModel.crazyAETexture("crafting_storage_256k_light");
    private static final ResourceLocation STORAGE_1MB_LIGHT = DenseCraftingCubeModel.crazyAETexture("crafting_storage_1mb_light");
    private static final ResourceLocation STORAGE_4MB_LIGHT = DenseCraftingCubeModel.crazyAETexture("crafting_storage_4mb_light");
    private static final ResourceLocation STORAGE_16MB_LIGHT = DenseCraftingCubeModel.crazyAETexture("crafting_storage_16mb_light");
    private static final ResourceLocation STORAGE_64MB_LIGHT = DenseCraftingCubeModel.crazyAETexture("crafting_storage_64mb_light");
    private static final ResourceLocation STORAGE_256MB_LIGHT = DenseCraftingCubeModel.crazyAETexture("crafting_storage_256mb_light");
    private static final ResourceLocation STORAGE_1024MB_LIGHT = DenseCraftingCubeModel.crazyAETexture("crafting_storage_1gb_light");
    private static final ResourceLocation STORAGE_2048MB_LIGHT = DenseCraftingCubeModel.crazyAETexture("crafting_storage_2gb_light");
    private static final ResourceLocation STORAGE_8192MB_LIGHT = DenseCraftingCubeModel.crazyAETexture("crafting_storage_8gb_light");
    private static final ResourceLocation STORAGE_32768MB_LIGHT = DenseCraftingCubeModel.crazyAETexture("crafting_storage_32gb_light");
    private static final ResourceLocation STORAGE_131072MB_LIGHT = DenseCraftingCubeModel.crazyAETexture("crafting_storage_128gb_light");
    private static final ResourceLocation STORAGE_CREATIVE_LIGHT = DenseCraftingCubeModel.crazyAETexture("crafting_storage_creative_light");
    private final BlockDenseCraftingUnit.DenseCraftingUnitType type;

    public DenseCraftingCubeModel(BlockDenseCraftingUnit.DenseCraftingUnitType type) {
        this.type = type;
    }

    private static TextureAtlasSprite getLightTexture(Function<ResourceLocation, TextureAtlasSprite> textureGetter, BlockDenseCraftingUnit.DenseCraftingUnitType type) {
        TextureAtlasSprite textureAtlasSprite;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case STORAGE_256K: {
                textureAtlasSprite = textureGetter.apply(STORAGE_256K_LIGHT);
                break;
            }
            case STORAGE_1024K: {
                textureAtlasSprite = textureGetter.apply(STORAGE_1MB_LIGHT);
                break;
            }
            case STORAGE_4096K: {
                textureAtlasSprite = textureGetter.apply(STORAGE_4MB_LIGHT);
                break;
            }
            case STORAGE_16384K: {
                textureAtlasSprite = textureGetter.apply(STORAGE_16MB_LIGHT);
                break;
            }
            case STORAGE_65536K: {
                textureAtlasSprite = textureGetter.apply(STORAGE_64MB_LIGHT);
                break;
            }
            case STORAGE_262144K: {
                textureAtlasSprite = textureGetter.apply(STORAGE_256MB_LIGHT);
                break;
            }
            case STORAGE_1GB: {
                textureAtlasSprite = textureGetter.apply(STORAGE_1024MB_LIGHT);
                break;
            }
            case STORAGE_2GB: {
                textureAtlasSprite = textureGetter.apply(STORAGE_2048MB_LIGHT);
                break;
            }
            case STORAGE_8GB: {
                textureAtlasSprite = textureGetter.apply(STORAGE_8192MB_LIGHT);
                break;
            }
            case STORAGE_32GB: {
                textureAtlasSprite = textureGetter.apply(STORAGE_32768MB_LIGHT);
                break;
            }
            case STORAGE_128GB: {
                textureAtlasSprite = textureGetter.apply(STORAGE_131072MB_LIGHT);
                break;
            }
            case STORAGE_CREATIVE: {
                textureAtlasSprite = textureGetter.apply(STORAGE_CREATIVE_LIGHT);
                break;
            }
            case COPROCESSOR_4X: {
                textureAtlasSprite = textureGetter.apply(COPROCESSOR_4X_LIGHT);
                break;
            }
            case COPROCESSOR_16X: {
                textureAtlasSprite = textureGetter.apply(COPROCESSOR_16X_LIGHT);
                break;
            }
            case COPROCESSOR_64X: {
                textureAtlasSprite = textureGetter.apply(COPROCESSOR_64X_LIGHT);
                break;
            }
            case COPROCESSOR_256X: {
                textureAtlasSprite = textureGetter.apply(COPROCESSOR_256X_LIGHT);
                break;
            }
            case COPROCESSOR_1024X: {
                textureAtlasSprite = textureGetter.apply(COPROCESSOR_1024X_LIGHT);
                break;
            }
            case COPROCESSOR_4096X: {
                textureAtlasSprite = textureGetter.apply(COPROCESSOR_4096X_LIGHT);
                break;
            }
            case COPROCESSOR_16384X: {
                textureAtlasSprite = textureGetter.apply(COPROCESSOR_16384X_LIGHT);
                break;
            }
            case COPROCESSOR_65536X: {
                textureAtlasSprite = textureGetter.apply(COPROCESSOR_65536X_LIGHT);
                break;
            }
            case COPROCESSOR_262144X: {
                textureAtlasSprite = textureGetter.apply(COPROCESSOR_262144X_LIGHT);
                break;
            }
            case COPROCESSOR_1048576X: {
                textureAtlasSprite = textureGetter.apply(COPROCESSOR_1048576X_LIGHT);
                break;
            }
            case COPROCESSOR_4194304X: {
                textureAtlasSprite = textureGetter.apply(COPROCESSOR_4194304X_LIGHT);
                break;
            }
            case COPROCESSOR_CREATIVE: {
                textureAtlasSprite = textureGetter.apply(COPROCESSOR_CREATIVE_LIGHT);
            }
        }
        return textureAtlasSprite;
    }

    private static ResourceLocation texture(String name) {
        return new ResourceLocation("appliedenergistics2", "blocks/crafting/" + name);
    }

    private static ResourceLocation crazyAETexture(String name) {
        return new ResourceLocation("crazyae", "block/crafting/" + name);
    }

    @NotNull
    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    @NotNull
    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of((Object)RING_CORNER, (Object)RING_SIDE_HOR, (Object)RING_SIDE_VER, (Object)UNIT_BASE, (Object)LIGHT_BASE, (Object)COPROCESSOR_4X_LIGHT, (Object)COPROCESSOR_16X_LIGHT, (Object)COPROCESSOR_64X_LIGHT, (Object)COPROCESSOR_256X_LIGHT, (Object)COPROCESSOR_1024X_LIGHT, (Object)COPROCESSOR_4096X_LIGHT, (Object)COPROCESSOR_16384X_LIGHT, (Object[])new ResourceLocation[]{COPROCESSOR_65536X_LIGHT, COPROCESSOR_262144X_LIGHT, COPROCESSOR_1048576X_LIGHT, COPROCESSOR_4194304X_LIGHT, COPROCESSOR_CREATIVE_LIGHT, STORAGE_256K_LIGHT, STORAGE_1MB_LIGHT, STORAGE_4MB_LIGHT, STORAGE_16MB_LIGHT, STORAGE_64MB_LIGHT, STORAGE_256MB_LIGHT, STORAGE_1024MB_LIGHT, STORAGE_2048MB_LIGHT, STORAGE_8192MB_LIGHT, STORAGE_32768MB_LIGHT, STORAGE_131072MB_LIGHT, STORAGE_CREATIVE_LIGHT, MONITOR_BASE, MONITOR_LIGHT_DARK, MONITOR_LIGHT_MEDIUM, MONITOR_LIGHT_BRIGHT});
    }

    @NotNull
    public IBakedModel bake(@NotNull IModelState state, @NotNull VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite ringCorner = bakedTextureGetter.apply(RING_CORNER);
        TextureAtlasSprite ringSideHor = bakedTextureGetter.apply(RING_SIDE_HOR);
        TextureAtlasSprite ringSideVer = bakedTextureGetter.apply(RING_SIDE_VER);
        return new DenseLightBakedModel(format, ringCorner, ringSideHor, ringSideVer, bakedTextureGetter.apply(LIGHT_BASE), DenseCraftingCubeModel.getLightTexture(bakedTextureGetter, this.type));
    }

    @NotNull
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

