/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.blocks.crafting;

import appeng.api.definitions.ITileDefinition;
import appeng.block.crafting.BlockCraftingUnit;
import dev.beecube31.crazyae2.common.util.Utils;
import dev.beecube31.crazyae2.core.CrazyAE;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDenseCraftingUnit
extends BlockCraftingUnit {
    public final DenseCraftingUnitType type;

    public BlockDenseCraftingUnit(DenseCraftingUnitType type) {
        super(null);
        this.type = type;
    }

    public DenseCraftingUnitType getType() {
        return this.type;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        Utils.addReqChannelTooltip(tooltip);
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    public static enum DenseCraftingUnitType {
        STORAGE_256K(262144L, 0){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().craftingStorage256k();
            }
        }
        ,
        STORAGE_1024K(0x100000L, 0){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().craftingStorage1mb();
            }
        }
        ,
        STORAGE_4096K(0x400000L, 0){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().craftingStorage4mb();
            }
        }
        ,
        STORAGE_16384K(0x1000000L, 0){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().craftingStorage16mb();
            }
        }
        ,
        STORAGE_65536K(0x4000000L, 0){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().craftingStorage64mb();
            }
        }
        ,
        STORAGE_262144K(0x10000000L, 0){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().craftingStorage256mb();
            }
        }
        ,
        STORAGE_1GB(0x40000000L, 0){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().craftingStorage1gb();
            }
        }
        ,
        STORAGE_2GB(0x80000000L, 0){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().craftingStorage2gb();
            }
        }
        ,
        STORAGE_8GB(0x200000000L, 0){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().craftingStorage8gb();
            }
        }
        ,
        STORAGE_32GB(0x800000000L, 0){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().craftingStorage32gb();
            }
        }
        ,
        STORAGE_128GB(0x2000000000L, 0){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().craftingStorage128gb();
            }
        }
        ,
        STORAGE_CREATIVE(Long.MAX_VALUE, 0){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().craftingStorageCreative();
            }
        }
        ,
        COPROCESSOR_4X(0L, 4){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().coprocessor4x();
            }
        }
        ,
        COPROCESSOR_16X(0L, 16){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().coprocessor16x();
            }
        }
        ,
        COPROCESSOR_64X(0L, 64){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().coprocessor64x();
            }
        }
        ,
        COPROCESSOR_256X(0L, 256){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().coprocessor256x();
            }
        }
        ,
        COPROCESSOR_1024X(0L, 1024){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().coprocessor1024x();
            }
        }
        ,
        COPROCESSOR_4096X(0L, 4096){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().coprocessor4096x();
            }
        }
        ,
        COPROCESSOR_16384X(0L, 16384){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().coprocessor16384x();
            }
        }
        ,
        COPROCESSOR_65536X(0L, 65536){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().coprocessor65536x();
            }
        }
        ,
        COPROCESSOR_262144X(0L, 262144){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().coprocessor262144x();
            }
        }
        ,
        COPROCESSOR_1048576X(0L, 0x100000){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().coprocessor1048576x();
            }
        }
        ,
        COPROCESSOR_4194304X(0L, 0x400000){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().coprocessor4194304x();
            }
        }
        ,
        COPROCESSOR_CREATIVE(0L, Integer.MAX_VALUE){

            @Override
            public ITileDefinition getBlock() {
                return CrazyAE.definitions().blocks().coprocessorCreative();
            }
        };

        private final long bytes;
        private final int accelFactor;

        private DenseCraftingUnitType(long bytes, int accelFactor) {
            this.bytes = bytes;
            this.accelFactor = accelFactor;
        }

        public long getBytes() {
            return this.bytes;
        }

        public abstract ITileDefinition getBlock();

        public int getAccelerationFactor() {
            return this.accelFactor;
        }
    }
}

