/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.blocks.networking;

import appeng.api.util.AEPartLocation;
import appeng.api.util.IOrientable;
import appeng.util.Platform;
import dev.beecube31.crazyae2.common.base.CrazyAEBlockAttribute;
import dev.beecube31.crazyae2.common.enums.MachineAttributes;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiBridge;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiHandler;
import dev.beecube31.crazyae2.common.tile.networking.TilePatternsInterface;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockInterfacePatterns
extends CrazyAEBlockAttribute {
    private static final PropertyBool OMNIDIRECTIONAL = PropertyBool.func_177716_a((String)"omnidirectional");

    public BlockInterfacePatterns() {
        super(Material.field_151573_f);
    }

    protected IProperty[] getAEStates() {
        return new IProperty[]{OMNIDIRECTIONAL};
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TilePatternsInterface te = (TilePatternsInterface)this.getTileEntity(world, pos);
        boolean omniDirectional = true;
        if (te != null) {
            omniDirectional = te.isOmniDirectional();
        }
        return super.func_176221_a(state, world, pos).func_177226_a((IProperty)OMNIDIRECTIONAL, (Comparable)Boolean.valueOf(omniDirectional));
    }

    public boolean onActivated(World w, BlockPos pos, EntityPlayer p, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (p.func_70093_af()) {
            return false;
        }
        TilePatternsInterface tg = (TilePatternsInterface)this.getTileEntity((IBlockAccess)w, pos);
        if (tg != null) {
            if (Platform.isServer()) {
                CrazyAEGuiHandler.openGUI(p, (TileEntity)tg, AEPartLocation.fromFacing((EnumFacing)side), (Object)CrazyAEGuiBridge.PATTERN_INTERFACE);
            }
            return true;
        }
        return false;
    }

    protected boolean hasCustomRotation() {
        return true;
    }

    protected void customRotateBlock(IOrientable rotatable, EnumFacing axis) {
        if (rotatable instanceof TilePatternsInterface) {
            ((TilePatternsInterface)rotatable).setSide(axis);
        }
    }

    @Override
    public MachineAttributes getAttributes() {
        return new MachineAttributes().setRequireChannel(true);
    }
}

