/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.blocks.networking;

import appeng.api.util.AEPartLocation;
import appeng.api.util.IOrientable;
import appeng.util.Platform;
import dev.beecube31.crazyae2.client.gui.sprites.Sprite;
import dev.beecube31.crazyae2.common.base.CrazyAEBlockAttribute;
import dev.beecube31.crazyae2.common.enums.MachineAttributes;
import dev.beecube31.crazyae2.common.i18n.CrazyAETooltip;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiBridge;
import dev.beecube31.crazyae2.common.sync.CrazyAEGuiHandler;
import dev.beecube31.crazyae2.common.tile.networking.TileQuantumInterface;
import dev.beecube31.crazyae2.common.util.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockQuantumInterface
extends CrazyAEBlockAttribute {
    private static final PropertyBool OMNIDIRECTIONAL = PropertyBool.func_177716_a((String)"omnidirectional");

    public BlockQuantumInterface() {
        super(Material.field_151573_f);
    }

    protected IProperty[] getAEStates() {
        return new IProperty[]{OMNIDIRECTIONAL};
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileQuantumInterface te = (TileQuantumInterface)this.getTileEntity(world, pos);
        boolean omniDirectional = true;
        if (te != null) {
            omniDirectional = te.isOmniDirectional();
        }
        return super.func_176221_a(state, world, pos).func_177226_a((IProperty)OMNIDIRECTIONAL, (Comparable)Boolean.valueOf(omniDirectional));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        tooltip.add(Utils.writeSpriteFlag(Sprite.INFO) + CrazyAETooltip.QUANTUM_INTERFACE_WARNING.getLocal());
    }

    public boolean onActivated(World w, BlockPos pos, EntityPlayer p, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (p.func_70093_af()) {
            return false;
        }
        TileQuantumInterface tg = (TileQuantumInterface)this.getTileEntity((IBlockAccess)w, pos);
        if (tg != null) {
            if (Platform.isServer()) {
                CrazyAEGuiHandler.openGUI(p, (TileEntity)tg, AEPartLocation.fromFacing((EnumFacing)side), (Object)CrazyAEGuiBridge.QUANTUM_INTERFACE);
            }
            return true;
        }
        return false;
    }

    protected boolean hasCustomRotation() {
        return true;
    }

    protected void customRotateBlock(IOrientable rotatable, EnumFacing axis) {
        if (rotatable instanceof TileQuantumInterface) {
            ((TileQuantumInterface)rotatable).setSide(axis);
        }
    }

    @Override
    public MachineAttributes getAttributes() {
        return new MachineAttributes().setRequireChannel(true);
    }
}

