/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.components;

import com.denfop.api.energy.IEnergyEmitter;
import com.denfop.api.energy.IEnergySink;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.sytem.InfoTile;
import dev.beecube31.crazyae2.common.components.base.BaseEnergyDelegate;
import dev.beecube31.crazyae2.common.parts.implementations.PartEnergyImportBus;
import dev.beecube31.crazyae2.core.CrazyAE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class ComponentEFEnergySink
extends BaseEnergyDelegate
implements IEnergySink {
    private int hashCode;
    boolean hasHashCode = false;
    int hashCodeSource;
    public double pastEnergy;
    public double perEnergy;
    public double tick;
    public final List<Integer> energyTicks = new ArrayList<Integer>();
    public final List<InfoTile<IEnergyTile>> validTEs = new ArrayList<InfoTile<IEnergyTile>>();
    public final Map<EnumFacing, IEnergyTile> energyConductorMap = new HashMap<EnumFacing, IEnergyTile>();
    public long id;
    private final PartEnergyImportBus part;

    @Override
    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validTEs;
    }

    public ComponentEFEnergySink(PartEnergyImportBus part) {
        this.part = part;
    }

    public int getSinkTier() {
        return 14;
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing dir) {
        return dir == this.part.getSide().getFacing();
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public int hashCode() {
        if (!this.hasHashCode) {
            this.hasHashCode = true;
            this.hashCode = this.part.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public void AddTile(IEnergyTile tile, EnumFacing dir) {
        if (!this.part.getTile().func_145831_w().field_72995_K) {
            this.energyConductorMap.put(dir, tile);
            this.validTEs.add((InfoTile<IEnergyTile>)new InfoTile((Object)tile, dir.func_176734_d()));
        }
    }

    @Override
    public void RemoveTile(IEnergyTile tile, EnumFacing dir) {
        if (!this.part.getTile().func_145831_w().field_72995_K) {
            this.energyConductorMap.remove(dir);
            Iterator<InfoTile<IEnergyTile>> iter = this.validTEs.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public Map<EnumFacing, IEnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    public double getDemandedEnergy() {
        return this.part.getDemandedEnergy(CrazyAE.definitions().items().EFEnergyAsAeStack());
    }

    public void receiveEnergy(double amount) {
        this.part.receiveEnergy(amount, CrazyAE.definitions().items().EFEnergyAsAeStack());
    }

    public List<Integer> getEnergyTickList() {
        return this.energyTicks;
    }

    public double getPerEnergy() {
        return this.perEnergy;
    }

    public double getPastEnergy() {
        return this.pastEnergy;
    }

    public void setPastEnergy(double pastEnergy) {
        this.pastEnergy = pastEnergy;
    }

    public void addPerEnergy(double setEnergy) {
        this.perEnergy = setEnergy;
    }

    public void addTick(double tick) {
        this.tick = tick;
    }

    public double getTick() {
        return this.tick;
    }

    public boolean isSink() {
        return true;
    }

    @Override
    public TileEntity getTileEntity() {
        return this.part.getHost().getTile();
    }

    @Override
    @NotNull
    public BlockPos getBlockPos() {
        return this.part.getHost().getTile().func_174877_v();
    }
}

