/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.components;

import com.denfop.api.energy.IEnergyAcceptor;
import com.denfop.api.energy.IEnergySource;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.sytem.InfoTile;
import dev.beecube31.crazyae2.common.components.base.BaseEnergyDelegate;
import dev.beecube31.crazyae2.common.parts.implementations.PartEnergyExportBus;
import dev.beecube31.crazyae2.core.CrazyAE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class ComponentEFEnergySource
extends BaseEnergyDelegate
implements IEnergySource {
    private int hashCode;
    boolean hasHashCode = false;
    int hashCodeSource;
    public double pastEnergy;
    public double perEnergy;
    public final List<InfoTile<IEnergyTile>> validTEs = new ArrayList<InfoTile<IEnergyTile>>();
    public final Map<EnumFacing, IEnergyTile> energyConductorMap = new HashMap<EnumFacing, IEnergyTile>();
    public long id;
    private final PartEnergyExportBus part;

    public ComponentEFEnergySource(PartEnergyExportBus part) {
        this.part = part;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public int hashCode() {
        if (!this.hasHashCode) {
            this.hasHashCode = true;
            this.hashCode = this.part.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validTEs;
    }

    @Override
    public void AddTile(IEnergyTile tile, EnumFacing dir) {
        if (!this.part.getTile().func_145831_w().field_72995_K) {
            this.energyConductorMap.put(dir, tile);
            this.validTEs.add((InfoTile<IEnergyTile>)new InfoTile((Object)tile, dir.func_176734_d()));
        }
    }

    @Override
    public void RemoveTile(IEnergyTile tile, EnumFacing dir) {
        if (!this.part.getTile().func_145831_w().field_72995_K) {
            this.energyConductorMap.remove(dir);
            Iterator<InfoTile<IEnergyTile>> iter = this.validTEs.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public Map<EnumFacing, IEnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    @NotNull
    public BlockPos getBlockPos() {
        return this.part.getHost().getTile().func_174877_v();
    }

    public int getSourceTier() {
        return 14;
    }

    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing dir) {
        return dir == this.part.getSide().getFacing();
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public double canExtractEnergy() {
        return this.part.availableEnergy(CrazyAE.definitions().items().EFEnergyAsAeStack());
    }

    public void extractEnergy(double amount) {
        this.part.extractEnergy(amount, CrazyAE.definitions().items().EFEnergyAsAeStack());
    }

    public double getPerEnergy() {
        return this.perEnergy;
    }

    public double getPastEnergy() {
        return this.pastEnergy;
    }

    public void setPastEnergy(double pastEnergy) {
        this.pastEnergy = pastEnergy;
    }

    public void addPerEnergy(double setEnergy) {
        this.perEnergy = setEnergy;
    }

    public boolean isSource() {
        return true;
    }

    @Override
    public TileEntity getTileEntity() {
        return this.part.getHost().getTile();
    }
}

