/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.components;

import appeng.api.definitions.IItemDefinition;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.sytem.IAcceptor;
import com.denfop.api.sytem.ISource;
import com.denfop.api.sytem.ITile;
import com.denfop.api.sytem.InfoTile;
import dev.beecube31.crazyae2.common.components.base.BaseEnergyMoreDelegate;
import dev.beecube31.crazyae2.common.parts.implementations.PartEnergyExportBus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class ComponentMoreEnergySource
extends BaseEnergyMoreDelegate
implements ISource {
    private int hashCodeSource;
    private int hashCode;
    private boolean hasHashCode = false;
    private final IItemDefinition what;
    private final PartEnergyExportBus part;
    public double pastEnergy;
    public double perEnergy;
    public final List<InfoTile<ITile>> validTEsQS = new ArrayList<InfoTile<ITile>>();
    public final Map<EnumFacing, ITile> energyConductorMapQS = new HashMap<EnumFacing, ITile>();
    public long id;

    public ComponentMoreEnergySource(IItemDefinition what, PartEnergyExportBus part) {
        this.what = what;
        this.part = part;
    }

    public boolean emitsTo(IAcceptor receiver, EnumFacing dir) {
        return dir == this.part.getSide().getFacing();
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void AddTile(EnergyType energyType, ITile tile, EnumFacing dir) {
        if (!this.getTile().func_145831_w().field_72995_K && !this.energyConductorMapQS.containsKey(dir)) {
            this.energyConductorMapQS.put(dir, tile);
            this.validTEsQS.add((InfoTile<ITile>)new InfoTile((Object)tile, dir.func_176734_d()));
        }
    }

    @Override
    public void RemoveTile(EnergyType energyType, ITile tile, EnumFacing dir) {
        if (!this.getTile().func_145831_w().field_72995_K) {
            this.energyConductorMapQS.remove(dir);
            Iterator<InfoTile<ITile>> iter = this.validTEsQS.iterator();
            while (iter.hasNext()) {
                InfoTile<ITile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public Map<EnumFacing, ITile> getTiles(EnergyType energyType) {
        return this.energyConductorMapQS;
    }

    @Override
    public List<InfoTile<ITile>> getValidReceivers(EnergyType energyType) {
        return this.validTEsQS;
    }

    @Override
    public int hashCode() {
        if (!this.hasHashCode) {
            this.hasHashCode = true;
            this.hashCode = this.part.hashCode();
        }
        return this.hashCode;
    }

    @Override
    @NotNull
    public BlockPos getBlockPos() {
        return this.part.getHost().getTile().func_174877_v();
    }

    public double canProvideEnergy() {
        return this.part.availableEnergy(this.what);
    }

    @Override
    public TileEntity getTile() {
        return this.part.getHost().getTile();
    }

    public void extractEnergy(double amount) {
        this.part.extractEnergy(amount, this.what);
    }

    public double getPerEnergy() {
        return this.perEnergy;
    }

    public double getPastEnergy() {
        return this.pastEnergy;
    }

    public void setPastEnergy(double pastEnergy) {
        this.pastEnergy = pastEnergy;
    }

    public void addPerEnergy(double setEnergy) {
        this.perEnergy += setEnergy;
    }

    public boolean isSource() {
        return true;
    }
}

