/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.containers;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.parts.IPart;
import appeng.api.util.IConfigManager;
import appeng.container.slot.IOptionalSlotHost;
import appeng.items.contents.NetworkToolViewer;
import appeng.items.tools.ToolNetworkTool;
import appeng.parts.automation.PartExportBus;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import dev.beecube31.crazyae2.common.containers.base.CrazyAEBaseContainer;
import dev.beecube31.crazyae2.common.containers.base.slot.OptionalSlotFake;
import dev.beecube31.crazyae2.common.containers.base.slot.OptionalSlotFakeTypeOnly;
import dev.beecube31.crazyae2.common.containers.base.slot.RestrictedSlot;
import dev.beecube31.crazyae2.common.containers.base.slot.SlotFakeTypeOnly;
import dev.beecube31.crazyae2.common.containers.guisync.GuiSync;
import dev.beecube31.crazyae2.common.interfaces.IEnergyBus;
import dev.beecube31.crazyae2.common.interfaces.mana.IManaLinkableDevice;
import dev.beecube31.crazyae2.common.interfaces.upgrades.IUpgradesInfoProvider;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class ContainerCrazyAEUpgradeable
extends CrazyAEBaseContainer
implements IOptionalSlotHost {
    private final IUpgradesInfoProvider upgradeable;
    @GuiSync(value=0)
    public RedstoneMode rsMode = RedstoneMode.IGNORE;
    @GuiSync(value=1)
    public FuzzyMode fzMode = FuzzyMode.IGNORE_ALL;
    @GuiSync(value=5)
    public YesNo cMode = YesNo.NO;
    @GuiSync(value=6)
    public SchedulingMode schedulingMode = SchedulingMode.DEFAULT;
    public IManaLinkableDevice manaDevice;
    @GuiSync(value=9)
    public boolean isThisManaDevice = false;
    @GuiSync(value=10)
    public int manaDevicePosX;
    @GuiSync(value=11)
    public int manaDevicePosY;
    @GuiSync(value=12)
    public int manaDevicePosZ;
    @GuiSync(value=13)
    public boolean manaDeviceLinked;
    @GuiSync(value=14)
    public boolean isThisEnergyDevice = false;
    private int tbSlot;
    private NetworkToolViewer tbInventory;
    protected int myOffsetX = 0;

    public ContainerCrazyAEUpgradeable(InventoryPlayer ip, IUpgradesInfoProvider te) {
        super(ip, (TileEntity)(te instanceof TileEntity ? te : null), (IPart)(te instanceof IPart ? te : null));
        Preconditions.checkNotNull((Object)te);
        this.upgradeable = te;
        if (te instanceof IManaLinkableDevice) {
            this.manaDevice = (IManaLinkableDevice)((Object)te);
            this.isThisManaDevice = true;
        }
        if (te instanceof IEnergyBus) {
            this.isThisEnergyDevice = true;
        }
        World w = null;
        int xCoord = 0;
        int yCoord = 0;
        int zCoord = 0;
        if (te instanceof TileEntity) {
            TileEntity myTile = (TileEntity)te;
            w = myTile.func_145831_w();
            xCoord = myTile.func_174877_v().func_177958_n();
            yCoord = myTile.func_174877_v().func_177956_o();
            zCoord = myTile.func_174877_v().func_177952_p();
        }
        if (te instanceof IPart) {
            TileEntity mk = te.getTile();
            w = mk.func_145831_w();
            xCoord = mk.func_174877_v().func_177958_n();
            yCoord = mk.func_174877_v().func_177956_o();
            zCoord = mk.func_174877_v().func_177952_p();
        }
        InventoryPlayer pi = this.getPlayerInv();
        for (int x = 0; x < pi.func_70302_i_(); ++x) {
            ItemStack pii = pi.func_70301_a(x);
            if (pii.func_190926_b() || !(pii.func_77973_b() instanceof ToolNetworkTool)) continue;
            this.lockPlayerInventorySlot(x);
            this.tbSlot = x;
            this.tbInventory = (NetworkToolViewer)((IGuiItem)pii.func_77973_b()).getGuiObject(pii, w, new BlockPos(xCoord, yCoord, zCoord));
            break;
        }
        if (this.hasToolbox()) {
            for (int v = 0; v < 3; ++v) {
                for (int u = 0; u < 3; ++u) {
                    this.func_75146_a(new RestrictedSlot(RestrictedSlot.PlaceableItemType.UPGRADES, this.tbInventory.getInternalInventory(), u + v * 3, 187 + u * 18, this.getHeight() - this.getToolboxYOffset() + v * 18, this.getInventoryPlayer()).setPlayerSide());
                }
            }
        }
        this.setupConfig();
        this.bindPlayerInventory(ip, 0, this.getHeight() - 82);
    }

    public void setMyOffsetX(int v) {
        this.myOffsetX = v;
    }

    public void addMyOffsetX(int v) {
        this.myOffsetX += v;
    }

    public int getMyOffsetX() {
        return this.myOffsetX;
    }

    public boolean hasToolbox() {
        return this.tbInventory != null;
    }

    protected int getHeight() {
        return 184;
    }

    protected int getToolboxYOffset() {
        return 82;
    }

    protected void setupConfig() {
        this.setupUpgrades();
        if (this.isThisManaDevice || this.isThisEnergyDevice) {
            return;
        }
        IItemHandler inv = this.getUpgradeable().getInventoryByName("config");
        int y = 40;
        int x = 80;
        this.func_75146_a(new SlotFakeTypeOnly(inv, 0, 80, 40));
        if (this.supportCapacity()) {
            this.func_75146_a(new OptionalSlotFakeTypeOnly(inv, this, 1, 80, 40, -1, 0, 1));
            this.func_75146_a(new OptionalSlotFakeTypeOnly(inv, this, 2, 80, 40, 1, 0, 1));
            this.func_75146_a(new OptionalSlotFakeTypeOnly(inv, this, 3, 80, 40, 0, -1, 1));
            this.func_75146_a(new OptionalSlotFakeTypeOnly(inv, this, 4, 80, 40, 0, 1, 1));
            this.func_75146_a(new OptionalSlotFakeTypeOnly(inv, this, 5, 80, 40, -1, -1, 2));
            this.func_75146_a(new OptionalSlotFakeTypeOnly(inv, this, 6, 80, 40, 1, -1, 2));
            this.func_75146_a(new OptionalSlotFakeTypeOnly(inv, this, 7, 80, 40, -1, 1, 2));
            this.func_75146_a(new OptionalSlotFakeTypeOnly(inv, this, 8, 80, 40, 1, 1, 2));
        }
    }

    protected void setupUpgrades() {
        IItemHandler upgrades = this.getUpgradeable().getInventoryByName("upgrades");
        if (this.availableUpgrades() > 0) {
            this.func_75146_a(new RestrictedSlot(RestrictedSlot.PlaceableItemType.UPGRADES, upgrades, 0, this.hasOptionSideButton() ? 223 : 187 + this.myOffsetX, 8, this.getInventoryPlayer()).setStackLimit(1).setNotDraggable());
        }
        if (this.availableUpgrades() > 1) {
            this.func_75146_a(new RestrictedSlot(RestrictedSlot.PlaceableItemType.UPGRADES, upgrades, 1, this.hasOptionSideButton() ? 223 : 187 + this.myOffsetX, 26, this.getInventoryPlayer()).setStackLimit(1).setNotDraggable());
        }
        if (this.availableUpgrades() > 2) {
            this.func_75146_a(new RestrictedSlot(RestrictedSlot.PlaceableItemType.UPGRADES, upgrades, 2, this.hasOptionSideButton() ? 223 : 187 + this.myOffsetX, 44, this.getInventoryPlayer()).setStackLimit(1).setNotDraggable());
        }
        if (this.availableUpgrades() > 3) {
            this.func_75146_a(new RestrictedSlot(RestrictedSlot.PlaceableItemType.UPGRADES, upgrades, 3, this.hasOptionSideButton() ? 223 : 187 + this.myOffsetX, 62, this.getInventoryPlayer()).setStackLimit(1).setNotDraggable());
        }
    }

    public boolean hasOptionSideButton() {
        return false;
    }

    protected boolean supportCapacity() {
        return true;
    }

    public int availableUpgrades() {
        return 4;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            IConfigManager cm = this.getUpgradeable().getConfigManager();
            this.loadSettingsFromHost(cm);
            if (this.manaDevice != null) {
                this.manaDevicePosX = this.manaDevice.getLinkedPoolPosX();
                this.manaDevicePosY = this.manaDevice.getLinkedPoolPosY();
                this.manaDevicePosZ = this.manaDevice.getLinkedPoolPosZ();
                this.manaDeviceLinked = this.manaDevice.hasLinkedPool();
            }
        }
        this.checkToolbox();
        for (Object o : this.field_75151_b) {
            OptionalSlotFake fs;
            if (!(o instanceof OptionalSlotFake) || (fs = (OptionalSlotFake)o).isSlotEnabled() || fs.getDisplayStack().func_190926_b()) continue;
            fs.clearStack();
        }
        this.standardDetectAndSendChanges();
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setFuzzyMode((FuzzyMode)cm.getSetting(Settings.FUZZY_MODE));
        this.setRedStoneMode((RedstoneMode)cm.getSetting(Settings.REDSTONE_CONTROLLED));
        if (this.getUpgradeable() instanceof PartExportBus) {
            this.setCraftingMode((YesNo)cm.getSetting(Settings.CRAFT_ONLY));
            this.setSchedulingMode((SchedulingMode)cm.getSetting(Settings.SCHEDULING_MODE));
        }
    }

    protected void checkToolbox() {
        ItemStack currentItem;
        if (this.hasToolbox() && (currentItem = this.getPlayerInv().func_70301_a(this.tbSlot)) != this.tbInventory.getItemStack()) {
            if (!currentItem.func_190926_b()) {
                if (ItemStack.func_179545_c((ItemStack)this.tbInventory.getItemStack(), (ItemStack)currentItem)) {
                    this.getPlayerInv().func_70299_a(this.tbSlot, this.tbInventory.getItemStack());
                } else {
                    this.setValidContainer(false);
                }
            } else {
                this.setValidContainer(false);
            }
        }
    }

    protected void standardDetectAndSendChanges() {
        super.func_75142_b();
    }

    public boolean isSlotEnabled(int idx) {
        int upgrades = this.getUpgradeable().getInstalledUpgrades(Upgrades.CAPACITY);
        if (idx == 1 && upgrades > 0) {
            return true;
        }
        return idx == 2 && upgrades > 1;
    }

    public FuzzyMode getFuzzyMode() {
        return this.fzMode;
    }

    public void setFuzzyMode(FuzzyMode fzMode) {
        this.fzMode = fzMode;
    }

    public YesNo getCraftingMode() {
        return this.cMode;
    }

    public void setCraftingMode(YesNo cMode) {
        this.cMode = cMode;
    }

    public RedstoneMode getRedStoneMode() {
        return this.rsMode;
    }

    public void setRedStoneMode(RedstoneMode rsMode) {
        this.rsMode = rsMode;
    }

    public SchedulingMode getSchedulingMode() {
        return this.schedulingMode;
    }

    public void setSchedulingMode(SchedulingMode schedulingMode) {
        this.schedulingMode = schedulingMode;
    }

    public IUpgradesInfoProvider getUpgradeable() {
        return this.upgradeable;
    }

    public IManaLinkableDevice getManaDevice() {
        return this.manaDevice;
    }

    public boolean isThisManaDevice() {
        return this.isThisManaDevice;
    }

    public int getManaDevicePoolPosX() {
        return this.manaDevicePosX;
    }

    public int getManaDevicePoolPosY() {
        return this.manaDevicePosY;
    }

    public int getManaDevicePoolPosZ() {
        return this.manaDevicePosZ;
    }

    public boolean manaDeviceHasPool() {
        return this.manaDeviceLinked;
    }
}

