/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.crazyae2.common.containers;

import appeng.api.config.CondenserOutput;
import appeng.api.config.Settings;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import dev.beecube31.crazyae2.common.containers.base.CrazyAEBaseContainer;
import dev.beecube31.crazyae2.common.containers.base.slot.RestrictedSlot;
import dev.beecube31.crazyae2.common.containers.base.slot.SlotOutput;
import dev.beecube31.crazyae2.common.containers.guisync.GuiSync;
import dev.beecube31.crazyae2.common.interfaces.gui.ICrazyAEProgressProvider;
import dev.beecube31.crazyae2.common.tile.misc.TileImprovedCondenser;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;

public class ContainerImprovedCondenser
extends CrazyAEBaseContainer
implements ICrazyAEProgressProvider {
    private final TileImprovedCondenser condenser;
    @GuiSync(value=10)
    public long requiredEnergy = 0L;
    @GuiSync(value=11)
    public long storedPower = 0L;
    @GuiSync(value=12)
    public CondenserOutput output = CondenserOutput.TRASH;
    private final ItemStack prevStack = ItemStack.field_190927_a;
    private final IItemHandler inv;

    public ContainerImprovedCondenser(InventoryPlayer ip, TileImprovedCondenser condenser) {
        super(ip, (TileEntity)condenser, null);
        this.condenser = condenser;
        this.inv = condenser.getInternalInventory();
        for (int x = 0; x < 5; ++x) {
            for (int j = 0; j < 5; ++j) {
                this.func_75146_a(new RestrictedSlot(RestrictedSlot.PlaceableItemType.TRASH, this.inv, j + x * 5, 8 + x * 18, 13 + j * 18, ip));
            }
        }
        for (int i = 0; i < 2; ++i) {
            for (int y = 0; y < 2; ++y) {
                this.func_75146_a(new SlotOutput(this.inv, y + i * 2 + 25, 134 + i * 18, 40 + y * 18, null));
            }
        }
        this.func_75146_a(new RestrictedSlot(RestrictedSlot.PlaceableItemType.STORAGE_COMPONENT, this.inv, 29, 134, 13, ip).setStackLimit(1));
        this.bindPlayerInventory(ip, 0, 115);
    }

    @Override
    public void func_75142_b() {
        if (Platform.isServer()) {
            double maxStorage = this.condenser.getStorage();
            double requiredEnergy = this.condenser.getRequiredPower();
            this.requiredEnergy = requiredEnergy == 0.0 ? (long)((int)maxStorage) : (long)((int)Math.min(requiredEnergy, maxStorage));
            this.storedPower = (int)this.condenser.getStoredPower();
            this.setOutput((CondenserOutput)this.condenser.getConfigManager().getSetting(Settings.CONDENSER_OUTPUT));
            for (IContainerListener listener : this.field_75149_d) {
                for (int i = 25; i < 29; ++i) {
                    ItemStack is = this.inv.getStackInSlot(i);
                    if (ItemStack.func_179545_c((ItemStack)is, (ItemStack)this.prevStack)) continue;
                    listener.func_71111_a((Container)this, i - 25, is);
                }
            }
        }
        super.func_75142_b();
    }

    @Override
    public double getCurrentProgress() {
        return (int)this.storedPower;
    }

    @Override
    public double getMaxProgress() {
        return this.requiredEnergy;
    }

    public CondenserOutput getOutput() {
        return this.output;
    }

    private void setOutput(CondenserOutput output) {
        this.output = output;
    }

    @Override
    public String getTooltip(String title, boolean disableMaxProgress, int tooltipID) {
        return title + "\n" + this.getCurrentProgress(tooltipID) + ' ' + GuiText.Of.getLocal() + ' ' + this.getMaxProgress(tooltipID);
    }
}

